"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonorepoJavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const java_1 = require("projen/lib/java");
const nx_configurator_1 = require("../../components/nx-configurator");
const MVN_PLUGIN_PATH = "./.nx/plugins/nx_plugin.js";
/**
 * This project type will bootstrap a NX based monorepo with support for polygot
 * builds, build caching, dependency graph visualization and much more.
 *
 * @pjid monorepo-java
 */
class MonorepoJavaProject extends java_1.JavaProject {
    constructor(options) {
        super({
            ...options,
            sample: false,
            junit: false,
            version: options.version ?? "0.0.0",
            groupId: options.groupId ?? "com.aws",
            artifactId: options.artifactId ?? "monorepo",
        });
        this.addTestDependency("software.aws/pdk@^0");
        this.nxConfigurator = new nx_configurator_1.NxConfigurator(this, {
            defaultReleaseBranch: options.defaultReleaseBranch ?? "main",
        });
        // Setup maven nx plugin
        new projen_1.TextFile(this, MVN_PLUGIN_PATH, {
            readonly: true,
            lines: fs
                .readFileSync(path.join(__dirname, "plugin/mvn_plugin.js"))
                .toString("utf-8")
                .split("\n"),
        });
        this.nx.plugins.push("@jnxplus/nx-maven", MVN_PLUGIN_PATH);
        this.installTask = this.nxConfigurator.ensureNxInstallTask({
            "@jnxplus/nx-maven": "^0.x",
        });
        // Map tasks to nx run-many
        this.nxConfigurator._overrideNxBuildTask(this.buildTask, { target: "build" }, { force: true });
        this.nxConfigurator._overrideNxBuildTask(this.preCompileTask, {
            target: "pre-compile",
        });
        this.nxConfigurator._overrideNxBuildTask(this.compileTask, {
            target: "compile",
        });
        this.nxConfigurator._overrideNxBuildTask(this.postCompileTask, {
            target: "post-compile",
        });
        this.nxConfigurator._overrideNxBuildTask(this.testTask, {
            target: "test",
        });
        this.nxConfigurator._overrideNxBuildTask(this.packageTask, {
            target: "package",
        });
    }
    /**
     * @inheritdoc
     */
    get nx() {
        return this.nxConfigurator.nx;
    }
    /**
     * @inheritdoc
     */
    execNxRunManyCommand(options) {
        return this.nxConfigurator.execNxRunManyCommand(options);
    }
    /**
     * @inheritdoc
     */
    composeNxRunManyCommand(options) {
        return this.nxConfigurator.composeNxRunManyCommand(options);
    }
    /**
     * @inheritdoc
     */
    addNxRunManyTask(name, options) {
        return this.nxConfigurator.addNxRunManyTask(name, options);
    }
    /**
     * @inheritdoc
     */
    addImplicitDependency(dependent, dependee) {
        this.nxConfigurator.addImplicitDependency(dependent, dependee);
    }
    /**
     * @inheritdoc
     */
    addJavaDependency(dependent, dependee) {
        this.nxConfigurator.addJavaDependency(dependent, dependee);
    }
    /**
     * @inheritdoc
     */
    addPythonPoetryDependency(dependent, dependee) {
        this.nxConfigurator.addPythonPoetryDependency(dependent, dependee);
    }
    /**
     * @inheritdoc
     */
    preSynthesize() {
        // Calling before super() to ensure proper pre-synth of NxProject component and its nested components
        this.nxConfigurator.preSynthesize();
        super.preSynthesize();
    }
    /**
     * @inheritDoc
     */
    synth() {
        this.nxConfigurator.synth();
        super.synth();
    }
    postSynthesize() {
        super.postSynthesize();
        this.installNx();
    }
    /**
     * Run the install task which will install nx locally
     */
    installNx() {
        this.logger.info("Installing dependencies...");
        const runtime = new projen_1.TaskRuntime(this.outdir);
        runtime.runTask(this.installTask.name);
    }
}
exports.MonorepoJavaProject = MonorepoJavaProject;
_a = JSII_RTTI_SYMBOL_1;
MonorepoJavaProject[_a] = { fqn: "@aws/pdk.monorepo.MonorepoJavaProject", version: "0.22.14" };
//# sourceMappingURL=data:application/json;base64,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