/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Project, Task } from "projen";
import { JavaProject } from "projen/lib/java";
import { PythonProject } from "projen/lib/python";
import { PythonProjectOptions } from "./python-project-options";
import { INxProjectCore, NxConfigurator } from "../../components/nx-configurator";
import { NxWorkspace } from "../../components/nx-workspace";
import { Nx } from "../../nx-types";
/**
 * Configuration options for the NxMonorepoPythonProject.
 */
export interface MonorepoPythonProjectOptions extends PythonProjectOptions {
    readonly defaultReleaseBranch?: string;
}
/**
 * This project type will bootstrap a NX based monorepo with support for polygot
 * builds, build caching, dependency graph visualization and much more.
 *
 * @pjid monorepo-py
 */
export declare class MonorepoPythonProject extends PythonProject implements INxProjectCore {
    readonly nxConfigurator: NxConfigurator;
    private readonly installTask?;
    constructor(options: MonorepoPythonProjectOptions);
    /**
     * @inheritdoc
     */
    get nx(): NxWorkspace;
    /**
     * @inheritdoc
     */
    execNxRunManyCommand(options: Nx.RunManyOptions): string;
    /**
     * @inheritdoc
     */
    composeNxRunManyCommand(options: Nx.RunManyOptions): string[];
    /**
     * @inheritdoc
     */
    addNxRunManyTask(name: string, options: Nx.RunManyOptions): Task;
    /**
     * @inheritdoc
     */
    addImplicitDependency(dependent: Project, dependee: string | Project): void;
    /**
     * @inheritdoc
     */
    addJavaDependency(dependent: JavaProject, dependee: JavaProject): void;
    /**
     * @inheritdoc
     */
    addPythonPoetryDependency(dependent: PythonProject, dependee: PythonProject): void;
    /**
     * @inheritdoc
     */
    preSynthesize(): void;
    /**
     * @inheritDoc
     */
    synth(): void;
    /**
     * @inheritdoc
     *
     * NOTE: Be sure to ensure the VIRTUAL_ENV is unset during postSynthesize as the individual poetry envs will only be created if a existing VIRTUAL_ENV cannot be found.
     */
    postSynthesize(): void;
    /**
     * Ensures all python subprojects have their install target called after the monorepo install task.
     */
    private installPythonSubprojects;
    /**
     * Ensures subprojects don't have a default task and that all Python subpackages are configured to use Poetry.
     */
    private validateSubProjects;
}
