"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonorepoPythonProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const javascript_1 = require("projen/lib/javascript");
const python_1 = require("projen/lib/python");
const nx_configurator_1 = require("../../components/nx-configurator");
const nx_project_1 = require("../../components/nx-project");
const utils_1 = require("../../utils");
/**
 * This project type will bootstrap a NX based monorepo with support for polygot
 * builds, build caching, dependency graph visualization and much more.
 *
 * @pjid monorepo-py
 */
class MonorepoPythonProject extends python_1.PythonProject {
    constructor(options) {
        super({
            ...options,
            sample: false,
            poetry: true,
            pytest: options.pytest ?? false,
            version: options.version ?? "0.0.0",
            authorName: options.authorName ?? "pdkuser",
            authorEmail: options.authorEmail ?? "user@pdk.com",
        });
        this.addDevDependency("aws_pdk@^0");
        this.nxConfigurator = new nx_configurator_1.NxConfigurator(this, {
            defaultReleaseBranch: options.defaultReleaseBranch ?? "main",
        });
        // Setup python NX plugin
        this.nx.plugins.push("@nxlv/python");
        this.installTask = this.nxConfigurator.ensureNxInstallTask({
            "@nxlv/python": "^16",
        });
        // Map tasks to nx run-many
        this.nxConfigurator._overrideNxBuildTask(this.buildTask, { target: "build" }, { force: true });
        this.nxConfigurator._overrideNxBuildTask(this.preCompileTask, {
            target: "pre-compile",
        });
        this.nxConfigurator._overrideNxBuildTask(this.compileTask, {
            target: "compile",
        });
        this.nxConfigurator._overrideNxBuildTask(this.postCompileTask, {
            target: "post-compile",
        });
        this.nxConfigurator._overrideNxBuildTask(this.testTask, {
            target: "test",
        });
        this.nxConfigurator._overrideNxBuildTask(this.packageTask, {
            target: "package",
        });
    }
    /**
     * @inheritdoc
     */
    get nx() {
        return this.nxConfigurator.nx;
    }
    /**
     * @inheritdoc
     */
    execNxRunManyCommand(options) {
        return this.nxConfigurator.execNxRunManyCommand(options);
    }
    /**
     * @inheritdoc
     */
    composeNxRunManyCommand(options) {
        return this.nxConfigurator.composeNxRunManyCommand(options);
    }
    /**
     * @inheritdoc
     */
    addNxRunManyTask(name, options) {
        return this.nxConfigurator.addNxRunManyTask(name, options);
    }
    /**
     * @inheritdoc
     */
    addImplicitDependency(dependent, dependee) {
        this.nxConfigurator.addImplicitDependency(dependent, dependee);
    }
    /**
     * @inheritdoc
     */
    addJavaDependency(dependent, dependee) {
        this.nxConfigurator.addJavaDependency(dependent, dependee);
    }
    /**
     * @inheritdoc
     */
    addPythonPoetryDependency(dependent, dependee) {
        this.nxConfigurator.addPythonPoetryDependency(dependent, dependee);
    }
    /**
     * @inheritdoc
     */
    preSynthesize() {
        // Calling before super() to ensure proper pre-synth of NxProject component and its nested components
        this.nxConfigurator.preSynthesize();
        super.preSynthesize();
    }
    /**
     * @inheritDoc
     */
    synth() {
        this.validateSubProjects();
        this.installPythonSubprojects();
        this.nxConfigurator.synth();
        super.synth();
    }
    /**
     * @inheritdoc
     *
     * NOTE: Be sure to ensure the VIRTUAL_ENV is unset during postSynthesize as the individual poetry envs will only be created if a existing VIRTUAL_ENV cannot be found.
     */
    postSynthesize() {
        const vEnv = process.env.VIRTUAL_ENV;
        process.env.VIRTUAL_ENV = "";
        super.postSynthesize();
        process.env.VIRTUAL_ENV = vEnv;
    }
    /**
     * Ensures all python subprojects have their install target called after the monorepo install task.
     */
    installPythonSubprojects() {
        const installProjects = this.subprojects.filter((project) => isPythonProject(project) && this.installTask);
        if (this.installTask && installProjects.length > 0) {
            const nxRunManyInstall = this.composeNxRunManyCommand({
                target: "install",
                projects: installProjects.map((project) => project.name),
                parallel: 1,
            });
            this.installTask.exec(utils_1.NodePackageUtils.command.exec(javascript_1.NodePackageManager.NPM, ...nxRunManyInstall));
            // Ensure that install-py follows dependency order
            installProjects.forEach((p) => {
                nx_project_1.NxProject.ensure(p).setTarget("install", {
                    dependsOn: ["^install"],
                });
            });
        }
    }
    /**
     * Ensures subprojects don't have a default task and that all Python subpackages are configured to use Poetry.
     */
    validateSubProjects() {
        this.subprojects.forEach((subProject) => {
            // Disable default task on subprojects as this isn't supported in a monorepo
            subProject.defaultTask?.reset();
            if (isPythonProject(subProject) && !isPoetryConfigured(subProject)) {
                throw new Error(`${subProject.name} must use poetry to manage dependencies when using NXMonorepoPythonProject`);
            }
        });
    }
}
exports.MonorepoPythonProject = MonorepoPythonProject;
_a = JSII_RTTI_SYMBOL_1;
MonorepoPythonProject[_a] = { fqn: "@aws/pdk.monorepo.MonorepoPythonProject", version: "0.22.14" };
/**
 * Determines if the passed in project is of type PythonProject.
 *
 * @param project Project instance.
 * @returns true if the project instance is of type PythonProject.
 */
function isPythonProject(project) {
    return utils_1.ProjectUtils.isNamedInstanceOf(project, python_1.PythonProject);
}
/**
 * Determines if the passed in project uses Poetry.
 *
 * @param project PythonProject instance.
 * @returns true if the project uses Poetry.
 */
function isPoetryConfigured(project) {
    return (project.components.find((c) => utils_1.ProjectUtils.isNamedInstanceOf(c, python_1.Poetry)) !== undefined);
}
//# sourceMappingURL=data:application/json;base64,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