"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectUtils = void 0;
/**
 * Utility for projen projects
 * @experimental
 */
var ProjectUtils;
(function (ProjectUtils) {
    /**
     * List all parent class names of the given class (includes the given class's name as the last element)
     * @internal
     */
    function listParentClassNames(clazz) {
        if (!clazz?.name) {
            return [];
        }
        return [...listParentClassNames(Object.getPrototypeOf(clazz)), clazz.name];
    }
    /**
     * Returns whether the given project is an instance of the given project class.
     * Uses the class name to perform this check, such that the check still passes for
     * classes imported from mismatching package versions.
     */
    function isNamedInstanceOf(instance, clazz) {
        return new Set(listParentClassNames(instance.constructor)).has(clazz.name);
    }
    ProjectUtils.isNamedInstanceOf = isNamedInstanceOf;
})(ProjectUtils || (exports.ProjectUtils = ProjectUtils = {}));
//# sourceMappingURL=data:application/json;base64,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