"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNoneAuthorizer = exports.isIamAuthorizer = exports.isCognitoAuthorizer = exports.isCustomAuthorizer = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
/**
 * Predicate for narrowing an authorizer to CustomAuthorizer
 */
const isCustomAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.CUSTOM;
exports.isCustomAuthorizer = isCustomAuthorizer;
/**
 * Predicate for narrowing an authorizer to CognitoAuthorizer
 */
const isCognitoAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.COGNITO;
exports.isCognitoAuthorizer = isCognitoAuthorizer;
/**
 * Predicate for narrowing an authorizer to IamAuthorizer
 */
const isIamAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.IAM;
exports.isIamAuthorizer = isIamAuthorizer;
/**
 * Predicate for narrowing an authorizer to NoneAuthorizer
 */
const isNoneAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.NONE;
exports.isNoneAuthorizer = isNoneAuthorizer;
//# sourceMappingURL=data:application/json;base64,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