/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { IFunction } from "aws-cdk-lib/aws-lambda";
import { LambdaIntegration } from "./lambda";
import { MockIntegration, MockIntegrationResponse } from "./mock";
/**
 * A collection of integrations to connect API operations with a backend to service requests
 */
export declare class Integrations {
    /**
     * An integration that invokes a lambda function to service the request
     * @param lambdaFunction the function to invoke
     */
    static lambda(lambdaFunction: IFunction): LambdaIntegration;
    /**
     * An integration that returns a hardcoded response
     * @param response the response to return
     */
    static mock(response: MockIntegrationResponse): MockIntegration;
}
