"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Integrations = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda_1 = require("./lambda");
const mock_1 = require("./mock");
/**
 * A collection of integrations to connect API operations with a backend to service requests
 */
class Integrations {
    /**
     * An integration that invokes a lambda function to service the request
     * @param lambdaFunction the function to invoke
     */
    static lambda(lambdaFunction) {
        return new lambda_1.LambdaIntegration(lambdaFunction);
    }
    /**
     * An integration that returns a hardcoded response
     * @param response the response to return
     */
    static mock(response) {
        return new mock_1.MockIntegration(response);
    }
}
exports.Integrations = Integrations;
_a = JSII_RTTI_SYMBOL_1;
Integrations[_a] = { fqn: "@aws/pdk.type_safe_api.Integrations", version: "0.22.14" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWdyYXRpb25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWdyYXRpb25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBR0EscUNBQTZDO0FBQzdDLGlDQUFrRTtBQUVsRTs7R0FFRztBQUNILE1BQWEsWUFBWTtJQUN2Qjs7O09BR0c7SUFDSSxNQUFNLENBQUMsTUFBTSxDQUFDLGNBQXlCO1FBQzVDLE9BQU8sSUFBSSwwQkFBaUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBRUQ7OztPQUdHO0lBQ0ksTUFBTSxDQUFDLElBQUksQ0FBQyxRQUFpQztRQUNsRCxPQUFPLElBQUksc0JBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUN2QyxDQUFDOztBQWZILG9DQWdCQyIsInNvdXJjZXNDb250ZW50IjpbIi8qISBDb3B5cmlnaHQgW0FtYXpvbi5jb21dKGh0dHA6Ly9hbWF6b24uY29tLyksIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMCAqL1xuaW1wb3J0IHsgSUZ1bmN0aW9uIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1sYW1iZGFcIjtcbmltcG9ydCB7IExhbWJkYUludGVncmF0aW9uIH0gZnJvbSBcIi4vbGFtYmRhXCI7XG5pbXBvcnQgeyBNb2NrSW50ZWdyYXRpb24sIE1vY2tJbnRlZ3JhdGlvblJlc3BvbnNlIH0gZnJvbSBcIi4vbW9ja1wiO1xuXG4vKipcbiAqIEEgY29sbGVjdGlvbiBvZiBpbnRlZ3JhdGlvbnMgdG8gY29ubmVjdCBBUEkgb3BlcmF0aW9ucyB3aXRoIGEgYmFja2VuZCB0byBzZXJ2aWNlIHJlcXVlc3RzXG4gKi9cbmV4cG9ydCBjbGFzcyBJbnRlZ3JhdGlvbnMge1xuICAvKipcbiAgICogQW4gaW50ZWdyYXRpb24gdGhhdCBpbnZva2VzIGEgbGFtYmRhIGZ1bmN0aW9uIHRvIHNlcnZpY2UgdGhlIHJlcXVlc3RcbiAgICogQHBhcmFtIGxhbWJkYUZ1bmN0aW9uIHRoZSBmdW5jdGlvbiB0byBpbnZva2VcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgbGFtYmRhKGxhbWJkYUZ1bmN0aW9uOiBJRnVuY3Rpb24pOiBMYW1iZGFJbnRlZ3JhdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBMYW1iZGFJbnRlZ3JhdGlvbihsYW1iZGFGdW5jdGlvbik7XG4gIH1cblxuICAvKipcbiAgICogQW4gaW50ZWdyYXRpb24gdGhhdCByZXR1cm5zIGEgaGFyZGNvZGVkIHJlc3BvbnNlXG4gICAqIEBwYXJhbSByZXNwb25zZSB0aGUgcmVzcG9uc2UgdG8gcmV0dXJuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIG1vY2socmVzcG9uc2U6IE1vY2tJbnRlZ3JhdGlvblJlc3BvbnNlKTogTW9ja0ludGVncmF0aW9uIHtcbiAgICByZXR1cm4gbmV3IE1vY2tJbnRlZ3JhdGlvbihyZXNwb25zZSk7XG4gIH1cbn1cbiJdfQ==