"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.functionInvocationUri = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Generate the lambda function invocation uri for the given lambda within the given scope
 * @param lambdaFunction the lambda function to be invoked
 */
const functionInvocationUri = (lambdaFunction) => {
    const stack = aws_cdk_lib_1.Stack.of(lambdaFunction);
    return `arn:${stack.partition}:apigateway:${stack.region}:lambda:path/2015-03-31/functions/${lambdaFunction.functionArn}/invocations`;
};
exports.functionInvocationUri = functionInvocationUri;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTtzQ0FDc0M7QUFDdEMsNkNBQW9DO0FBR3BDOzs7R0FHRztBQUNJLE1BQU0scUJBQXFCLEdBQUcsQ0FBQyxjQUF5QixFQUFVLEVBQUU7SUFDekUsTUFBTSxLQUFLLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDdkMsT0FBTyxPQUFPLEtBQUssQ0FBQyxTQUFTLGVBQWUsS0FBSyxDQUFDLE1BQU0scUNBQXFDLGNBQWMsQ0FBQyxXQUFXLGNBQWMsQ0FBQztBQUN4SSxDQUFDLENBQUM7QUFIVyxRQUFBLHFCQUFxQix5QkFHaEMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbmltcG9ydCB7IFN0YWNrIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQgeyBJRnVuY3Rpb24gfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWxhbWJkYVwiO1xuXG4vKipcbiAqIEdlbmVyYXRlIHRoZSBsYW1iZGEgZnVuY3Rpb24gaW52b2NhdGlvbiB1cmkgZm9yIHRoZSBnaXZlbiBsYW1iZGEgd2l0aGluIHRoZSBnaXZlbiBzY29wZVxuICogQHBhcmFtIGxhbWJkYUZ1bmN0aW9uIHRoZSBsYW1iZGEgZnVuY3Rpb24gdG8gYmUgaW52b2tlZFxuICovXG5leHBvcnQgY29uc3QgZnVuY3Rpb25JbnZvY2F0aW9uVXJpID0gKGxhbWJkYUZ1bmN0aW9uOiBJRnVuY3Rpb24pOiBzdHJpbmcgPT4ge1xuICBjb25zdCBzdGFjayA9IFN0YWNrLm9mKGxhbWJkYUZ1bmN0aW9uKTtcbiAgcmV0dXJuIGBhcm46JHtzdGFjay5wYXJ0aXRpb259OmFwaWdhdGV3YXk6JHtzdGFjay5yZWdpb259OmxhbWJkYTpwYXRoLzIwMTUtMDMtMzEvZnVuY3Rpb25zLyR7bGFtYmRhRnVuY3Rpb24uZnVuY3Rpb25Bcm59L2ludm9jYXRpb25zYDtcbn07XG4iXX0=