import { JsonFile, Project } from "projen";
import { OpenApiGeneratorCliConfig } from "../../types";
/**
 * Represents an openapitools.json file
 * @see https://github.com/OpenAPITools/openapi-generator-cli#configuration
 */
export declare class OpenApiToolsJsonFile extends JsonFile {
    /**
     * Retrieves an instance of OpenApiToolsJsonFile if one is associated to the given project.
     *
     * @param project project instance.
     */
    static of(project: Project): OpenApiToolsJsonFile | undefined;
    /**
     * Retrieves an instance of OpenApiToolsJsonFile if one is associated to the given project,
     * otherwise creates a OpenApiToolsJsonFile instance for the project.
     *
     * @param project project instance.
     */
    static ensure(project: Project): OpenApiToolsJsonFile;
    /**
     * Configuration for OpenAPI Generator CLI
     * @private
     */
    private config;
    constructor(project: Project);
    /**
     * Update the OpenAPI Generator config. Shallow-merges with any existing default config
     */
    addOpenApiGeneratorCliConfig(config?: OpenApiGeneratorCliConfig): void;
}
