"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSafeApiCommandEnvironment = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const monorepo_1 = require("../../../../monorepo");
const projen_1 = require("projen");
const utils_1 = require("./utils");
/**
 * Component for setting up the environemnt for type safe api commands
 */
class TypeSafeApiCommandEnvironment extends projen_1.Component {
    /**
     * Retrieves an instance of TypeSafeApiCommandEnvironment if one is associated to the given project.
     *
     * @param project project instance.
     */
    static of(project) {
        return project.components.find((c) => monorepo_1.ProjectUtils.isNamedInstanceOf(c, TypeSafeApiCommandEnvironment));
    }
    /**
     * Retrieves an instance of TypeSafeApiCommandEnvironment if one is associated to the given project,
     * otherwise creates a TypeSafeApiCommandEnvironment instance for the project.
     *
     * @param project project instance.
     */
    static ensure(project) {
        return (TypeSafeApiCommandEnvironment.of(project) ||
            new TypeSafeApiCommandEnvironment(project));
    }
    constructor(project) {
        super(project);
        // Add all environment variables to the task environment
        Object.entries((0, utils_1.getTypeSafeApiTaskEnvironment)()).forEach(([key, value]) => project.tasks.addEnvironment(key, value));
    }
}
exports.TypeSafeApiCommandEnvironment = TypeSafeApiCommandEnvironment;
//# sourceMappingURL=data:application/json;base64,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