"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPlantumlDocumentationProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const open_api_tools_json_file_1 = require("../components/open-api-tools-json-file");
const type_safe_api_command_environment_1 = require("../components/type-safe-api-command-environment");
const utils_1 = require("../components/utils");
class GeneratedPlantumlDocumentationProject extends projen_1.Project {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        // Add OpenAPI Generator cli configuration
        open_api_tools_json_file_1.OpenApiToolsJsonFile.ensure(this).addOpenApiGeneratorCliConfig(options.openApiGeneratorCliConfig);
        this.generateTask = this.addTask("generate");
        this.generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.GENERATE, (0, utils_1.buildInvokeOpenApiGeneratorCommandArgs)({
            generator: languages_1.DocumentationFormat.PLANTUML,
            specPath: options.specPath,
            generatorDirectory: utils_1.OtherGenerators.DOCS,
        })));
        this.compileTask.spawn(this.generateTask);
        this.gitignore.addPatterns(".openapi-generator", "schemas.plantuml");
    }
}
exports.GeneratedPlantumlDocumentationProject = GeneratedPlantumlDocumentationProject;
//# sourceMappingURL=data:application/json;base64,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