import { JavaProject } from "projen/lib/java";
import { CodeGenerationSourceOptions, GeneratedJavaHandlersOptions } from "../../types";
import { GeneratedJavaRuntimeProject } from "../runtime/generated-java-runtime-project";
export interface GeneratedJavaHandlersProjectOptions extends GeneratedJavaHandlersOptions, CodeGenerationSourceOptions {
    /**
     * The generated java types
     */
    readonly generatedJavaTypes: GeneratedJavaRuntimeProject;
}
export declare class GeneratedJavaHandlersProject extends JavaProject {
    /**
     * Options configured for the project
     * @private
     */
    private readonly options;
    /**
     * Source directory
     * @private
     */
    private readonly srcDir;
    /**
     * Java package name
     */
    readonly packageName: string;
    constructor(options: GeneratedJavaHandlersProjectOptions);
    buildGenerateCommandArgs: () => string;
}
