import { TypeScriptProject } from "projen/lib/typescript";
import { CodeGenerationSourceOptions, GeneratedTypeScriptHandlersOptions } from "../../types";
import { GeneratedTypescriptRuntimeProject } from "../runtime/generated-typescript-runtime-project";
export interface GeneratedTypescriptHandlersProjectOptions extends GeneratedTypeScriptHandlersOptions, CodeGenerationSourceOptions {
    /**
     * Generated typescript types project
     */
    readonly generatedTypescriptTypes: GeneratedTypescriptRuntimeProject;
    /**
     * Whether the infrastructure and client projects are parented by an monorepo or not
     */
    readonly isWithinMonorepo?: boolean;
}
export declare class GeneratedTypescriptHandlersProject extends TypeScriptProject {
    /**
     * Options configured for the project
     * @private
     */
    private readonly options;
    constructor(options: GeneratedTypescriptHandlersProjectOptions);
    buildGenerateCommandArgs: () => string;
}
