import { TypeScriptProject } from "projen/lib/typescript";
import { CodeGenerationSourceOptions, GeneratedTypeScriptInfrastructureOptions } from "../../../types";
import { GeneratedHandlersProjects } from "../../generate";
import { GeneratedTypescriptRuntimeProject } from "../../runtime/generated-typescript-runtime-project";
export interface GeneratedTypescriptCdkInfrastructureProjectOptions extends GeneratedTypeScriptInfrastructureOptions, CodeGenerationSourceOptions {
    /**
     * Generated typescript types project
     */
    readonly generatedTypescriptTypes: GeneratedTypescriptRuntimeProject;
    /**
     * Generated handlers projects
     */
    readonly generatedHandlers: GeneratedHandlersProjects;
    /**
     * Whether the infrastructure and client projects are parented by an monorepo or not
     */
    readonly isWithinMonorepo?: boolean;
}
export declare class GeneratedTypescriptCdkInfrastructureProject extends TypeScriptProject {
    /**
     * Options configured for the project
     * @private
     */
    private readonly options;
    /**
     * Path to the packaged copy of the openapi specification
     * @private
     */
    private readonly packagedSpecPath;
    constructor(options: GeneratedTypescriptCdkInfrastructureProjectOptions);
    buildGenerateCommandArgs: () => string;
    buildGenerateMockDataCommand: () => string;
}
