import { TypeScriptProject } from "projen/lib/typescript";
import { CodeGenerationSourceOptions, GeneratedTypeScriptRuntimeOptions } from "../../types";
/**
 * Configuration for the generated typescript client project
 */
export interface GeneratedTypescriptTypesProjectOptions extends GeneratedTypeScriptRuntimeOptions, CodeGenerationSourceOptions {
    /**
     * Whether this project is parented by an monorepo or not
     */
    readonly isWithinMonorepo?: boolean;
}
/**
 * Typescript project containing types generated using OpenAPI Generator CLI
 */
export declare class GeneratedTypescriptRuntimeProject extends TypeScriptProject {
    /**
     * Patterns that are excluded from code generation
     */
    static openApiIgnorePatterns: string[];
    /**
     * Options configured for the project
     * @private
     */
    private readonly options;
    constructor(options: GeneratedTypescriptTypesProjectOptions);
    buildGenerateCommandArgs: () => string;
}
