"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocumentationFormat = exports.Library = exports.Language = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Supported languages for runtimes and infrastructure
 */
var Language;
(function (Language) {
    Language["TYPESCRIPT"] = "typescript";
    Language["PYTHON"] = "python";
    Language["JAVA"] = "java";
})(Language || (exports.Language = Language = {}));
/**
 * Supported libraries for code generation
 */
var Library;
(function (Library) {
    Library["TYPESCRIPT_REACT_QUERY_HOOKS"] = "typescript-react-query-hooks";
})(Library || (exports.Library = Library = {}));
/**
 * Formats for documentation generation
 */
var DocumentationFormat;
(function (DocumentationFormat) {
    /**
     * HTML Documentation generated by redoc
     * @see https://github.com/Redocly/redoc
     */
    DocumentationFormat["HTML_REDOC"] = "html_redoc";
    /**
     * OpenAPI Generator 'html2' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/html2.md
     */
    DocumentationFormat["HTML2"] = "html2";
    /**
     * OpenAPI Generator 'markdown' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/markdown.md
     */
    DocumentationFormat["MARKDOWN"] = "markdown";
    /**
     * OpenAPI Generator 'plantuml' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/plantuml.md
     */
    DocumentationFormat["PLANTUML"] = "plantuml";
})(DocumentationFormat || (exports.DocumentationFormat = DocumentationFormat = {}));
//# sourceMappingURL=data:application/json;base64,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