/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Component } from "projen";
import { Language } from "../../languages";
import { OpenApiModelOptions } from "../../types";
import { TypeSafeApiModelProject } from "../type-safe-api-model-project";
/**
 * Options for the OpenAPI Spec
 */
export interface OpenApiDefinitionOptions {
    /**
     * Options for the openapi model
     */
    readonly openApiOptions: OpenApiModelOptions;
    /**
     * The languages users have specified for handler projects (if any)
     */
    readonly handlerLanguages?: Language[];
}
/**
 * The OpenAPI Spec
 */
export declare class OpenApiDefinition extends Component {
    /**
     * Path to the root OpenAPI specification file
     */
    readonly openApiSpecificationPath: string;
    constructor(project: TypeSafeApiModelProject, options: OpenApiDefinitionOptions);
}
