import { Project, ProjectOptions, Task } from "projen";
import { OpenApiDefinition } from "./openapi/open-api-definition";
import { SmithyDefinition } from "./smithy/smithy-definition";
import { Language } from "../languages";
import { ModelLanguage, ModelOptions } from "../types";
export interface TypeSafeApiModelProjectOptions extends ProjectOptions {
    /**
     * Language the model is defined in
     */
    readonly modelLanguage: ModelLanguage;
    /**
     * Options for the model
     */
    readonly modelOptions: ModelOptions;
    /**
     * The languages users have specified for handler projects (if any)
     */
    readonly handlerLanguages?: Language[];
}
export declare class TypeSafeApiModelProject extends Project {
    /**
     * Name of the final bundled OpenAPI specification
     */
    readonly parsedSpecFile: string;
    /**
     * Reference to the task used for generating the final bundled OpenAPI specification
     */
    readonly generateTask: Task;
    /**
     * Reference to the Smithy definition component. Will be defined if the model language is Smithy
     */
    readonly smithy?: SmithyDefinition;
    /**
     * Reference to the OpenAPI definition component. Will be defined if the model language is OpenAPI
     */
    readonly openapi?: OpenApiDefinition;
    constructor(options: TypeSafeApiModelProjectOptions);
    private addApiDefinition;
    private addParseAndBundleTask;
}
