"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSafeApiModelProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const open_api_definition_1 = require("./openapi/open-api-definition");
const smithy_definition_1 = require("./smithy/smithy-definition");
const type_safe_api_command_environment_1 = require("../codegen/components/type-safe-api-command-environment");
const utils_1 = require("../codegen/components/utils");
const types_1 = require("../types");
class TypeSafeApiModelProject extends projen_1.Project {
    constructor(options) {
        super(options);
        /**
         * Name of the final bundled OpenAPI specification
         */
        this.parsedSpecFile = ".api.json";
        this.addApiDefinition = ({ modelLanguage, modelOptions, handlerLanguages, }) => {
            if (modelLanguage === types_1.ModelLanguage.SMITHY) {
                if (!modelOptions.smithy) {
                    throw new Error(`modelOptions.smithy is required when selected model language is ${types_1.ModelLanguage.SMITHY}`);
                }
                const smithyOptions = modelOptions.smithy;
                const smithy = new smithy_definition_1.SmithyDefinition(this, {
                    smithyOptions,
                    handlerLanguages,
                });
                return { smithy, specPath: smithy.openApiSpecificationPath };
            }
            else if (modelLanguage === types_1.ModelLanguage.OPENAPI) {
                if (!modelOptions.openapi) {
                    throw new Error(`modelOptions.openapi is required when selected model language is ${types_1.ModelLanguage.OPENAPI}`);
                }
                const openApiOptions = modelOptions.openapi;
                const openapi = new open_api_definition_1.OpenApiDefinition(this, {
                    openApiOptions,
                    handlerLanguages,
                });
                return { openapi, specPath: openapi.openApiSpecificationPath };
            }
            else {
                throw new Error(`Unknown model language ${modelLanguage}`);
            }
        };
        this.addParseAndBundleTask = (openApiSpecificationPath) => {
            this.generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.PARSE_OPENAPI_SPEC, `--spec-path ${openApiSpecificationPath} --output-path ${this.parsedSpecFile}${this.smithy
                ? ` --smithy-json-path ${this.smithy.smithyJsonModelPath}`
                : ""}`));
            this.addGitIgnore(this.parsedSpecFile);
        };
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.generateTask = this.addTask("generate");
        // Add the API definition
        const { specPath, smithy, openapi } = this.addApiDefinition(options);
        this.smithy = smithy;
        this.openapi = openapi;
        // Parse and bundle the openapi specification
        this.addParseAndBundleTask(specPath);
        // Run the generate task as part of build
        this.compileTask.spawn(this.generateTask);
        // Add the README as a sample file which the user may edit
        new projen_1.SampleFile(this, "README.md", {
            sourcePath: path.resolve(__dirname, "..", "..", "..", "samples", "type-safe-api", "readme", "model", `${options.modelLanguage}.md`),
        });
    }
}
exports.TypeSafeApiModelProject = TypeSafeApiModelProject;
_a = JSII_RTTI_SYMBOL_1;
TypeSafeApiModelProject[_a] = { fqn: "@aws/pdk.type_safe_api.TypeSafeApiModelProject", version: "0.22.14" };
//# sourceMappingURL=data:application/json;base64,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