#include "wigner3j.h"
#include <iostream>

// See compute_wigner.py for the calculation of these coefficients.
Eigen::VectorXd compute_coeffs(int lmax) {
  Eigen::VectorXd wigner3j_coeffs = Eigen::VectorXd::Zero(pow((lmax + 1), 6));
  if (lmax == 0) {
    wigner3j_coeffs(0) = 1;
  } else if (lmax == 1) {
    wigner3j_coeffs(0) = 1;
    wigner3j_coeffs(9) = sqrt(3) / 3;
    wigner3j_coeffs(11) = -sqrt(3) / 3;
    wigner3j_coeffs(13) = sqrt(3) / 3;
    wigner3j_coeffs(21) = sqrt(3) / 3;
    wigner3j_coeffs(23) = -sqrt(3) / 3;
    wigner3j_coeffs(25) = sqrt(3) / 3;
    wigner3j_coeffs(30) = sqrt(3) / 3;
    wigner3j_coeffs(32) = -sqrt(3) / 3;
    wigner3j_coeffs(34) = sqrt(3) / 3;
    wigner3j_coeffs(42) = sqrt(6) / 6;
    wigner3j_coeffs(44) = -sqrt(6) / 6;
    wigner3j_coeffs(48) = -sqrt(6) / 6;
    wigner3j_coeffs(52) = sqrt(6) / 6;
    wigner3j_coeffs(56) = sqrt(6) / 6;
    wigner3j_coeffs(58) = -sqrt(6) / 6;
  } else if (lmax == 2) {
    wigner3j_coeffs(0) = 1;
    wigner3j_coeffs(14) = sqrt(3) / 3;
    wigner3j_coeffs(16) = -sqrt(3) / 3;
    wigner3j_coeffs(18) = sqrt(3) / 3;
    wigner3j_coeffs(60) = sqrt(5) / 5;
    wigner3j_coeffs(64) = -sqrt(5) / 5;
    wigner3j_coeffs(68) = sqrt(5) / 5;
    wigner3j_coeffs(72) = -sqrt(5) / 5;
    wigner3j_coeffs(76) = sqrt(5) / 5;
    wigner3j_coeffs(86) = sqrt(3) / 3;
    wigner3j_coeffs(88) = -sqrt(3) / 3;
    wigner3j_coeffs(90) = sqrt(3) / 3;
    wigner3j_coeffs(110) = sqrt(3) / 3;
    wigner3j_coeffs(112) = -sqrt(3) / 3;
    wigner3j_coeffs(114) = sqrt(3) / 3;
    wigner3j_coeffs(122) = sqrt(6) / 6;
    wigner3j_coeffs(124) = -sqrt(6) / 6;
    wigner3j_coeffs(128) = -sqrt(6) / 6;
    wigner3j_coeffs(132) = sqrt(6) / 6;
    wigner3j_coeffs(136) = sqrt(6) / 6;
    wigner3j_coeffs(138) = -sqrt(6) / 6;
    wigner3j_coeffs(148) = sqrt(5) / 5;
    wigner3j_coeffs(152) = -sqrt(10) / 10;
    wigner3j_coeffs(156) = sqrt(30) / 30;
    wigner3j_coeffs(162) = -sqrt(10) / 10;
    wigner3j_coeffs(166) = sqrt(30) / 15;
    wigner3j_coeffs(170) = -sqrt(10) / 10;
    wigner3j_coeffs(176) = sqrt(30) / 30;
    wigner3j_coeffs(180) = -sqrt(10) / 10;
    wigner3j_coeffs(184) = sqrt(5) / 5;
    wigner3j_coeffs(212) = sqrt(30) / 30;
    wigner3j_coeffs(214) = -sqrt(10) / 10;
    wigner3j_coeffs(216) = sqrt(5) / 5;
    wigner3j_coeffs(224) = -sqrt(10) / 10;
    wigner3j_coeffs(226) = sqrt(30) / 15;
    wigner3j_coeffs(228) = -sqrt(10) / 10;
    wigner3j_coeffs(236) = sqrt(5) / 5;
    wigner3j_coeffs(238) = -sqrt(10) / 10;
    wigner3j_coeffs(240) = sqrt(30) / 30;
    wigner3j_coeffs(258) = sqrt(15) / 15;
    wigner3j_coeffs(262) = -sqrt(10) / 10;
    wigner3j_coeffs(266) = sqrt(10) / 10;
    wigner3j_coeffs(270) = -sqrt(15) / 15;
    wigner3j_coeffs(278) = -sqrt(30) / 15;
    wigner3j_coeffs(282) = sqrt(30) / 30;
    wigner3j_coeffs(290) = -sqrt(30) / 30;
    wigner3j_coeffs(294) = sqrt(30) / 15;
    wigner3j_coeffs(302) = sqrt(15) / 15;
    wigner3j_coeffs(306) = -sqrt(10) / 10;
    wigner3j_coeffs(310) = sqrt(10) / 10;
    wigner3j_coeffs(314) = -sqrt(15) / 15;
    wigner3j_coeffs(348) = sqrt(5) / 5;
    wigner3j_coeffs(352) = -sqrt(5) / 5;
    wigner3j_coeffs(356) = sqrt(5) / 5;
    wigner3j_coeffs(360) = -sqrt(5) / 5;
    wigner3j_coeffs(364) = sqrt(5) / 5;
    wigner3j_coeffs(392) = sqrt(5) / 5;
    wigner3j_coeffs(398) = -sqrt(10) / 10;
    wigner3j_coeffs(400) = -sqrt(10) / 10;
    wigner3j_coeffs(404) = sqrt(30) / 30;
    wigner3j_coeffs(406) = sqrt(30) / 15;
    wigner3j_coeffs(408) = sqrt(30) / 30;
    wigner3j_coeffs(412) = -sqrt(10) / 10;
    wigner3j_coeffs(414) = -sqrt(10) / 10;
    wigner3j_coeffs(420) = sqrt(5) / 5;
    wigner3j_coeffs(438) = sqrt(30) / 15;
    wigner3j_coeffs(442) = -sqrt(15) / 15;
    wigner3j_coeffs(448) = -sqrt(15) / 15;
    wigner3j_coeffs(452) = -sqrt(30) / 30;
    wigner3j_coeffs(456) = sqrt(10) / 10;
    wigner3j_coeffs(462) = sqrt(10) / 10;
    wigner3j_coeffs(470) = -sqrt(10) / 10;
    wigner3j_coeffs(476) = -sqrt(10) / 10;
    wigner3j_coeffs(480) = sqrt(30) / 30;
    wigner3j_coeffs(484) = sqrt(15) / 15;
    wigner3j_coeffs(490) = sqrt(15) / 15;
    wigner3j_coeffs(494) = -sqrt(30) / 15;
    wigner3j_coeffs(508) = sqrt(5) / 5;
    wigner3j_coeffs(512) = -sqrt(5) / 5;
    wigner3j_coeffs(516) = sqrt(5) / 5;
    wigner3j_coeffs(520) = -sqrt(5) / 5;
    wigner3j_coeffs(524) = sqrt(5) / 5;
    wigner3j_coeffs(540) = sqrt(15) / 15;
    wigner3j_coeffs(542) = -sqrt(30) / 15;
    wigner3j_coeffs(552) = -sqrt(10) / 10;
    wigner3j_coeffs(554) = sqrt(30) / 30;
    wigner3j_coeffs(556) = sqrt(15) / 15;
    wigner3j_coeffs(564) = sqrt(10) / 10;
    wigner3j_coeffs(568) = -sqrt(10) / 10;
    wigner3j_coeffs(576) = -sqrt(15) / 15;
    wigner3j_coeffs(578) = -sqrt(30) / 30;
    wigner3j_coeffs(580) = sqrt(10) / 10;
    wigner3j_coeffs(590) = sqrt(30) / 15;
    wigner3j_coeffs(592) = -sqrt(15) / 15;
    wigner3j_coeffs(618) = sqrt(70) / 35;
    wigner3j_coeffs(622) = -sqrt(105) / 35;
    wigner3j_coeffs(626) = sqrt(70) / 35;
    wigner3j_coeffs(638) = -sqrt(105) / 35;
    wigner3j_coeffs(642) = sqrt(70) / 70;
    wigner3j_coeffs(646) = sqrt(70) / 70;
    wigner3j_coeffs(650) = -sqrt(105) / 35;
    wigner3j_coeffs(658) = sqrt(70) / 35;
    wigner3j_coeffs(662) = sqrt(70) / 70;
    wigner3j_coeffs(666) = -sqrt(70) / 35;
    wigner3j_coeffs(670) = sqrt(70) / 70;
    wigner3j_coeffs(674) = sqrt(70) / 35;
    wigner3j_coeffs(682) = -sqrt(105) / 35;
    wigner3j_coeffs(686) = sqrt(70) / 70;
    wigner3j_coeffs(690) = sqrt(70) / 70;
    wigner3j_coeffs(694) = -sqrt(105) / 35;
    wigner3j_coeffs(706) = sqrt(70) / 35;
    wigner3j_coeffs(710) = -sqrt(105) / 35;
    wigner3j_coeffs(714) = sqrt(70) / 35;
  } else if (lmax == 3) {
    wigner3j_coeffs(0) = 1;
    wigner3j_coeffs(21) = sqrt(3) / 3;
    wigner3j_coeffs(23) = -sqrt(3) / 3;
    wigner3j_coeffs(25) = sqrt(3) / 3;
    wigner3j_coeffs(88) = sqrt(5) / 5;
    wigner3j_coeffs(92) = -sqrt(5) / 5;
    wigner3j_coeffs(96) = sqrt(5) / 5;
    wigner3j_coeffs(100) = -sqrt(5) / 5;
    wigner3j_coeffs(104) = sqrt(5) / 5;
    wigner3j_coeffs(213) = sqrt(7) / 7;
    wigner3j_coeffs(219) = -sqrt(7) / 7;
    wigner3j_coeffs(225) = sqrt(7) / 7;
    wigner3j_coeffs(231) = -sqrt(7) / 7;
    wigner3j_coeffs(237) = sqrt(7) / 7;
    wigner3j_coeffs(243) = -sqrt(7) / 7;
    wigner3j_coeffs(249) = sqrt(7) / 7;
    wigner3j_coeffs(261) = sqrt(3) / 3;
    wigner3j_coeffs(263) = -sqrt(3) / 3;
    wigner3j_coeffs(265) = sqrt(3) / 3;
    wigner3j_coeffs(306) = sqrt(3) / 3;
    wigner3j_coeffs(308) = -sqrt(3) / 3;
    wigner3j_coeffs(310) = sqrt(3) / 3;
    wigner3j_coeffs(318) = sqrt(6) / 6;
    wigner3j_coeffs(320) = -sqrt(6) / 6;
    wigner3j_coeffs(324) = -sqrt(6) / 6;
    wigner3j_coeffs(328) = sqrt(6) / 6;
    wigner3j_coeffs(332) = sqrt(6) / 6;
    wigner3j_coeffs(334) = -sqrt(6) / 6;
    wigner3j_coeffs(344) = sqrt(5) / 5;
    wigner3j_coeffs(348) = -sqrt(10) / 10;
    wigner3j_coeffs(352) = sqrt(30) / 30;
    wigner3j_coeffs(358) = -sqrt(10) / 10;
    wigner3j_coeffs(362) = sqrt(30) / 15;
    wigner3j_coeffs(366) = -sqrt(10) / 10;
    wigner3j_coeffs(372) = sqrt(30) / 30;
    wigner3j_coeffs(376) = -sqrt(10) / 10;
    wigner3j_coeffs(380) = sqrt(5) / 5;
    wigner3j_coeffs(471) = sqrt(30) / 30;
    wigner3j_coeffs(473) = -sqrt(10) / 10;
    wigner3j_coeffs(475) = sqrt(5) / 5;
    wigner3j_coeffs(483) = -sqrt(10) / 10;
    wigner3j_coeffs(485) = sqrt(30) / 15;
    wigner3j_coeffs(487) = -sqrt(10) / 10;
    wigner3j_coeffs(495) = sqrt(5) / 5;
    wigner3j_coeffs(497) = -sqrt(10) / 10;
    wigner3j_coeffs(499) = sqrt(30) / 30;
    wigner3j_coeffs(517) = sqrt(15) / 15;
    wigner3j_coeffs(521) = -sqrt(10) / 10;
    wigner3j_coeffs(525) = sqrt(10) / 10;
    wigner3j_coeffs(529) = -sqrt(15) / 15;
    wigner3j_coeffs(537) = -sqrt(30) / 15;
    wigner3j_coeffs(541) = sqrt(30) / 30;
    wigner3j_coeffs(549) = -sqrt(30) / 30;
    wigner3j_coeffs(553) = sqrt(30) / 15;
    wigner3j_coeffs(561) = sqrt(15) / 15;
    wigner3j_coeffs(565) = -sqrt(10) / 10;
    wigner3j_coeffs(569) = sqrt(10) / 10;
    wigner3j_coeffs(573) = -sqrt(15) / 15;
    wigner3j_coeffs(589) = sqrt(7) / 7;
    wigner3j_coeffs(595) = -sqrt(42) / 21;
    wigner3j_coeffs(601) = sqrt(70) / 35;
    wigner3j_coeffs(607) = -sqrt(35) / 35;
    wigner3j_coeffs(613) = sqrt(105) / 105;
    wigner3j_coeffs(623) = -sqrt(21) / 21;
    wigner3j_coeffs(629) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(635) = -sqrt(105) / 35;
    wigner3j_coeffs(641) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(647) = -sqrt(21) / 21;
    wigner3j_coeffs(657) = sqrt(105) / 105;
    wigner3j_coeffs(663) = -sqrt(35) / 35;
    wigner3j_coeffs(669) = sqrt(70) / 35;
    wigner3j_coeffs(675) = -sqrt(42) / 21;
    wigner3j_coeffs(681) = sqrt(7) / 7;
    wigner3j_coeffs(786) = sqrt(105) / 105;
    wigner3j_coeffs(790) = -sqrt(35) / 35;
    wigner3j_coeffs(794) = sqrt(70) / 35;
    wigner3j_coeffs(798) = -sqrt(42) / 21;
    wigner3j_coeffs(802) = sqrt(7) / 7;
    wigner3j_coeffs(816) = -sqrt(21) / 21;
    wigner3j_coeffs(820) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(824) = -sqrt(105) / 35;
    wigner3j_coeffs(828) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(832) = -sqrt(21) / 21;
    wigner3j_coeffs(846) = sqrt(7) / 7;
    wigner3j_coeffs(850) = -sqrt(42) / 21;
    wigner3j_coeffs(854) = sqrt(70) / 35;
    wigner3j_coeffs(858) = -sqrt(35) / 35;
    wigner3j_coeffs(862) = sqrt(105) / 105;
    wigner3j_coeffs(890) = sqrt(7) / 14;
    wigner3j_coeffs(896) = -sqrt(105) / 42;
    wigner3j_coeffs(902) = sqrt(14) / 14;
    wigner3j_coeffs(908) = -sqrt(14) / 14;
    wigner3j_coeffs(914) = sqrt(105) / 42;
    wigner3j_coeffs(920) = -sqrt(7) / 14;
    wigner3j_coeffs(932) = -sqrt(21) / 14;
    wigner3j_coeffs(938) = sqrt(21) / 21;
    wigner3j_coeffs(944) = -sqrt(21) / 42;
    wigner3j_coeffs(956) = sqrt(21) / 42;
    wigner3j_coeffs(962) = -sqrt(21) / 21;
    wigner3j_coeffs(968) = sqrt(21) / 14;
    wigner3j_coeffs(980) = sqrt(7) / 14;
    wigner3j_coeffs(986) = -sqrt(105) / 42;
    wigner3j_coeffs(992) = sqrt(14) / 14;
    wigner3j_coeffs(998) = -sqrt(14) / 14;
    wigner3j_coeffs(1004) = sqrt(105) / 42;
    wigner3j_coeffs(1010) = -sqrt(7) / 14;
    wigner3j_coeffs(1048) = sqrt(5) / 5;
    wigner3j_coeffs(1052) = -sqrt(5) / 5;
    wigner3j_coeffs(1056) = sqrt(5) / 5;
    wigner3j_coeffs(1060) = -sqrt(5) / 5;
    wigner3j_coeffs(1064) = sqrt(5) / 5;
    wigner3j_coeffs(1127) = sqrt(5) / 5;
    wigner3j_coeffs(1133) = -sqrt(10) / 10;
    wigner3j_coeffs(1135) = -sqrt(10) / 10;
    wigner3j_coeffs(1139) = sqrt(30) / 30;
    wigner3j_coeffs(1141) = sqrt(30) / 15;
    wigner3j_coeffs(1143) = sqrt(30) / 30;
    wigner3j_coeffs(1147) = -sqrt(10) / 10;
    wigner3j_coeffs(1149) = -sqrt(10) / 10;
    wigner3j_coeffs(1155) = sqrt(5) / 5;
    wigner3j_coeffs(1173) = sqrt(30) / 15;
    wigner3j_coeffs(1177) = -sqrt(15) / 15;
    wigner3j_coeffs(1183) = -sqrt(15) / 15;
    wigner3j_coeffs(1187) = -sqrt(30) / 30;
    wigner3j_coeffs(1191) = sqrt(10) / 10;
    wigner3j_coeffs(1197) = sqrt(10) / 10;
    wigner3j_coeffs(1205) = -sqrt(10) / 10;
    wigner3j_coeffs(1211) = -sqrt(10) / 10;
    wigner3j_coeffs(1215) = sqrt(30) / 30;
    wigner3j_coeffs(1219) = sqrt(15) / 15;
    wigner3j_coeffs(1225) = sqrt(15) / 15;
    wigner3j_coeffs(1229) = -sqrt(30) / 15;
    wigner3j_coeffs(1245) = sqrt(7) / 7;
    wigner3j_coeffs(1251) = -sqrt(21) / 21;
    wigner3j_coeffs(1257) = sqrt(105) / 105;
    wigner3j_coeffs(1265) = -sqrt(42) / 21;
    wigner3j_coeffs(1271) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(1277) = -sqrt(35) / 35;
    wigner3j_coeffs(1285) = sqrt(70) / 35;
    wigner3j_coeffs(1291) = -sqrt(105) / 35;
    wigner3j_coeffs(1297) = sqrt(70) / 35;
    wigner3j_coeffs(1305) = -sqrt(35) / 35;
    wigner3j_coeffs(1311) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(1317) = -sqrt(42) / 21;
    wigner3j_coeffs(1325) = sqrt(105) / 105;
    wigner3j_coeffs(1331) = -sqrt(21) / 21;
    wigner3j_coeffs(1337) = sqrt(7) / 7;
    wigner3j_coeffs(1348) = sqrt(5) / 5;
    wigner3j_coeffs(1352) = -sqrt(5) / 5;
    wigner3j_coeffs(1356) = sqrt(5) / 5;
    wigner3j_coeffs(1360) = -sqrt(5) / 5;
    wigner3j_coeffs(1364) = sqrt(5) / 5;
    wigner3j_coeffs(1380) = sqrt(15) / 15;
    wigner3j_coeffs(1382) = -sqrt(30) / 15;
    wigner3j_coeffs(1392) = -sqrt(10) / 10;
    wigner3j_coeffs(1394) = sqrt(30) / 30;
    wigner3j_coeffs(1396) = sqrt(15) / 15;
    wigner3j_coeffs(1404) = sqrt(10) / 10;
    wigner3j_coeffs(1408) = -sqrt(10) / 10;
    wigner3j_coeffs(1416) = -sqrt(15) / 15;
    wigner3j_coeffs(1418) = -sqrt(30) / 30;
    wigner3j_coeffs(1420) = sqrt(10) / 10;
    wigner3j_coeffs(1430) = sqrt(30) / 15;
    wigner3j_coeffs(1432) = -sqrt(15) / 15;
    wigner3j_coeffs(1458) = sqrt(70) / 35;
    wigner3j_coeffs(1462) = -sqrt(105) / 35;
    wigner3j_coeffs(1466) = sqrt(70) / 35;
    wigner3j_coeffs(1478) = -sqrt(105) / 35;
    wigner3j_coeffs(1482) = sqrt(70) / 70;
    wigner3j_coeffs(1486) = sqrt(70) / 70;
    wigner3j_coeffs(1490) = -sqrt(105) / 35;
    wigner3j_coeffs(1498) = sqrt(70) / 35;
    wigner3j_coeffs(1502) = sqrt(70) / 70;
    wigner3j_coeffs(1506) = -sqrt(70) / 35;
    wigner3j_coeffs(1510) = sqrt(70) / 70;
    wigner3j_coeffs(1514) = sqrt(70) / 35;
    wigner3j_coeffs(1522) = -sqrt(105) / 35;
    wigner3j_coeffs(1526) = sqrt(70) / 70;
    wigner3j_coeffs(1530) = sqrt(70) / 70;
    wigner3j_coeffs(1534) = -sqrt(105) / 35;
    wigner3j_coeffs(1546) = sqrt(70) / 35;
    wigner3j_coeffs(1550) = -sqrt(105) / 35;
    wigner3j_coeffs(1554) = sqrt(70) / 35;
    wigner3j_coeffs(1582) = sqrt(14) / 14;
    wigner3j_coeffs(1588) = -sqrt(14) / 14;
    wigner3j_coeffs(1594) = sqrt(210) / 70;
    wigner3j_coeffs(1600) = -sqrt(70) / 70;
    wigner3j_coeffs(1610) = -sqrt(14) / 14;
    wigner3j_coeffs(1622) = sqrt(35) / 35;
    wigner3j_coeffs(1628) = -sqrt(70) / 35;
    wigner3j_coeffs(1634) = sqrt(210) / 70;
    wigner3j_coeffs(1644) = sqrt(14) / 14;
    wigner3j_coeffs(1650) = -sqrt(35) / 35;
    wigner3j_coeffs(1662) = sqrt(35) / 35;
    wigner3j_coeffs(1668) = -sqrt(14) / 14;
    wigner3j_coeffs(1678) = -sqrt(210) / 70;
    wigner3j_coeffs(1684) = sqrt(70) / 35;
    wigner3j_coeffs(1690) = -sqrt(35) / 35;
    wigner3j_coeffs(1702) = sqrt(14) / 14;
    wigner3j_coeffs(1712) = sqrt(70) / 70;
    wigner3j_coeffs(1718) = -sqrt(210) / 70;
    wigner3j_coeffs(1724) = sqrt(14) / 14;
    wigner3j_coeffs(1730) = -sqrt(14) / 14;
    wigner3j_coeffs(1793) = sqrt(105) / 105;
    wigner3j_coeffs(1795) = -sqrt(21) / 21;
    wigner3j_coeffs(1797) = sqrt(7) / 7;
    wigner3j_coeffs(1811) = -sqrt(35) / 35;
    wigner3j_coeffs(1813) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(1815) = -sqrt(42) / 21;
    wigner3j_coeffs(1829) = sqrt(70) / 35;
    wigner3j_coeffs(1831) = -sqrt(105) / 35;
    wigner3j_coeffs(1833) = sqrt(70) / 35;
    wigner3j_coeffs(1847) = -sqrt(42) / 21;
    wigner3j_coeffs(1849) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(1851) = -sqrt(35) / 35;
    wigner3j_coeffs(1865) = sqrt(7) / 7;
    wigner3j_coeffs(1867) = -sqrt(21) / 21;
    wigner3j_coeffs(1869) = sqrt(105) / 105;
    wigner3j_coeffs(1903) = sqrt(70) / 70;
    wigner3j_coeffs(1907) = -sqrt(210) / 70;
    wigner3j_coeffs(1911) = sqrt(14) / 14;
    wigner3j_coeffs(1915) = -sqrt(14) / 14;
    wigner3j_coeffs(1933) = -sqrt(210) / 70;
    wigner3j_coeffs(1937) = sqrt(70) / 35;
    wigner3j_coeffs(1941) = -sqrt(35) / 35;
    wigner3j_coeffs(1949) = sqrt(14) / 14;
    wigner3j_coeffs(1963) = sqrt(14) / 14;
    wigner3j_coeffs(1967) = -sqrt(35) / 35;
    wigner3j_coeffs(1975) = sqrt(35) / 35;
    wigner3j_coeffs(1979) = -sqrt(14) / 14;
    wigner3j_coeffs(1993) = -sqrt(14) / 14;
    wigner3j_coeffs(2001) = sqrt(35) / 35;
    wigner3j_coeffs(2005) = -sqrt(70) / 35;
    wigner3j_coeffs(2009) = sqrt(210) / 70;
    wigner3j_coeffs(2027) = sqrt(14) / 14;
    wigner3j_coeffs(2031) = -sqrt(14) / 14;
    wigner3j_coeffs(2035) = sqrt(210) / 70;
    wigner3j_coeffs(2039) = -sqrt(70) / 70;
    wigner3j_coeffs(2079) = sqrt(42) / 42;
    wigner3j_coeffs(2085) = -sqrt(21) / 21;
    wigner3j_coeffs(2091) = sqrt(70) / 35;
    wigner3j_coeffs(2097) = -sqrt(21) / 21;
    wigner3j_coeffs(2103) = sqrt(42) / 42;
    wigner3j_coeffs(2121) = -sqrt(105) / 42;
    wigner3j_coeffs(2127) = sqrt(7) / 14;
    wigner3j_coeffs(2133) = -sqrt(210) / 210;
    wigner3j_coeffs(2139) = -sqrt(210) / 210;
    wigner3j_coeffs(2145) = sqrt(7) / 14;
    wigner3j_coeffs(2151) = -sqrt(105) / 42;
    wigner3j_coeffs(2163) = sqrt(105) / 42;
    wigner3j_coeffs(2175) = -sqrt(105) / 70;
    wigner3j_coeffs(2181) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(2187) = -sqrt(105) / 70;
    wigner3j_coeffs(2199) = sqrt(105) / 42;
    wigner3j_coeffs(2211) = -sqrt(105) / 42;
    wigner3j_coeffs(2217) = sqrt(7) / 14;
    wigner3j_coeffs(2223) = -sqrt(210) / 210;
    wigner3j_coeffs(2229) = -sqrt(210) / 210;
    wigner3j_coeffs(2235) = sqrt(7) / 14;
    wigner3j_coeffs(2241) = -sqrt(105) / 42;
    wigner3j_coeffs(2259) = sqrt(42) / 42;
    wigner3j_coeffs(2265) = -sqrt(21) / 21;
    wigner3j_coeffs(2271) = sqrt(70) / 35;
    wigner3j_coeffs(2277) = -sqrt(21) / 21;
    wigner3j_coeffs(2283) = sqrt(42) / 42;
    wigner3j_coeffs(2373) = sqrt(7) / 7;
    wigner3j_coeffs(2379) = -sqrt(7) / 7;
    wigner3j_coeffs(2385) = sqrt(7) / 7;
    wigner3j_coeffs(2391) = -sqrt(7) / 7;
    wigner3j_coeffs(2397) = sqrt(7) / 7;
    wigner3j_coeffs(2403) = -sqrt(7) / 7;
    wigner3j_coeffs(2409) = sqrt(7) / 7;
    wigner3j_coeffs(2514) = sqrt(7) / 7;
    wigner3j_coeffs(2524) = -sqrt(21) / 21;
    wigner3j_coeffs(2528) = -sqrt(42) / 21;
    wigner3j_coeffs(2534) = sqrt(105) / 105;
    wigner3j_coeffs(2538) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(2542) = sqrt(70) / 35;
    wigner3j_coeffs(2548) = -sqrt(35) / 35;
    wigner3j_coeffs(2552) = -sqrt(105) / 35;
    wigner3j_coeffs(2556) = -sqrt(35) / 35;
    wigner3j_coeffs(2562) = sqrt(70) / 35;
    wigner3j_coeffs(2566) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(2570) = sqrt(105) / 105;
    wigner3j_coeffs(2576) = -sqrt(42) / 21;
    wigner3j_coeffs(2580) = -sqrt(21) / 21;
    wigner3j_coeffs(2590) = sqrt(7) / 7;
    wigner3j_coeffs(2618) = sqrt(21) / 14;
    wigner3j_coeffs(2624) = -sqrt(7) / 14;
    wigner3j_coeffs(2632) = -sqrt(7) / 14;
    wigner3j_coeffs(2638) = -sqrt(21) / 21;
    wigner3j_coeffs(2644) = sqrt(105) / 42;
    wigner3j_coeffs(2652) = sqrt(105) / 42;
    wigner3j_coeffs(2658) = sqrt(21) / 42;
    wigner3j_coeffs(2664) = -sqrt(14) / 14;
    wigner3j_coeffs(2672) = -sqrt(14) / 14;
    wigner3j_coeffs(2684) = sqrt(14) / 14;
    wigner3j_coeffs(2692) = sqrt(14) / 14;
    wigner3j_coeffs(2698) = -sqrt(21) / 42;
    wigner3j_coeffs(2704) = -sqrt(105) / 42;
    wigner3j_coeffs(2712) = -sqrt(105) / 42;
    wigner3j_coeffs(2718) = sqrt(21) / 21;
    wigner3j_coeffs(2724) = sqrt(7) / 14;
    wigner3j_coeffs(2732) = sqrt(7) / 14;
    wigner3j_coeffs(2738) = -sqrt(21) / 14;
    wigner3j_coeffs(2801) = sqrt(7) / 7;
    wigner3j_coeffs(2813) = -sqrt(42) / 21;
    wigner3j_coeffs(2815) = -sqrt(21) / 21;
    wigner3j_coeffs(2825) = sqrt(70) / 35;
    wigner3j_coeffs(2827) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(2829) = sqrt(105) / 105;
    wigner3j_coeffs(2837) = -sqrt(35) / 35;
    wigner3j_coeffs(2839) = -sqrt(105) / 35;
    wigner3j_coeffs(2841) = -sqrt(35) / 35;
    wigner3j_coeffs(2849) = sqrt(105) / 105;
    wigner3j_coeffs(2851) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(2853) = sqrt(70) / 35;
    wigner3j_coeffs(2863) = -sqrt(21) / 21;
    wigner3j_coeffs(2865) = -sqrt(42) / 21;
    wigner3j_coeffs(2877) = sqrt(7) / 7;
    wigner3j_coeffs(2911) = sqrt(14) / 14;
    wigner3j_coeffs(2915) = -sqrt(14) / 14;
    wigner3j_coeffs(2931) = -sqrt(14) / 14;
    wigner3j_coeffs(2939) = sqrt(14) / 14;
    wigner3j_coeffs(2951) = sqrt(210) / 70;
    wigner3j_coeffs(2955) = sqrt(35) / 35;
    wigner3j_coeffs(2959) = -sqrt(35) / 35;
    wigner3j_coeffs(2963) = -sqrt(210) / 70;
    wigner3j_coeffs(2971) = -sqrt(70) / 70;
    wigner3j_coeffs(2975) = -sqrt(70) / 35;
    wigner3j_coeffs(2983) = sqrt(70) / 35;
    wigner3j_coeffs(2987) = sqrt(70) / 70;
    wigner3j_coeffs(2995) = sqrt(210) / 70;
    wigner3j_coeffs(2999) = sqrt(35) / 35;
    wigner3j_coeffs(3003) = -sqrt(35) / 35;
    wigner3j_coeffs(3007) = -sqrt(210) / 70;
    wigner3j_coeffs(3019) = -sqrt(14) / 14;
    wigner3j_coeffs(3027) = sqrt(14) / 14;
    wigner3j_coeffs(3043) = sqrt(14) / 14;
    wigner3j_coeffs(3047) = -sqrt(14) / 14;
    wigner3j_coeffs(3087) = sqrt(105) / 42;
    wigner3j_coeffs(3093) = -sqrt(105) / 42;
    wigner3j_coeffs(3099) = sqrt(42) / 42;
    wigner3j_coeffs(3115) = -sqrt(105) / 42;
    wigner3j_coeffs(3127) = sqrt(7) / 14;
    wigner3j_coeffs(3133) = -sqrt(21) / 21;
    wigner3j_coeffs(3143) = sqrt(42) / 42;
    wigner3j_coeffs(3149) = sqrt(7) / 14;
    wigner3j_coeffs(3155) = -sqrt(105) / 70;
    wigner3j_coeffs(3161) = -sqrt(210) / 210;
    wigner3j_coeffs(3167) = sqrt(70) / 35;
    wigner3j_coeffs(3177) = -sqrt(21) / 21;
    wigner3j_coeffs(3183) = -sqrt(210) / 210;
    wigner3j_coeffs(3189) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(3195) = -sqrt(210) / 210;
    wigner3j_coeffs(3201) = -sqrt(21) / 21;
    wigner3j_coeffs(3211) = sqrt(70) / 35;
    wigner3j_coeffs(3217) = -sqrt(210) / 210;
    wigner3j_coeffs(3223) = -sqrt(105) / 70;
    wigner3j_coeffs(3229) = sqrt(7) / 14;
    wigner3j_coeffs(3235) = sqrt(42) / 42;
    wigner3j_coeffs(3245) = -sqrt(21) / 21;
    wigner3j_coeffs(3251) = sqrt(7) / 14;
    wigner3j_coeffs(3263) = -sqrt(105) / 42;
    wigner3j_coeffs(3279) = sqrt(42) / 42;
    wigner3j_coeffs(3285) = -sqrt(105) / 42;
    wigner3j_coeffs(3291) = sqrt(105) / 42;
    wigner3j_coeffs(3318) = sqrt(7) / 7;
    wigner3j_coeffs(3324) = -sqrt(7) / 7;
    wigner3j_coeffs(3330) = sqrt(7) / 7;
    wigner3j_coeffs(3336) = -sqrt(7) / 7;
    wigner3j_coeffs(3342) = sqrt(7) / 7;
    wigner3j_coeffs(3348) = -sqrt(7) / 7;
    wigner3j_coeffs(3354) = sqrt(7) / 7;
    wigner3j_coeffs(3378) = sqrt(7) / 14;
    wigner3j_coeffs(3380) = -sqrt(21) / 14;
    wigner3j_coeffs(3396) = -sqrt(105) / 42;
    wigner3j_coeffs(3398) = sqrt(21) / 21;
    wigner3j_coeffs(3400) = sqrt(7) / 14;
    wigner3j_coeffs(3414) = sqrt(14) / 14;
    wigner3j_coeffs(3416) = -sqrt(21) / 42;
    wigner3j_coeffs(3418) = -sqrt(105) / 42;
    wigner3j_coeffs(3432) = -sqrt(14) / 14;
    wigner3j_coeffs(3436) = sqrt(14) / 14;
    wigner3j_coeffs(3450) = sqrt(105) / 42;
    wigner3j_coeffs(3452) = sqrt(21) / 42;
    wigner3j_coeffs(3454) = -sqrt(14) / 14;
    wigner3j_coeffs(3468) = -sqrt(7) / 14;
    wigner3j_coeffs(3470) = -sqrt(21) / 21;
    wigner3j_coeffs(3472) = sqrt(105) / 42;
    wigner3j_coeffs(3488) = sqrt(21) / 14;
    wigner3j_coeffs(3490) = -sqrt(7) / 14;
    wigner3j_coeffs(3532) = sqrt(42) / 42;
    wigner3j_coeffs(3536) = -sqrt(105) / 42;
    wigner3j_coeffs(3540) = sqrt(105) / 42;
    wigner3j_coeffs(3562) = -sqrt(21) / 21;
    wigner3j_coeffs(3566) = sqrt(7) / 14;
    wigner3j_coeffs(3574) = -sqrt(105) / 42;
    wigner3j_coeffs(3592) = sqrt(70) / 35;
    wigner3j_coeffs(3596) = -sqrt(210) / 210;
    wigner3j_coeffs(3600) = -sqrt(105) / 70;
    wigner3j_coeffs(3604) = sqrt(7) / 14;
    wigner3j_coeffs(3608) = sqrt(42) / 42;
    wigner3j_coeffs(3622) = -sqrt(21) / 21;
    wigner3j_coeffs(3626) = -sqrt(210) / 210;
    wigner3j_coeffs(3630) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(3634) = -sqrt(210) / 210;
    wigner3j_coeffs(3638) = -sqrt(21) / 21;
    wigner3j_coeffs(3652) = sqrt(42) / 42;
    wigner3j_coeffs(3656) = sqrt(7) / 14;
    wigner3j_coeffs(3660) = -sqrt(105) / 70;
    wigner3j_coeffs(3664) = -sqrt(210) / 210;
    wigner3j_coeffs(3668) = sqrt(70) / 35;
    wigner3j_coeffs(3686) = -sqrt(105) / 42;
    wigner3j_coeffs(3694) = sqrt(7) / 14;
    wigner3j_coeffs(3698) = -sqrt(21) / 21;
    wigner3j_coeffs(3720) = sqrt(105) / 42;
    wigner3j_coeffs(3724) = -sqrt(105) / 42;
    wigner3j_coeffs(3728) = sqrt(42) / 42;
    wigner3j_coeffs(3780) = sqrt(42) / 42;
    wigner3j_coeffs(3786) = -sqrt(21) / 21;
    wigner3j_coeffs(3792) = sqrt(21) / 21;
    wigner3j_coeffs(3798) = -sqrt(42) / 42;
    wigner3j_coeffs(3822) = -sqrt(21) / 21;
    wigner3j_coeffs(3828) = sqrt(42) / 42;
    wigner3j_coeffs(3840) = -sqrt(42) / 42;
    wigner3j_coeffs(3846) = sqrt(21) / 21;
    wigner3j_coeffs(3864) = sqrt(21) / 21;
    wigner3j_coeffs(3876) = -sqrt(42) / 42;
    wigner3j_coeffs(3882) = sqrt(42) / 42;
    wigner3j_coeffs(3894) = -sqrt(21) / 21;
    wigner3j_coeffs(3906) = -sqrt(42) / 42;
    wigner3j_coeffs(3912) = -sqrt(42) / 42;
    wigner3j_coeffs(3918) = sqrt(42) / 42;
    wigner3j_coeffs(3930) = -sqrt(42) / 42;
    wigner3j_coeffs(3936) = sqrt(42) / 42;
    wigner3j_coeffs(3942) = sqrt(42) / 42;
    wigner3j_coeffs(3954) = sqrt(21) / 21;
    wigner3j_coeffs(3966) = -sqrt(42) / 42;
    wigner3j_coeffs(3972) = sqrt(42) / 42;
    wigner3j_coeffs(3984) = -sqrt(21) / 21;
    wigner3j_coeffs(4002) = -sqrt(21) / 21;
    wigner3j_coeffs(4008) = sqrt(42) / 42;
    wigner3j_coeffs(4020) = -sqrt(42) / 42;
    wigner3j_coeffs(4026) = sqrt(21) / 21;
    wigner3j_coeffs(4050) = sqrt(42) / 42;
    wigner3j_coeffs(4056) = -sqrt(21) / 21;
    wigner3j_coeffs(4062) = sqrt(21) / 21;
    wigner3j_coeffs(4068) = -sqrt(42) / 42;
  } else if (lmax == 4) {
    wigner3j_coeffs(0) = 1;
    wigner3j_coeffs(30) = sqrt(3) / 3;
    wigner3j_coeffs(32) = -sqrt(3) / 3;
    wigner3j_coeffs(34) = sqrt(3) / 3;
    wigner3j_coeffs(124) = sqrt(5) / 5;
    wigner3j_coeffs(128) = -sqrt(5) / 5;
    wigner3j_coeffs(132) = sqrt(5) / 5;
    wigner3j_coeffs(136) = -sqrt(5) / 5;
    wigner3j_coeffs(140) = sqrt(5) / 5;
    wigner3j_coeffs(294) = sqrt(7) / 7;
    wigner3j_coeffs(300) = -sqrt(7) / 7;
    wigner3j_coeffs(306) = sqrt(7) / 7;
    wigner3j_coeffs(312) = -sqrt(7) / 7;
    wigner3j_coeffs(318) = sqrt(7) / 7;
    wigner3j_coeffs(324) = -sqrt(7) / 7;
    wigner3j_coeffs(330) = sqrt(7) / 7;
    wigner3j_coeffs(552) = 1 / 3;
    wigner3j_coeffs(560) = -1 / 3;
    wigner3j_coeffs(568) = 1 / 3;
    wigner3j_coeffs(576) = -1 / 3;
    wigner3j_coeffs(584) = 1 / 3;
    wigner3j_coeffs(592) = -1 / 3;
    wigner3j_coeffs(600) = 1 / 3;
    wigner3j_coeffs(608) = -1 / 3;
    wigner3j_coeffs(616) = 1 / 3;
    wigner3j_coeffs(630) = sqrt(3) / 3;
    wigner3j_coeffs(632) = -sqrt(3) / 3;
    wigner3j_coeffs(634) = sqrt(3) / 3;
    wigner3j_coeffs(702) = sqrt(3) / 3;
    wigner3j_coeffs(704) = -sqrt(3) / 3;
    wigner3j_coeffs(706) = sqrt(3) / 3;
    wigner3j_coeffs(714) = sqrt(6) / 6;
    wigner3j_coeffs(716) = -sqrt(6) / 6;
    wigner3j_coeffs(720) = -sqrt(6) / 6;
    wigner3j_coeffs(724) = sqrt(6) / 6;
    wigner3j_coeffs(728) = sqrt(6) / 6;
    wigner3j_coeffs(730) = -sqrt(6) / 6;
    wigner3j_coeffs(740) = sqrt(5) / 5;
    wigner3j_coeffs(744) = -sqrt(10) / 10;
    wigner3j_coeffs(748) = sqrt(30) / 30;
    wigner3j_coeffs(754) = -sqrt(10) / 10;
    wigner3j_coeffs(758) = sqrt(30) / 15;
    wigner3j_coeffs(762) = -sqrt(10) / 10;
    wigner3j_coeffs(768) = sqrt(30) / 30;
    wigner3j_coeffs(772) = -sqrt(10) / 10;
    wigner3j_coeffs(776) = sqrt(5) / 5;
    wigner3j_coeffs(948) = sqrt(30) / 30;
    wigner3j_coeffs(950) = -sqrt(10) / 10;
    wigner3j_coeffs(952) = sqrt(5) / 5;
    wigner3j_coeffs(960) = -sqrt(10) / 10;
    wigner3j_coeffs(962) = sqrt(30) / 15;
    wigner3j_coeffs(964) = -sqrt(10) / 10;
    wigner3j_coeffs(972) = sqrt(5) / 5;
    wigner3j_coeffs(974) = -sqrt(10) / 10;
    wigner3j_coeffs(976) = sqrt(30) / 30;
    wigner3j_coeffs(994) = sqrt(15) / 15;
    wigner3j_coeffs(998) = -sqrt(10) / 10;
    wigner3j_coeffs(1002) = sqrt(10) / 10;
    wigner3j_coeffs(1006) = -sqrt(15) / 15;
    wigner3j_coeffs(1014) = -sqrt(30) / 15;
    wigner3j_coeffs(1018) = sqrt(30) / 30;
    wigner3j_coeffs(1026) = -sqrt(30) / 30;
    wigner3j_coeffs(1030) = sqrt(30) / 15;
    wigner3j_coeffs(1038) = sqrt(15) / 15;
    wigner3j_coeffs(1042) = -sqrt(10) / 10;
    wigner3j_coeffs(1046) = sqrt(10) / 10;
    wigner3j_coeffs(1050) = -sqrt(15) / 15;
    wigner3j_coeffs(1066) = sqrt(7) / 7;
    wigner3j_coeffs(1072) = -sqrt(42) / 21;
    wigner3j_coeffs(1078) = sqrt(70) / 35;
    wigner3j_coeffs(1084) = -sqrt(35) / 35;
    wigner3j_coeffs(1090) = sqrt(105) / 105;
    wigner3j_coeffs(1100) = -sqrt(21) / 21;
    wigner3j_coeffs(1106) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(1112) = -sqrt(105) / 35;
    wigner3j_coeffs(1118) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(1124) = -sqrt(21) / 21;
    wigner3j_coeffs(1134) = sqrt(105) / 105;
    wigner3j_coeffs(1140) = -sqrt(35) / 35;
    wigner3j_coeffs(1146) = sqrt(70) / 35;
    wigner3j_coeffs(1152) = -sqrt(42) / 21;
    wigner3j_coeffs(1158) = sqrt(7) / 7;
    wigner3j_coeffs(1398) = sqrt(105) / 105;
    wigner3j_coeffs(1402) = -sqrt(35) / 35;
    wigner3j_coeffs(1406) = sqrt(70) / 35;
    wigner3j_coeffs(1410) = -sqrt(42) / 21;
    wigner3j_coeffs(1414) = sqrt(7) / 7;
    wigner3j_coeffs(1428) = -sqrt(21) / 21;
    wigner3j_coeffs(1432) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(1436) = -sqrt(105) / 35;
    wigner3j_coeffs(1440) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(1444) = -sqrt(21) / 21;
    wigner3j_coeffs(1458) = sqrt(7) / 7;
    wigner3j_coeffs(1462) = -sqrt(42) / 21;
    wigner3j_coeffs(1466) = sqrt(70) / 35;
    wigner3j_coeffs(1470) = -sqrt(35) / 35;
    wigner3j_coeffs(1474) = sqrt(105) / 105;
    wigner3j_coeffs(1502) = sqrt(7) / 14;
    wigner3j_coeffs(1508) = -sqrt(105) / 42;
    wigner3j_coeffs(1514) = sqrt(14) / 14;
    wigner3j_coeffs(1520) = -sqrt(14) / 14;
    wigner3j_coeffs(1526) = sqrt(105) / 42;
    wigner3j_coeffs(1532) = -sqrt(7) / 14;
    wigner3j_coeffs(1544) = -sqrt(21) / 14;
    wigner3j_coeffs(1550) = sqrt(21) / 21;
    wigner3j_coeffs(1556) = -sqrt(21) / 42;
    wigner3j_coeffs(1568) = sqrt(21) / 42;
    wigner3j_coeffs(1574) = -sqrt(21) / 21;
    wigner3j_coeffs(1580) = sqrt(21) / 14;
    wigner3j_coeffs(1592) = sqrt(7) / 14;
    wigner3j_coeffs(1598) = -sqrt(105) / 42;
    wigner3j_coeffs(1604) = sqrt(14) / 14;
    wigner3j_coeffs(1610) = -sqrt(14) / 14;
    wigner3j_coeffs(1616) = sqrt(105) / 42;
    wigner3j_coeffs(1622) = -sqrt(7) / 14;
    wigner3j_coeffs(1644) = 1 / 3;
    wigner3j_coeffs(1652) = -sqrt(3) / 6;
    wigner3j_coeffs(1660) = sqrt(105) / 42;
    wigner3j_coeffs(1668) = -sqrt(70) / 42;
    wigner3j_coeffs(1676) = sqrt(42) / 42;
    wigner3j_coeffs(1684) = -sqrt(21) / 42;
    wigner3j_coeffs(1692) = sqrt(7) / 42;
    wigner3j_coeffs(1706) = -1 / 6;
    wigner3j_coeffs(1714) = sqrt(21) / 21;
    wigner3j_coeffs(1722) = -sqrt(105) / 42;
    wigner3j_coeffs(1730) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(1738) = -sqrt(105) / 42;
    wigner3j_coeffs(1746) = sqrt(21) / 21;
    wigner3j_coeffs(1754) = -1 / 6;
    wigner3j_coeffs(1768) = sqrt(7) / 42;
    wigner3j_coeffs(1776) = -sqrt(21) / 42;
    wigner3j_coeffs(1784) = sqrt(42) / 42;
    wigner3j_coeffs(1792) = -sqrt(70) / 42;
    wigner3j_coeffs(1800) = sqrt(105) / 42;
    wigner3j_coeffs(1808) = -sqrt(3) / 6;
    wigner3j_coeffs(1816) = 1 / 3;
    wigner3j_coeffs(2088) = sqrt(7) / 42;
    wigner3j_coeffs(2094) = -sqrt(21) / 42;
    wigner3j_coeffs(2100) = sqrt(42) / 42;
    wigner3j_coeffs(2106) = -sqrt(70) / 42;
    wigner3j_coeffs(2112) = sqrt(105) / 42;
    wigner3j_coeffs(2118) = -sqrt(3) / 6;
    wigner3j_coeffs(2124) = 1 / 3;
    wigner3j_coeffs(2144) = -1 / 6;
    wigner3j_coeffs(2150) = sqrt(21) / 21;
    wigner3j_coeffs(2156) = -sqrt(105) / 42;
    wigner3j_coeffs(2162) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(2168) = -sqrt(105) / 42;
    wigner3j_coeffs(2174) = sqrt(21) / 21;
    wigner3j_coeffs(2180) = -1 / 6;
    wigner3j_coeffs(2200) = 1 / 3;
    wigner3j_coeffs(2206) = -sqrt(3) / 6;
    wigner3j_coeffs(2212) = sqrt(105) / 42;
    wigner3j_coeffs(2218) = -sqrt(70) / 42;
    wigner3j_coeffs(2224) = sqrt(42) / 42;
    wigner3j_coeffs(2230) = -sqrt(21) / 42;
    wigner3j_coeffs(2236) = sqrt(7) / 42;
    wigner3j_coeffs(2274) = sqrt(5) / 15;
    wigner3j_coeffs(2282) = -sqrt(35) / 30;
    wigner3j_coeffs(2290) = sqrt(5) / 10;
    wigner3j_coeffs(2298) = -sqrt(2) / 6;
    wigner3j_coeffs(2306) = sqrt(2) / 6;
    wigner3j_coeffs(2314) = -sqrt(5) / 10;
    wigner3j_coeffs(2322) = sqrt(35) / 30;
    wigner3j_coeffs(2330) = -sqrt(5) / 15;
    wigner3j_coeffs(2346) = -2 * sqrt(5) / 15;
    wigner3j_coeffs(2354) = sqrt(5) / 10;
    wigner3j_coeffs(2362) = -sqrt(5) / 15;
    wigner3j_coeffs(2370) = sqrt(5) / 30;
    wigner3j_coeffs(2386) = -sqrt(5) / 30;
    wigner3j_coeffs(2394) = sqrt(5) / 15;
    wigner3j_coeffs(2402) = -sqrt(5) / 10;
    wigner3j_coeffs(2410) = 2 * sqrt(5) / 15;
    wigner3j_coeffs(2426) = sqrt(5) / 15;
    wigner3j_coeffs(2434) = -sqrt(35) / 30;
    wigner3j_coeffs(2442) = sqrt(5) / 10;
    wigner3j_coeffs(2450) = -sqrt(2) / 6;
    wigner3j_coeffs(2458) = sqrt(2) / 6;
    wigner3j_coeffs(2466) = -sqrt(5) / 10;
    wigner3j_coeffs(2474) = sqrt(35) / 30;
    wigner3j_coeffs(2482) = -sqrt(5) / 15;
    wigner3j_coeffs(2524) = sqrt(5) / 5;
    wigner3j_coeffs(2528) = -sqrt(5) / 5;
    wigner3j_coeffs(2532) = sqrt(5) / 5;
    wigner3j_coeffs(2536) = -sqrt(5) / 5;
    wigner3j_coeffs(2540) = sqrt(5) / 5;
    wigner3j_coeffs(2648) = sqrt(5) / 5;
    wigner3j_coeffs(2654) = -sqrt(10) / 10;
    wigner3j_coeffs(2656) = -sqrt(10) / 10;
    wigner3j_coeffs(2660) = sqrt(30) / 30;
    wigner3j_coeffs(2662) = sqrt(30) / 15;
    wigner3j_coeffs(2664) = sqrt(30) / 30;
    wigner3j_coeffs(2668) = -sqrt(10) / 10;
    wigner3j_coeffs(2670) = -sqrt(10) / 10;
    wigner3j_coeffs(2676) = sqrt(5) / 5;
    wigner3j_coeffs(2694) = sqrt(30) / 15;
    wigner3j_coeffs(2698) = -sqrt(15) / 15;
    wigner3j_coeffs(2704) = -sqrt(15) / 15;
    wigner3j_coeffs(2708) = -sqrt(30) / 30;
    wigner3j_coeffs(2712) = sqrt(10) / 10;
    wigner3j_coeffs(2718) = sqrt(10) / 10;
    wigner3j_coeffs(2726) = -sqrt(10) / 10;
    wigner3j_coeffs(2732) = -sqrt(10) / 10;
    wigner3j_coeffs(2736) = sqrt(30) / 30;
    wigner3j_coeffs(2740) = sqrt(15) / 15;
    wigner3j_coeffs(2746) = sqrt(15) / 15;
    wigner3j_coeffs(2750) = -sqrt(30) / 15;
    wigner3j_coeffs(2766) = sqrt(7) / 7;
    wigner3j_coeffs(2772) = -sqrt(21) / 21;
    wigner3j_coeffs(2778) = sqrt(105) / 105;
    wigner3j_coeffs(2786) = -sqrt(42) / 21;
    wigner3j_coeffs(2792) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(2798) = -sqrt(35) / 35;
    wigner3j_coeffs(2806) = sqrt(70) / 35;
    wigner3j_coeffs(2812) = -sqrt(105) / 35;
    wigner3j_coeffs(2818) = sqrt(70) / 35;
    wigner3j_coeffs(2826) = -sqrt(35) / 35;
    wigner3j_coeffs(2832) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(2838) = -sqrt(42) / 21;
    wigner3j_coeffs(2846) = sqrt(105) / 105;
    wigner3j_coeffs(2852) = -sqrt(21) / 21;
    wigner3j_coeffs(2858) = sqrt(7) / 7;
    wigner3j_coeffs(3004) = sqrt(5) / 5;
    wigner3j_coeffs(3008) = -sqrt(5) / 5;
    wigner3j_coeffs(3012) = sqrt(5) / 5;
    wigner3j_coeffs(3016) = -sqrt(5) / 5;
    wigner3j_coeffs(3020) = sqrt(5) / 5;
    wigner3j_coeffs(3036) = sqrt(15) / 15;
    wigner3j_coeffs(3038) = -sqrt(30) / 15;
    wigner3j_coeffs(3048) = -sqrt(10) / 10;
    wigner3j_coeffs(3050) = sqrt(30) / 30;
    wigner3j_coeffs(3052) = sqrt(15) / 15;
    wigner3j_coeffs(3060) = sqrt(10) / 10;
    wigner3j_coeffs(3064) = -sqrt(10) / 10;
    wigner3j_coeffs(3072) = -sqrt(15) / 15;
    wigner3j_coeffs(3074) = -sqrt(30) / 30;
    wigner3j_coeffs(3076) = sqrt(10) / 10;
    wigner3j_coeffs(3086) = sqrt(30) / 15;
    wigner3j_coeffs(3088) = -sqrt(15) / 15;
    wigner3j_coeffs(3114) = sqrt(70) / 35;
    wigner3j_coeffs(3118) = -sqrt(105) / 35;
    wigner3j_coeffs(3122) = sqrt(70) / 35;
    wigner3j_coeffs(3134) = -sqrt(105) / 35;
    wigner3j_coeffs(3138) = sqrt(70) / 70;
    wigner3j_coeffs(3142) = sqrt(70) / 70;
    wigner3j_coeffs(3146) = -sqrt(105) / 35;
    wigner3j_coeffs(3154) = sqrt(70) / 35;
    wigner3j_coeffs(3158) = sqrt(70) / 70;
    wigner3j_coeffs(3162) = -sqrt(70) / 35;
    wigner3j_coeffs(3166) = sqrt(70) / 70;
    wigner3j_coeffs(3170) = sqrt(70) / 35;
    wigner3j_coeffs(3178) = -sqrt(105) / 35;
    wigner3j_coeffs(3182) = sqrt(70) / 70;
    wigner3j_coeffs(3186) = sqrt(70) / 70;
    wigner3j_coeffs(3190) = -sqrt(105) / 35;
    wigner3j_coeffs(3202) = sqrt(70) / 35;
    wigner3j_coeffs(3206) = -sqrt(105) / 35;
    wigner3j_coeffs(3210) = sqrt(70) / 35;
    wigner3j_coeffs(3238) = sqrt(14) / 14;
    wigner3j_coeffs(3244) = -sqrt(14) / 14;
    wigner3j_coeffs(3250) = sqrt(210) / 70;
    wigner3j_coeffs(3256) = -sqrt(70) / 70;
    wigner3j_coeffs(3266) = -sqrt(14) / 14;
    wigner3j_coeffs(3278) = sqrt(35) / 35;
    wigner3j_coeffs(3284) = -sqrt(70) / 35;
    wigner3j_coeffs(3290) = sqrt(210) / 70;
    wigner3j_coeffs(3300) = sqrt(14) / 14;
    wigner3j_coeffs(3306) = -sqrt(35) / 35;
    wigner3j_coeffs(3318) = sqrt(35) / 35;
    wigner3j_coeffs(3324) = -sqrt(14) / 14;
    wigner3j_coeffs(3334) = -sqrt(210) / 70;
    wigner3j_coeffs(3340) = sqrt(70) / 35;
    wigner3j_coeffs(3346) = -sqrt(35) / 35;
    wigner3j_coeffs(3358) = sqrt(14) / 14;
    wigner3j_coeffs(3368) = sqrt(70) / 70;
    wigner3j_coeffs(3374) = -sqrt(210) / 70;
    wigner3j_coeffs(3380) = sqrt(14) / 14;
    wigner3j_coeffs(3386) = -sqrt(14) / 14;
    wigner3j_coeffs(3408) = 1 / 3;
    wigner3j_coeffs(3416) = -sqrt(2) / 6;
    wigner3j_coeffs(3424) = sqrt(42) / 42;
    wigner3j_coeffs(3432) = -sqrt(14) / 42;
    wigner3j_coeffs(3440) = sqrt(70) / 210;
    wigner3j_coeffs(3452) = -sqrt(2) / 6;
    wigner3j_coeffs(3460) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(3468) = -sqrt(21) / 21;
    wigner3j_coeffs(3476) = 2 * sqrt(70) / 105;
    wigner3j_coeffs(3484) = -sqrt(14) / 42;
    wigner3j_coeffs(3496) = sqrt(42) / 42;
    wigner3j_coeffs(3504) = -sqrt(21) / 21;
    wigner3j_coeffs(3512) = sqrt(70) / 35;
    wigner3j_coeffs(3520) = -sqrt(21) / 21;
    wigner3j_coeffs(3528) = sqrt(42) / 42;
    wigner3j_coeffs(3540) = -sqrt(14) / 42;
    wigner3j_coeffs(3548) = 2 * sqrt(70) / 105;
    wigner3j_coeffs(3556) = -sqrt(21) / 21;
    wigner3j_coeffs(3564) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(3572) = -sqrt(2) / 6;
    wigner3j_coeffs(3584) = sqrt(70) / 210;
    wigner3j_coeffs(3592) = -sqrt(14) / 42;
    wigner3j_coeffs(3600) = sqrt(42) / 42;
    wigner3j_coeffs(3608) = -sqrt(2) / 6;
    wigner3j_coeffs(3616) = 1 / 3;
    wigner3j_coeffs(3674) = sqrt(105) / 105;
    wigner3j_coeffs(3676) = -sqrt(21) / 21;
    wigner3j_coeffs(3678) = sqrt(7) / 7;
    wigner3j_coeffs(3692) = -sqrt(35) / 35;
    wigner3j_coeffs(3694) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(3696) = -sqrt(42) / 21;
    wigner3j_coeffs(3710) = sqrt(70) / 35;
    wigner3j_coeffs(3712) = -sqrt(105) / 35;
    wigner3j_coeffs(3714) = sqrt(70) / 35;
    wigner3j_coeffs(3728) = -sqrt(42) / 21;
    wigner3j_coeffs(3730) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(3732) = -sqrt(35) / 35;
    wigner3j_coeffs(3746) = sqrt(7) / 7;
    wigner3j_coeffs(3748) = -sqrt(21) / 21;
    wigner3j_coeffs(3750) = sqrt(105) / 105;
    wigner3j_coeffs(3784) = sqrt(70) / 70;
    wigner3j_coeffs(3788) = -sqrt(210) / 70;
    wigner3j_coeffs(3792) = sqrt(14) / 14;
    wigner3j_coeffs(3796) = -sqrt(14) / 14;
    wigner3j_coeffs(3814) = -sqrt(210) / 70;
    wigner3j_coeffs(3818) = sqrt(70) / 35;
    wigner3j_coeffs(3822) = -sqrt(35) / 35;
    wigner3j_coeffs(3830) = sqrt(14) / 14;
    wigner3j_coeffs(3844) = sqrt(14) / 14;
    wigner3j_coeffs(3848) = -sqrt(35) / 35;
    wigner3j_coeffs(3856) = sqrt(35) / 35;
    wigner3j_coeffs(3860) = -sqrt(14) / 14;
    wigner3j_coeffs(3874) = -sqrt(14) / 14;
    wigner3j_coeffs(3882) = sqrt(35) / 35;
    wigner3j_coeffs(3886) = -sqrt(70) / 35;
    wigner3j_coeffs(3890) = sqrt(210) / 70;
    wigner3j_coeffs(3908) = sqrt(14) / 14;
    wigner3j_coeffs(3912) = -sqrt(14) / 14;
    wigner3j_coeffs(3916) = sqrt(210) / 70;
    wigner3j_coeffs(3920) = -sqrt(70) / 70;
    wigner3j_coeffs(3960) = sqrt(42) / 42;
    wigner3j_coeffs(3966) = -sqrt(21) / 21;
    wigner3j_coeffs(3972) = sqrt(70) / 35;
    wigner3j_coeffs(3978) = -sqrt(21) / 21;
    wigner3j_coeffs(3984) = sqrt(42) / 42;
    wigner3j_coeffs(4002) = -sqrt(105) / 42;
    wigner3j_coeffs(4008) = sqrt(7) / 14;
    wigner3j_coeffs(4014) = -sqrt(210) / 210;
    wigner3j_coeffs(4020) = -sqrt(210) / 210;
    wigner3j_coeffs(4026) = sqrt(7) / 14;
    wigner3j_coeffs(4032) = -sqrt(105) / 42;
    wigner3j_coeffs(4044) = sqrt(105) / 42;
    wigner3j_coeffs(4056) = -sqrt(105) / 70;
    wigner3j_coeffs(4062) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(4068) = -sqrt(105) / 70;
    wigner3j_coeffs(4080) = sqrt(105) / 42;
    wigner3j_coeffs(4092) = -sqrt(105) / 42;
    wigner3j_coeffs(4098) = sqrt(7) / 14;
    wigner3j_coeffs(4104) = -sqrt(210) / 210;
    wigner3j_coeffs(4110) = -sqrt(210) / 210;
    wigner3j_coeffs(4116) = sqrt(7) / 14;
    wigner3j_coeffs(4122) = -sqrt(105) / 42;
    wigner3j_coeffs(4140) = sqrt(42) / 42;
    wigner3j_coeffs(4146) = -sqrt(21) / 21;
    wigner3j_coeffs(4152) = sqrt(70) / 35;
    wigner3j_coeffs(4158) = -sqrt(21) / 21;
    wigner3j_coeffs(4164) = sqrt(42) / 42;
    wigner3j_coeffs(4202) = sqrt(10) / 15;
    wigner3j_coeffs(4210) = -sqrt(2) / 6;
    wigner3j_coeffs(4218) = sqrt(21) / 21;
    wigner3j_coeffs(4226) = -sqrt(14) / 21;
    wigner3j_coeffs(4234) = sqrt(7) / 21;
    wigner3j_coeffs(4242) = -sqrt(210) / 210;
    wigner3j_coeffs(4256) = -sqrt(15) / 15;
    wigner3j_coeffs(4264) = sqrt(5) / 30;
    wigner3j_coeffs(4272) = sqrt(7) / 42;
    wigner3j_coeffs(4280) = -sqrt(42) / 42;
    wigner3j_coeffs(4288) = sqrt(70) / 42;
    wigner3j_coeffs(4296) = -sqrt(35) / 30;
    wigner3j_coeffs(4304) = sqrt(105) / 70;
    wigner3j_coeffs(4318) = sqrt(5) / 10;
    wigner3j_coeffs(4326) = -2 * sqrt(105) / 105;
    wigner3j_coeffs(4334) = sqrt(21) / 42;
    wigner3j_coeffs(4350) = -sqrt(21) / 42;
    wigner3j_coeffs(4358) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(4366) = -sqrt(5) / 10;
    wigner3j_coeffs(4380) = -sqrt(105) / 70;
    wigner3j_coeffs(4388) = sqrt(35) / 30;
    wigner3j_coeffs(4396) = -sqrt(70) / 42;
    wigner3j_coeffs(4404) = sqrt(42) / 42;
    wigner3j_coeffs(4412) = -sqrt(7) / 42;
    wigner3j_coeffs(4420) = -sqrt(5) / 30;
    wigner3j_coeffs(4428) = sqrt(15) / 15;
    wigner3j_coeffs(4442) = sqrt(210) / 210;
    wigner3j_coeffs(4450) = -sqrt(7) / 21;
    wigner3j_coeffs(4458) = sqrt(14) / 21;
    wigner3j_coeffs(4466) = -sqrt(21) / 21;
    wigner3j_coeffs(4474) = sqrt(2) / 6;
    wigner3j_coeffs(4482) = -sqrt(10) / 15;
    wigner3j_coeffs(4704) = sqrt(70) / 210;
    wigner3j_coeffs(4708) = -sqrt(14) / 42;
    wigner3j_coeffs(4712) = sqrt(42) / 42;
    wigner3j_coeffs(4716) = -sqrt(2) / 6;
    wigner3j_coeffs(4720) = 1 / 3;
    wigner3j_coeffs(4744) = -sqrt(14) / 42;
    wigner3j_coeffs(4748) = 2 * sqrt(70) / 105;
    wigner3j_coeffs(4752) = -sqrt(21) / 21;
    wigner3j_coeffs(4756) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(4760) = -sqrt(2) / 6;
    wigner3j_coeffs(4784) = sqrt(42) / 42;
    wigner3j_coeffs(4788) = -sqrt(21) / 21;
    wigner3j_coeffs(4792) = sqrt(70) / 35;
    wigner3j_coeffs(4796) = -sqrt(21) / 21;
    wigner3j_coeffs(4800) = sqrt(42) / 42;
    wigner3j_coeffs(4824) = -sqrt(2) / 6;
    wigner3j_coeffs(4828) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(4832) = -sqrt(21) / 21;
    wigner3j_coeffs(4836) = 2 * sqrt(70) / 105;
    wigner3j_coeffs(4840) = -sqrt(14) / 42;
    wigner3j_coeffs(4864) = 1 / 3;
    wigner3j_coeffs(4868) = -sqrt(2) / 6;
    wigner3j_coeffs(4872) = sqrt(42) / 42;
    wigner3j_coeffs(4876) = -sqrt(14) / 42;
    wigner3j_coeffs(4880) = sqrt(70) / 210;
    wigner3j_coeffs(4932) = sqrt(210) / 210;
    wigner3j_coeffs(4938) = -sqrt(7) / 21;
    wigner3j_coeffs(4944) = sqrt(14) / 21;
    wigner3j_coeffs(4950) = -sqrt(21) / 21;
    wigner3j_coeffs(4956) = sqrt(2) / 6;
    wigner3j_coeffs(4962) = -sqrt(10) / 15;
    wigner3j_coeffs(4988) = -sqrt(105) / 70;
    wigner3j_coeffs(4994) = sqrt(35) / 30;
    wigner3j_coeffs(5000) = -sqrt(70) / 42;
    wigner3j_coeffs(5006) = sqrt(42) / 42;
    wigner3j_coeffs(5012) = -sqrt(7) / 42;
    wigner3j_coeffs(5018) = -sqrt(5) / 30;
    wigner3j_coeffs(5024) = sqrt(15) / 15;
    wigner3j_coeffs(5044) = sqrt(5) / 10;
    wigner3j_coeffs(5050) = -2 * sqrt(105) / 105;
    wigner3j_coeffs(5056) = sqrt(21) / 42;
    wigner3j_coeffs(5068) = -sqrt(21) / 42;
    wigner3j_coeffs(5074) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(5080) = -sqrt(5) / 10;
    wigner3j_coeffs(5100) = -sqrt(15) / 15;
    wigner3j_coeffs(5106) = sqrt(5) / 30;
    wigner3j_coeffs(5112) = sqrt(7) / 42;
    wigner3j_coeffs(5118) = -sqrt(42) / 42;
    wigner3j_coeffs(5124) = sqrt(70) / 42;
    wigner3j_coeffs(5130) = -sqrt(35) / 30;
    wigner3j_coeffs(5136) = sqrt(105) / 70;
    wigner3j_coeffs(5162) = sqrt(10) / 15;
    wigner3j_coeffs(5168) = -sqrt(2) / 6;
    wigner3j_coeffs(5174) = sqrt(21) / 21;
    wigner3j_coeffs(5180) = -sqrt(14) / 21;
    wigner3j_coeffs(5186) = sqrt(7) / 21;
    wigner3j_coeffs(5192) = -sqrt(210) / 210;
    wigner3j_coeffs(5246) = sqrt(330) / 165;
    wigner3j_coeffs(5254) = -sqrt(330) / 110;
    wigner3j_coeffs(5262) = sqrt(231) / 77;
    wigner3j_coeffs(5270) = -sqrt(2310) / 231;
    wigner3j_coeffs(5278) = sqrt(231) / 77;
    wigner3j_coeffs(5286) = -sqrt(330) / 110;
    wigner3j_coeffs(5294) = sqrt(330) / 165;
    wigner3j_coeffs(5318) = -sqrt(1155) / 165;
    wigner3j_coeffs(5326) = sqrt(165) / 66;
    wigner3j_coeffs(5334) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(5342) = sqrt(462) / 462;
    wigner3j_coeffs(5350) = sqrt(462) / 462;
    wigner3j_coeffs(5358) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(5366) = sqrt(165) / 66;
    wigner3j_coeffs(5374) = -sqrt(1155) / 165;
    wigner3j_coeffs(5390) = 2 * sqrt(385) / 165;
    wigner3j_coeffs(5398) = -sqrt(385) / 330;
    wigner3j_coeffs(5406) = -4 * sqrt(385) / 1155;
    wigner3j_coeffs(5414) = 17 * sqrt(385) / 2310;
    wigner3j_coeffs(5422) = -2 * sqrt(385) / 231;
    wigner3j_coeffs(5430) = 17 * sqrt(385) / 2310;
    wigner3j_coeffs(5438) = -4 * sqrt(385) / 1155;
    wigner3j_coeffs(5446) = -sqrt(385) / 330;
    wigner3j_coeffs(5454) = 2 * sqrt(385) / 165;
    wigner3j_coeffs(5470) = -sqrt(1155) / 165;
    wigner3j_coeffs(5478) = sqrt(165) / 66;
    wigner3j_coeffs(5486) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(5494) = sqrt(462) / 462;
    wigner3j_coeffs(5502) = sqrt(462) / 462;
    wigner3j_coeffs(5510) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(5518) = sqrt(165) / 66;
    wigner3j_coeffs(5526) = -sqrt(1155) / 165;
    wigner3j_coeffs(5550) = sqrt(330) / 165;
    wigner3j_coeffs(5558) = -sqrt(330) / 110;
    wigner3j_coeffs(5566) = sqrt(231) / 77;
    wigner3j_coeffs(5574) = -sqrt(2310) / 231;
    wigner3j_coeffs(5582) = sqrt(231) / 77;
    wigner3j_coeffs(5590) = -sqrt(330) / 110;
    wigner3j_coeffs(5598) = sqrt(330) / 165;
    wigner3j_coeffs(5694) = sqrt(7) / 7;
    wigner3j_coeffs(5700) = -sqrt(7) / 7;
    wigner3j_coeffs(5706) = sqrt(7) / 7;
    wigner3j_coeffs(5712) = -sqrt(7) / 7;
    wigner3j_coeffs(5718) = sqrt(7) / 7;
    wigner3j_coeffs(5724) = -sqrt(7) / 7;
    wigner3j_coeffs(5730) = sqrt(7) / 7;
    wigner3j_coeffs(5898) = sqrt(7) / 7;
    wigner3j_coeffs(5908) = -sqrt(21) / 21;
    wigner3j_coeffs(5912) = -sqrt(42) / 21;
    wigner3j_coeffs(5918) = sqrt(105) / 105;
    wigner3j_coeffs(5922) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(5926) = sqrt(70) / 35;
    wigner3j_coeffs(5932) = -sqrt(35) / 35;
    wigner3j_coeffs(5936) = -sqrt(105) / 35;
    wigner3j_coeffs(5940) = -sqrt(35) / 35;
    wigner3j_coeffs(5946) = sqrt(70) / 35;
    wigner3j_coeffs(5950) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(5954) = sqrt(105) / 105;
    wigner3j_coeffs(5960) = -sqrt(42) / 21;
    wigner3j_coeffs(5964) = -sqrt(21) / 21;
    wigner3j_coeffs(5974) = sqrt(7) / 7;
    wigner3j_coeffs(6002) = sqrt(21) / 14;
    wigner3j_coeffs(6008) = -sqrt(7) / 14;
    wigner3j_coeffs(6016) = -sqrt(7) / 14;
    wigner3j_coeffs(6022) = -sqrt(21) / 21;
    wigner3j_coeffs(6028) = sqrt(105) / 42;
    wigner3j_coeffs(6036) = sqrt(105) / 42;
    wigner3j_coeffs(6042) = sqrt(21) / 42;
    wigner3j_coeffs(6048) = -sqrt(14) / 14;
    wigner3j_coeffs(6056) = -sqrt(14) / 14;
    wigner3j_coeffs(6068) = sqrt(14) / 14;
    wigner3j_coeffs(6076) = sqrt(14) / 14;
    wigner3j_coeffs(6082) = -sqrt(21) / 42;
    wigner3j_coeffs(6088) = -sqrt(105) / 42;
    wigner3j_coeffs(6096) = -sqrt(105) / 42;
    wigner3j_coeffs(6102) = sqrt(21) / 21;
    wigner3j_coeffs(6108) = sqrt(7) / 14;
    wigner3j_coeffs(6116) = sqrt(7) / 14;
    wigner3j_coeffs(6122) = -sqrt(21) / 14;
    wigner3j_coeffs(6144) = 1 / 3;
    wigner3j_coeffs(6152) = -1 / 6;
    wigner3j_coeffs(6160) = sqrt(7) / 42;
    wigner3j_coeffs(6170) = -sqrt(3) / 6;
    wigner3j_coeffs(6178) = sqrt(21) / 21;
    wigner3j_coeffs(6186) = -sqrt(21) / 42;
    wigner3j_coeffs(6196) = sqrt(105) / 42;
    wigner3j_coeffs(6204) = -sqrt(105) / 42;
    wigner3j_coeffs(6212) = sqrt(42) / 42;
    wigner3j_coeffs(6222) = -sqrt(70) / 42;
    wigner3j_coeffs(6230) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(6238) = -sqrt(70) / 42;
    wigner3j_coeffs(6248) = sqrt(42) / 42;
    wigner3j_coeffs(6256) = -sqrt(105) / 42;
    wigner3j_coeffs(6264) = sqrt(105) / 42;
    wigner3j_coeffs(6274) = -sqrt(21) / 42;
    wigner3j_coeffs(6282) = sqrt(21) / 21;
    wigner3j_coeffs(6290) = -sqrt(3) / 6;
    wigner3j_coeffs(6300) = sqrt(7) / 42;
    wigner3j_coeffs(6308) = -1 / 6;
    wigner3j_coeffs(6316) = 1 / 3;
    wigner3j_coeffs(6374) = sqrt(7) / 7;
    wigner3j_coeffs(6386) = -sqrt(42) / 21;
    wigner3j_coeffs(6388) = -sqrt(21) / 21;
    wigner3j_coeffs(6398) = sqrt(70) / 35;
    wigner3j_coeffs(6400) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(6402) = sqrt(105) / 105;
    wigner3j_coeffs(6410) = -sqrt(35) / 35;
    wigner3j_coeffs(6412) = -sqrt(105) / 35;
    wigner3j_coeffs(6414) = -sqrt(35) / 35;
    wigner3j_coeffs(6422) = sqrt(105) / 105;
    wigner3j_coeffs(6424) = 2 * sqrt(210) / 105;
    wigner3j_coeffs(6426) = sqrt(70) / 35;
    wigner3j_coeffs(6436) = -sqrt(21) / 21;
    wigner3j_coeffs(6438) = -sqrt(42) / 21;
    wigner3j_coeffs(6450) = sqrt(7) / 7;
    wigner3j_coeffs(6484) = sqrt(14) / 14;
    wigner3j_coeffs(6488) = -sqrt(14) / 14;
    wigner3j_coeffs(6504) = -sqrt(14) / 14;
    wigner3j_coeffs(6512) = sqrt(14) / 14;
    wigner3j_coeffs(6524) = sqrt(210) / 70;
    wigner3j_coeffs(6528) = sqrt(35) / 35;
    wigner3j_coeffs(6532) = -sqrt(35) / 35;
    wigner3j_coeffs(6536) = -sqrt(210) / 70;
    wigner3j_coeffs(6544) = -sqrt(70) / 70;
    wigner3j_coeffs(6548) = -sqrt(70) / 35;
    wigner3j_coeffs(6556) = sqrt(70) / 35;
    wigner3j_coeffs(6560) = sqrt(70) / 70;
    wigner3j_coeffs(6568) = sqrt(210) / 70;
    wigner3j_coeffs(6572) = sqrt(35) / 35;
    wigner3j_coeffs(6576) = -sqrt(35) / 35;
    wigner3j_coeffs(6580) = -sqrt(210) / 70;
    wigner3j_coeffs(6592) = -sqrt(14) / 14;
    wigner3j_coeffs(6600) = sqrt(14) / 14;
    wigner3j_coeffs(6616) = sqrt(14) / 14;
    wigner3j_coeffs(6620) = -sqrt(14) / 14;
    wigner3j_coeffs(6660) = sqrt(105) / 42;
    wigner3j_coeffs(6666) = -sqrt(105) / 42;
    wigner3j_coeffs(6672) = sqrt(42) / 42;
    wigner3j_coeffs(6688) = -sqrt(105) / 42;
    wigner3j_coeffs(6700) = sqrt(7) / 14;
    wigner3j_coeffs(6706) = -sqrt(21) / 21;
    wigner3j_coeffs(6716) = sqrt(42) / 42;
    wigner3j_coeffs(6722) = sqrt(7) / 14;
    wigner3j_coeffs(6728) = -sqrt(105) / 70;
    wigner3j_coeffs(6734) = -sqrt(210) / 210;
    wigner3j_coeffs(6740) = sqrt(70) / 35;
    wigner3j_coeffs(6750) = -sqrt(21) / 21;
    wigner3j_coeffs(6756) = -sqrt(210) / 210;
    wigner3j_coeffs(6762) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(6768) = -sqrt(210) / 210;
    wigner3j_coeffs(6774) = -sqrt(21) / 21;
    wigner3j_coeffs(6784) = sqrt(70) / 35;
    wigner3j_coeffs(6790) = -sqrt(210) / 210;
    wigner3j_coeffs(6796) = -sqrt(105) / 70;
    wigner3j_coeffs(6802) = sqrt(7) / 14;
    wigner3j_coeffs(6808) = sqrt(42) / 42;
    wigner3j_coeffs(6818) = -sqrt(21) / 21;
    wigner3j_coeffs(6824) = sqrt(7) / 14;
    wigner3j_coeffs(6836) = -sqrt(105) / 42;
    wigner3j_coeffs(6852) = sqrt(42) / 42;
    wigner3j_coeffs(6858) = -sqrt(105) / 42;
    wigner3j_coeffs(6864) = sqrt(105) / 42;
    wigner3j_coeffs(6902) = sqrt(15) / 15;
    wigner3j_coeffs(6910) = -sqrt(5) / 10;
    wigner3j_coeffs(6918) = sqrt(105) / 70;
    wigner3j_coeffs(6926) = -sqrt(210) / 210;
    wigner3j_coeffs(6938) = -sqrt(10) / 15;
    wigner3j_coeffs(6946) = -sqrt(5) / 30;
    wigner3j_coeffs(6954) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(6962) = -sqrt(35) / 30;
    wigner3j_coeffs(6970) = sqrt(7) / 21;
    wigner3j_coeffs(6982) = sqrt(2) / 6;
    wigner3j_coeffs(6990) = -sqrt(7) / 42;
    wigner3j_coeffs(6998) = -sqrt(21) / 42;
    wigner3j_coeffs(7006) = sqrt(70) / 42;
    wigner3j_coeffs(7014) = -sqrt(14) / 21;
    wigner3j_coeffs(7026) = -sqrt(21) / 21;
    wigner3j_coeffs(7034) = sqrt(42) / 42;
    wigner3j_coeffs(7050) = -sqrt(42) / 42;
    wigner3j_coeffs(7058) = sqrt(21) / 21;
    wigner3j_coeffs(7070) = sqrt(14) / 21;
    wigner3j_coeffs(7078) = -sqrt(70) / 42;
    wigner3j_coeffs(7086) = sqrt(21) / 42;
    wigner3j_coeffs(7094) = sqrt(7) / 42;
    wigner3j_coeffs(7102) = -sqrt(2) / 6;
    wigner3j_coeffs(7114) = -sqrt(7) / 21;
    wigner3j_coeffs(7122) = sqrt(35) / 30;
    wigner3j_coeffs(7130) = -2 * sqrt(105) / 105;
    wigner3j_coeffs(7138) = sqrt(5) / 30;
    wigner3j_coeffs(7146) = sqrt(10) / 15;
    wigner3j_coeffs(7158) = sqrt(210) / 210;
    wigner3j_coeffs(7166) = -sqrt(105) / 70;
    wigner3j_coeffs(7174) = sqrt(5) / 10;
    wigner3j_coeffs(7182) = -sqrt(15) / 15;
    wigner3j_coeffs(7206) = sqrt(7) / 7;
    wigner3j_coeffs(7212) = -sqrt(7) / 7;
    wigner3j_coeffs(7218) = sqrt(7) / 7;
    wigner3j_coeffs(7224) = -sqrt(7) / 7;
    wigner3j_coeffs(7230) = sqrt(7) / 7;
    wigner3j_coeffs(7236) = -sqrt(7) / 7;
    wigner3j_coeffs(7242) = sqrt(7) / 7;
    wigner3j_coeffs(7266) = sqrt(7) / 14;
    wigner3j_coeffs(7268) = -sqrt(21) / 14;
    wigner3j_coeffs(7284) = -sqrt(105) / 42;
    wigner3j_coeffs(7286) = sqrt(21) / 21;
    wigner3j_coeffs(7288) = sqrt(7) / 14;
    wigner3j_coeffs(7302) = sqrt(14) / 14;
    wigner3j_coeffs(7304) = -sqrt(21) / 42;
    wigner3j_coeffs(7306) = -sqrt(105) / 42;
    wigner3j_coeffs(7320) = -sqrt(14) / 14;
    wigner3j_coeffs(7324) = sqrt(14) / 14;
    wigner3j_coeffs(7338) = sqrt(105) / 42;
    wigner3j_coeffs(7340) = sqrt(21) / 42;
    wigner3j_coeffs(7342) = -sqrt(14) / 14;
    wigner3j_coeffs(7356) = -sqrt(7) / 14;
    wigner3j_coeffs(7358) = -sqrt(21) / 21;
    wigner3j_coeffs(7360) = sqrt(105) / 42;
    wigner3j_coeffs(7376) = sqrt(21) / 14;
    wigner3j_coeffs(7378) = -sqrt(7) / 14;
    wigner3j_coeffs(7420) = sqrt(42) / 42;
    wigner3j_coeffs(7424) = -sqrt(105) / 42;
    wigner3j_coeffs(7428) = sqrt(105) / 42;
    wigner3j_coeffs(7450) = -sqrt(21) / 21;
    wigner3j_coeffs(7454) = sqrt(7) / 14;
    wigner3j_coeffs(7462) = -sqrt(105) / 42;
    wigner3j_coeffs(7480) = sqrt(70) / 35;
    wigner3j_coeffs(7484) = -sqrt(210) / 210;
    wigner3j_coeffs(7488) = -sqrt(105) / 70;
    wigner3j_coeffs(7492) = sqrt(7) / 14;
    wigner3j_coeffs(7496) = sqrt(42) / 42;
    wigner3j_coeffs(7510) = -sqrt(21) / 21;
    wigner3j_coeffs(7514) = -sqrt(210) / 210;
    wigner3j_coeffs(7518) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(7522) = -sqrt(210) / 210;
    wigner3j_coeffs(7526) = -sqrt(21) / 21;
    wigner3j_coeffs(7540) = sqrt(42) / 42;
    wigner3j_coeffs(7544) = sqrt(7) / 14;
    wigner3j_coeffs(7548) = -sqrt(105) / 70;
    wigner3j_coeffs(7552) = -sqrt(210) / 210;
    wigner3j_coeffs(7556) = sqrt(70) / 35;
    wigner3j_coeffs(7574) = -sqrt(105) / 42;
    wigner3j_coeffs(7582) = sqrt(7) / 14;
    wigner3j_coeffs(7586) = -sqrt(21) / 21;
    wigner3j_coeffs(7608) = sqrt(105) / 42;
    wigner3j_coeffs(7612) = -sqrt(105) / 42;
    wigner3j_coeffs(7616) = sqrt(42) / 42;
    wigner3j_coeffs(7668) = sqrt(42) / 42;
    wigner3j_coeffs(7674) = -sqrt(21) / 21;
    wigner3j_coeffs(7680) = sqrt(21) / 21;
    wigner3j_coeffs(7686) = -sqrt(42) / 42;
    wigner3j_coeffs(7710) = -sqrt(21) / 21;
    wigner3j_coeffs(7716) = sqrt(42) / 42;
    wigner3j_coeffs(7728) = -sqrt(42) / 42;
    wigner3j_coeffs(7734) = sqrt(21) / 21;
    wigner3j_coeffs(7752) = sqrt(21) / 21;
    wigner3j_coeffs(7764) = -sqrt(42) / 42;
    wigner3j_coeffs(7770) = sqrt(42) / 42;
    wigner3j_coeffs(7782) = -sqrt(21) / 21;
    wigner3j_coeffs(7794) = -sqrt(42) / 42;
    wigner3j_coeffs(7800) = -sqrt(42) / 42;
    wigner3j_coeffs(7806) = sqrt(42) / 42;
    wigner3j_coeffs(7818) = -sqrt(42) / 42;
    wigner3j_coeffs(7824) = sqrt(42) / 42;
    wigner3j_coeffs(7830) = sqrt(42) / 42;
    wigner3j_coeffs(7842) = sqrt(21) / 21;
    wigner3j_coeffs(7854) = -sqrt(42) / 42;
    wigner3j_coeffs(7860) = sqrt(42) / 42;
    wigner3j_coeffs(7872) = -sqrt(21) / 21;
    wigner3j_coeffs(7890) = -sqrt(21) / 21;
    wigner3j_coeffs(7896) = sqrt(42) / 42;
    wigner3j_coeffs(7908) = -sqrt(42) / 42;
    wigner3j_coeffs(7914) = sqrt(21) / 21;
    wigner3j_coeffs(7938) = sqrt(42) / 42;
    wigner3j_coeffs(7944) = -sqrt(21) / 21;
    wigner3j_coeffs(7950) = sqrt(21) / 21;
    wigner3j_coeffs(7956) = -sqrt(42) / 42;
    wigner3j_coeffs(8010) = sqrt(33) / 33;
    wigner3j_coeffs(8018) = -sqrt(22) / 22;
    wigner3j_coeffs(8026) = sqrt(231) / 77;
    wigner3j_coeffs(8034) = -sqrt(1155) / 231;
    wigner3j_coeffs(8042) = sqrt(154) / 154;
    wigner3j_coeffs(8064) = -sqrt(55) / 33;
    wigner3j_coeffs(8072) = sqrt(11) / 33;
    wigner3j_coeffs(8080) = sqrt(462) / 462;
    wigner3j_coeffs(8088) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(8096) = sqrt(154) / 66;
    wigner3j_coeffs(8104) = -sqrt(1155) / 231;
    wigner3j_coeffs(8118) = sqrt(33) / 33;
    wigner3j_coeffs(8126) = sqrt(11) / 33;
    wigner3j_coeffs(8134) = -2 * sqrt(385) / 231;
    wigner3j_coeffs(8142) = sqrt(2310) / 462;
    wigner3j_coeffs(8150) = sqrt(154) / 462;
    wigner3j_coeffs(8158) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(8166) = sqrt(231) / 77;
    wigner3j_coeffs(8180) = -sqrt(22) / 22;
    wigner3j_coeffs(8188) = sqrt(462) / 462;
    wigner3j_coeffs(8196) = sqrt(2310) / 462;
    wigner3j_coeffs(8204) = -sqrt(154) / 77;
    wigner3j_coeffs(8212) = sqrt(2310) / 462;
    wigner3j_coeffs(8220) = sqrt(462) / 462;
    wigner3j_coeffs(8228) = -sqrt(22) / 22;
    wigner3j_coeffs(8242) = sqrt(231) / 77;
    wigner3j_coeffs(8250) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(8258) = sqrt(154) / 462;
    wigner3j_coeffs(8266) = sqrt(2310) / 462;
    wigner3j_coeffs(8274) = -2 * sqrt(385) / 231;
    wigner3j_coeffs(8282) = sqrt(11) / 33;
    wigner3j_coeffs(8290) = sqrt(33) / 33;
    wigner3j_coeffs(8304) = -sqrt(1155) / 231;
    wigner3j_coeffs(8312) = sqrt(154) / 66;
    wigner3j_coeffs(8320) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(8328) = sqrt(462) / 462;
    wigner3j_coeffs(8336) = sqrt(11) / 33;
    wigner3j_coeffs(8344) = -sqrt(55) / 33;
    wigner3j_coeffs(8366) = sqrt(154) / 154;
    wigner3j_coeffs(8374) = -sqrt(1155) / 231;
    wigner3j_coeffs(8382) = sqrt(231) / 77;
    wigner3j_coeffs(8390) = -sqrt(22) / 22;
    wigner3j_coeffs(8398) = sqrt(33) / 33;
    wigner3j_coeffs(8508) = sqrt(7) / 42;
    wigner3j_coeffs(8510) = -1 / 6;
    wigner3j_coeffs(8512) = 1 / 3;
    wigner3j_coeffs(8532) = -sqrt(21) / 42;
    wigner3j_coeffs(8534) = sqrt(21) / 21;
    wigner3j_coeffs(8536) = -sqrt(3) / 6;
    wigner3j_coeffs(8556) = sqrt(42) / 42;
    wigner3j_coeffs(8558) = -sqrt(105) / 42;
    wigner3j_coeffs(8560) = sqrt(105) / 42;
    wigner3j_coeffs(8580) = -sqrt(70) / 42;
    wigner3j_coeffs(8582) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(8584) = -sqrt(70) / 42;
    wigner3j_coeffs(8604) = sqrt(105) / 42;
    wigner3j_coeffs(8606) = -sqrt(105) / 42;
    wigner3j_coeffs(8608) = sqrt(42) / 42;
    wigner3j_coeffs(8628) = -sqrt(3) / 6;
    wigner3j_coeffs(8630) = sqrt(21) / 21;
    wigner3j_coeffs(8632) = -sqrt(21) / 42;
    wigner3j_coeffs(8652) = 1 / 3;
    wigner3j_coeffs(8654) = -1 / 6;
    wigner3j_coeffs(8656) = sqrt(7) / 42;
    wigner3j_coeffs(8706) = sqrt(210) / 210;
    wigner3j_coeffs(8710) = -sqrt(105) / 70;
    wigner3j_coeffs(8714) = sqrt(5) / 10;
    wigner3j_coeffs(8718) = -sqrt(15) / 15;
    wigner3j_coeffs(8746) = -sqrt(7) / 21;
    wigner3j_coeffs(8750) = sqrt(35) / 30;
    wigner3j_coeffs(8754) = -2 * sqrt(105) / 105;
    wigner3j_coeffs(8758) = sqrt(5) / 30;
    wigner3j_coeffs(8762) = sqrt(10) / 15;
    wigner3j_coeffs(8786) = sqrt(14) / 21;
    wigner3j_coeffs(8790) = -sqrt(70) / 42;
    wigner3j_coeffs(8794) = sqrt(21) / 42;
    wigner3j_coeffs(8798) = sqrt(7) / 42;
    wigner3j_coeffs(8802) = -sqrt(2) / 6;
    wigner3j_coeffs(8826) = -sqrt(21) / 21;
    wigner3j_coeffs(8830) = sqrt(42) / 42;
    wigner3j_coeffs(8838) = -sqrt(42) / 42;
    wigner3j_coeffs(8842) = sqrt(21) / 21;
    wigner3j_coeffs(8866) = sqrt(2) / 6;
    wigner3j_coeffs(8870) = -sqrt(7) / 42;
    wigner3j_coeffs(8874) = -sqrt(21) / 42;
    wigner3j_coeffs(8878) = sqrt(70) / 42;
    wigner3j_coeffs(8882) = -sqrt(14) / 21;
    wigner3j_coeffs(8906) = -sqrt(10) / 15;
    wigner3j_coeffs(8910) = -sqrt(5) / 30;
    wigner3j_coeffs(8914) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(8918) = -sqrt(35) / 30;
    wigner3j_coeffs(8922) = sqrt(7) / 21;
    wigner3j_coeffs(8950) = sqrt(15) / 15;
    wigner3j_coeffs(8954) = -sqrt(5) / 10;
    wigner3j_coeffs(8958) = sqrt(105) / 70;
    wigner3j_coeffs(8962) = -sqrt(210) / 210;
    wigner3j_coeffs(9026) = sqrt(154) / 154;
    wigner3j_coeffs(9032) = -sqrt(1155) / 231;
    wigner3j_coeffs(9038) = sqrt(231) / 77;
    wigner3j_coeffs(9044) = -sqrt(22) / 22;
    wigner3j_coeffs(9050) = sqrt(33) / 33;
    wigner3j_coeffs(9082) = -sqrt(1155) / 231;
    wigner3j_coeffs(9088) = sqrt(154) / 66;
    wigner3j_coeffs(9094) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(9100) = sqrt(462) / 462;
    wigner3j_coeffs(9106) = sqrt(11) / 33;
    wigner3j_coeffs(9112) = -sqrt(55) / 33;
    wigner3j_coeffs(9138) = sqrt(231) / 77;
    wigner3j_coeffs(9144) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(9150) = sqrt(154) / 462;
    wigner3j_coeffs(9156) = sqrt(2310) / 462;
    wigner3j_coeffs(9162) = -2 * sqrt(385) / 231;
    wigner3j_coeffs(9168) = sqrt(11) / 33;
    wigner3j_coeffs(9174) = sqrt(33) / 33;
    wigner3j_coeffs(9194) = -sqrt(22) / 22;
    wigner3j_coeffs(9200) = sqrt(462) / 462;
    wigner3j_coeffs(9206) = sqrt(2310) / 462;
    wigner3j_coeffs(9212) = -sqrt(154) / 77;
    wigner3j_coeffs(9218) = sqrt(2310) / 462;
    wigner3j_coeffs(9224) = sqrt(462) / 462;
    wigner3j_coeffs(9230) = -sqrt(22) / 22;
    wigner3j_coeffs(9250) = sqrt(33) / 33;
    wigner3j_coeffs(9256) = sqrt(11) / 33;
    wigner3j_coeffs(9262) = -2 * sqrt(385) / 231;
    wigner3j_coeffs(9268) = sqrt(2310) / 462;
    wigner3j_coeffs(9274) = sqrt(154) / 462;
    wigner3j_coeffs(9280) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(9286) = sqrt(231) / 77;
    wigner3j_coeffs(9312) = -sqrt(55) / 33;
    wigner3j_coeffs(9318) = sqrt(11) / 33;
    wigner3j_coeffs(9324) = sqrt(462) / 462;
    wigner3j_coeffs(9330) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(9336) = sqrt(154) / 66;
    wigner3j_coeffs(9342) = -sqrt(1155) / 231;
    wigner3j_coeffs(9374) = sqrt(33) / 33;
    wigner3j_coeffs(9380) = -sqrt(22) / 22;
    wigner3j_coeffs(9386) = sqrt(231) / 77;
    wigner3j_coeffs(9392) = -sqrt(1155) / 231;
    wigner3j_coeffs(9398) = sqrt(154) / 154;
    wigner3j_coeffs(9468) = sqrt(11) / 33;
    wigner3j_coeffs(9476) = -sqrt(110) / 66;
    wigner3j_coeffs(9484) = 5 * sqrt(77) / 231;
    wigner3j_coeffs(9492) = -5 * sqrt(77) / 231;
    wigner3j_coeffs(9500) = sqrt(110) / 66;
    wigner3j_coeffs(9508) = -sqrt(11) / 33;
    wigner3j_coeffs(9540) = -sqrt(33) / 33;
    wigner3j_coeffs(9548) = sqrt(33) / 33;
    wigner3j_coeffs(9556) = -sqrt(2310) / 462;
    wigner3j_coeffs(9572) = sqrt(2310) / 462;
    wigner3j_coeffs(9580) = -sqrt(33) / 33;
    wigner3j_coeffs(9588) = sqrt(33) / 33;
    wigner3j_coeffs(9612) = sqrt(1155) / 165;
    wigner3j_coeffs(9620) = -sqrt(165) / 165;
    wigner3j_coeffs(9628) = -2 * sqrt(1155) / 1155;
    wigner3j_coeffs(9636) = sqrt(462) / 154;
    wigner3j_coeffs(9644) = -sqrt(462) / 154;
    wigner3j_coeffs(9652) = 2 * sqrt(1155) / 1155;
    wigner3j_coeffs(9660) = sqrt(165) / 165;
    wigner3j_coeffs(9668) = -sqrt(1155) / 165;
    wigner3j_coeffs(9684) = -sqrt(770) / 165;
    wigner3j_coeffs(9692) = -sqrt(770) / 330;
    wigner3j_coeffs(9700) = 13 * sqrt(770) / 2310;
    wigner3j_coeffs(9708) = -3 * sqrt(770) / 770;
    wigner3j_coeffs(9724) = 3 * sqrt(770) / 770;
    wigner3j_coeffs(9732) = -13 * sqrt(770) / 2310;
    wigner3j_coeffs(9740) = sqrt(770) / 330;
    wigner3j_coeffs(9748) = sqrt(770) / 165;
    wigner3j_coeffs(9764) = sqrt(1155) / 165;
    wigner3j_coeffs(9772) = -sqrt(165) / 165;
    wigner3j_coeffs(9780) = -2 * sqrt(1155) / 1155;
    wigner3j_coeffs(9788) = sqrt(462) / 154;
    wigner3j_coeffs(9796) = -sqrt(462) / 154;
    wigner3j_coeffs(9804) = 2 * sqrt(1155) / 1155;
    wigner3j_coeffs(9812) = sqrt(165) / 165;
    wigner3j_coeffs(9820) = -sqrt(1155) / 165;
    wigner3j_coeffs(9844) = -sqrt(33) / 33;
    wigner3j_coeffs(9852) = sqrt(33) / 33;
    wigner3j_coeffs(9860) = -sqrt(2310) / 462;
    wigner3j_coeffs(9876) = sqrt(2310) / 462;
    wigner3j_coeffs(9884) = -sqrt(33) / 33;
    wigner3j_coeffs(9892) = sqrt(33) / 33;
    wigner3j_coeffs(9924) = sqrt(11) / 33;
    wigner3j_coeffs(9932) = -sqrt(110) / 66;
    wigner3j_coeffs(9940) = 5 * sqrt(77) / 231;
    wigner3j_coeffs(9948) = -5 * sqrt(77) / 231;
    wigner3j_coeffs(9956) = sqrt(110) / 66;
    wigner3j_coeffs(9964) = -sqrt(11) / 33;
    wigner3j_coeffs(10152) = 1 / 3;
    wigner3j_coeffs(10160) = -1 / 3;
    wigner3j_coeffs(10168) = 1 / 3;
    wigner3j_coeffs(10176) = -1 / 3;
    wigner3j_coeffs(10184) = 1 / 3;
    wigner3j_coeffs(10192) = -1 / 3;
    wigner3j_coeffs(10200) = 1 / 3;
    wigner3j_coeffs(10208) = -1 / 3;
    wigner3j_coeffs(10216) = 1 / 3;
    wigner3j_coeffs(10488) = 1 / 3;
    wigner3j_coeffs(10502) = -1 / 6;
    wigner3j_coeffs(10508) = -sqrt(3) / 6;
    wigner3j_coeffs(10516) = sqrt(7) / 42;
    wigner3j_coeffs(10522) = sqrt(21) / 21;
    wigner3j_coeffs(10528) = sqrt(105) / 42;
    wigner3j_coeffs(10536) = -sqrt(21) / 42;
    wigner3j_coeffs(10542) = -sqrt(105) / 42;
    wigner3j_coeffs(10548) = -sqrt(70) / 42;
    wigner3j_coeffs(10556) = sqrt(42) / 42;
    wigner3j_coeffs(10562) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(10568) = sqrt(42) / 42;
    wigner3j_coeffs(10576) = -sqrt(70) / 42;
    wigner3j_coeffs(10582) = -sqrt(105) / 42;
    wigner3j_coeffs(10588) = -sqrt(21) / 42;
    wigner3j_coeffs(10596) = sqrt(105) / 42;
    wigner3j_coeffs(10602) = sqrt(21) / 21;
    wigner3j_coeffs(10608) = sqrt(7) / 42;
    wigner3j_coeffs(10616) = -sqrt(3) / 6;
    wigner3j_coeffs(10622) = -1 / 6;
    wigner3j_coeffs(10636) = 1 / 3;
    wigner3j_coeffs(10674) = 2 * sqrt(5) / 15;
    wigner3j_coeffs(10682) = -sqrt(5) / 15;
    wigner3j_coeffs(10692) = -sqrt(5) / 15;
    wigner3j_coeffs(10700) = -sqrt(5) / 10;
    wigner3j_coeffs(10708) = sqrt(35) / 30;
    wigner3j_coeffs(10718) = sqrt(35) / 30;
    wigner3j_coeffs(10726) = sqrt(5) / 15;
    wigner3j_coeffs(10734) = -sqrt(5) / 10;
    wigner3j_coeffs(10744) = -sqrt(5) / 10;
    wigner3j_coeffs(10752) = -sqrt(5) / 30;
    wigner3j_coeffs(10760) = sqrt(2) / 6;
    wigner3j_coeffs(10770) = sqrt(2) / 6;
    wigner3j_coeffs(10786) = -sqrt(2) / 6;
    wigner3j_coeffs(10796) = -sqrt(2) / 6;
    wigner3j_coeffs(10804) = sqrt(5) / 30;
    wigner3j_coeffs(10812) = sqrt(5) / 10;
    wigner3j_coeffs(10822) = sqrt(5) / 10;
    wigner3j_coeffs(10830) = -sqrt(5) / 15;
    wigner3j_coeffs(10838) = -sqrt(35) / 30;
    wigner3j_coeffs(10848) = -sqrt(35) / 30;
    wigner3j_coeffs(10856) = sqrt(5) / 10;
    wigner3j_coeffs(10864) = sqrt(5) / 15;
    wigner3j_coeffs(10874) = sqrt(5) / 15;
    wigner3j_coeffs(10882) = -2 * sqrt(5) / 15;
    wigner3j_coeffs(11104) = 1 / 3;
    wigner3j_coeffs(11124) = -sqrt(2) / 6;
    wigner3j_coeffs(11128) = -sqrt(2) / 6;
    wigner3j_coeffs(11144) = sqrt(42) / 42;
    wigner3j_coeffs(11148) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(11152) = sqrt(42) / 42;
    wigner3j_coeffs(11164) = -sqrt(14) / 42;
    wigner3j_coeffs(11168) = -sqrt(21) / 21;
    wigner3j_coeffs(11172) = -sqrt(21) / 21;
    wigner3j_coeffs(11176) = -sqrt(14) / 42;
    wigner3j_coeffs(11184) = sqrt(70) / 210;
    wigner3j_coeffs(11188) = 2 * sqrt(70) / 105;
    wigner3j_coeffs(11192) = sqrt(70) / 35;
    wigner3j_coeffs(11196) = 2 * sqrt(70) / 105;
    wigner3j_coeffs(11200) = sqrt(70) / 210;
    wigner3j_coeffs(11208) = -sqrt(14) / 42;
    wigner3j_coeffs(11212) = -sqrt(21) / 21;
    wigner3j_coeffs(11216) = -sqrt(21) / 21;
    wigner3j_coeffs(11220) = -sqrt(14) / 42;
    wigner3j_coeffs(11232) = sqrt(42) / 42;
    wigner3j_coeffs(11236) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(11240) = sqrt(42) / 42;
    wigner3j_coeffs(11256) = -sqrt(2) / 6;
    wigner3j_coeffs(11260) = -sqrt(2) / 6;
    wigner3j_coeffs(11280) = 1 / 3;
    wigner3j_coeffs(11332) = sqrt(15) / 15;
    wigner3j_coeffs(11338) = -sqrt(10) / 15;
    wigner3j_coeffs(11360) = -sqrt(5) / 10;
    wigner3j_coeffs(11366) = -sqrt(5) / 30;
    wigner3j_coeffs(11372) = sqrt(2) / 6;
    wigner3j_coeffs(11388) = sqrt(105) / 70;
    wigner3j_coeffs(11394) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(11400) = -sqrt(7) / 42;
    wigner3j_coeffs(11406) = -sqrt(21) / 21;
    wigner3j_coeffs(11416) = -sqrt(210) / 210;
    wigner3j_coeffs(11422) = -sqrt(35) / 30;
    wigner3j_coeffs(11428) = -sqrt(21) / 42;
    wigner3j_coeffs(11434) = sqrt(42) / 42;
    wigner3j_coeffs(11440) = sqrt(14) / 21;
    wigner3j_coeffs(11450) = sqrt(7) / 21;
    wigner3j_coeffs(11456) = sqrt(70) / 42;
    wigner3j_coeffs(11468) = -sqrt(70) / 42;
    wigner3j_coeffs(11474) = -sqrt(7) / 21;
    wigner3j_coeffs(11484) = -sqrt(14) / 21;
    wigner3j_coeffs(11490) = -sqrt(42) / 42;
    wigner3j_coeffs(11496) = sqrt(21) / 42;
    wigner3j_coeffs(11502) = sqrt(35) / 30;
    wigner3j_coeffs(11508) = sqrt(210) / 210;
    wigner3j_coeffs(11518) = sqrt(21) / 21;
    wigner3j_coeffs(11524) = sqrt(7) / 42;
    wigner3j_coeffs(11530) = -2 * sqrt(105) / 105;
    wigner3j_coeffs(11536) = -sqrt(105) / 70;
    wigner3j_coeffs(11552) = -sqrt(2) / 6;
    wigner3j_coeffs(11558) = sqrt(5) / 30;
    wigner3j_coeffs(11564) = sqrt(5) / 10;
    wigner3j_coeffs(11586) = sqrt(10) / 15;
    wigner3j_coeffs(11592) = -sqrt(15) / 15;
    wigner3j_coeffs(11646) = 2 * sqrt(385) / 165;
    wigner3j_coeffs(11654) = -sqrt(1155) / 165;
    wigner3j_coeffs(11662) = sqrt(330) / 165;
    wigner3j_coeffs(11682) = -sqrt(1155) / 165;
    wigner3j_coeffs(11690) = -sqrt(385) / 330;
    wigner3j_coeffs(11698) = sqrt(165) / 66;
    wigner3j_coeffs(11706) = -sqrt(330) / 110;
    wigner3j_coeffs(11718) = sqrt(330) / 165;
    wigner3j_coeffs(11726) = sqrt(165) / 66;
    wigner3j_coeffs(11734) = -4 * sqrt(385) / 1155;
    wigner3j_coeffs(11742) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(11750) = sqrt(231) / 77;
    wigner3j_coeffs(11762) = -sqrt(330) / 110;
    wigner3j_coeffs(11770) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(11778) = 17 * sqrt(385) / 2310;
    wigner3j_coeffs(11786) = sqrt(462) / 462;
    wigner3j_coeffs(11794) = -sqrt(2310) / 231;
    wigner3j_coeffs(11806) = sqrt(231) / 77;
    wigner3j_coeffs(11814) = sqrt(462) / 462;
    wigner3j_coeffs(11822) = -2 * sqrt(385) / 231;
    wigner3j_coeffs(11830) = sqrt(462) / 462;
    wigner3j_coeffs(11838) = sqrt(231) / 77;
    wigner3j_coeffs(11850) = -sqrt(2310) / 231;
    wigner3j_coeffs(11858) = sqrt(462) / 462;
    wigner3j_coeffs(11866) = 17 * sqrt(385) / 2310;
    wigner3j_coeffs(11874) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(11882) = -sqrt(330) / 110;
    wigner3j_coeffs(11894) = sqrt(231) / 77;
    wigner3j_coeffs(11902) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(11910) = -4 * sqrt(385) / 1155;
    wigner3j_coeffs(11918) = sqrt(165) / 66;
    wigner3j_coeffs(11926) = sqrt(330) / 165;
    wigner3j_coeffs(11938) = -sqrt(330) / 110;
    wigner3j_coeffs(11946) = sqrt(165) / 66;
    wigner3j_coeffs(11954) = -sqrt(385) / 330;
    wigner3j_coeffs(11962) = -sqrt(1155) / 165;
    wigner3j_coeffs(11982) = sqrt(330) / 165;
    wigner3j_coeffs(11990) = -sqrt(1155) / 165;
    wigner3j_coeffs(11998) = 2 * sqrt(385) / 165;
    wigner3j_coeffs(12108) = 1 / 3;
    wigner3j_coeffs(12126) = -sqrt(3) / 6;
    wigner3j_coeffs(12128) = -1 / 6;
    wigner3j_coeffs(12144) = sqrt(105) / 42;
    wigner3j_coeffs(12146) = sqrt(21) / 21;
    wigner3j_coeffs(12148) = sqrt(7) / 42;
    wigner3j_coeffs(12162) = -sqrt(70) / 42;
    wigner3j_coeffs(12164) = -sqrt(105) / 42;
    wigner3j_coeffs(12166) = -sqrt(21) / 42;
    wigner3j_coeffs(12180) = sqrt(42) / 42;
    wigner3j_coeffs(12182) = 2 * sqrt(7) / 21;
    wigner3j_coeffs(12184) = sqrt(42) / 42;
    wigner3j_coeffs(12198) = -sqrt(21) / 42;
    wigner3j_coeffs(12200) = -sqrt(105) / 42;
    wigner3j_coeffs(12202) = -sqrt(70) / 42;
    wigner3j_coeffs(12216) = sqrt(7) / 42;
    wigner3j_coeffs(12218) = sqrt(21) / 21;
    wigner3j_coeffs(12220) = sqrt(105) / 42;
    wigner3j_coeffs(12236) = -1 / 6;
    wigner3j_coeffs(12238) = -sqrt(3) / 6;
    wigner3j_coeffs(12256) = 1 / 3;
    wigner3j_coeffs(12306) = sqrt(10) / 15;
    wigner3j_coeffs(12310) = -sqrt(15) / 15;
    wigner3j_coeffs(12336) = -sqrt(2) / 6;
    wigner3j_coeffs(12340) = sqrt(5) / 30;
    wigner3j_coeffs(12344) = sqrt(5) / 10;
    wigner3j_coeffs(12366) = sqrt(21) / 21;
    wigner3j_coeffs(12370) = sqrt(7) / 42;
    wigner3j_coeffs(12374) = -2 * sqrt(105) / 105;
    wigner3j_coeffs(12378) = -sqrt(105) / 70;
    wigner3j_coeffs(12396) = -sqrt(14) / 21;
    wigner3j_coeffs(12400) = -sqrt(42) / 42;
    wigner3j_coeffs(12404) = sqrt(21) / 42;
    wigner3j_coeffs(12408) = sqrt(35) / 30;
    wigner3j_coeffs(12412) = sqrt(210) / 210;
    wigner3j_coeffs(12426) = sqrt(7) / 21;
    wigner3j_coeffs(12430) = sqrt(70) / 42;
    wigner3j_coeffs(12438) = -sqrt(70) / 42;
    wigner3j_coeffs(12442) = -sqrt(7) / 21;
    wigner3j_coeffs(12456) = -sqrt(210) / 210;
    wigner3j_coeffs(12460) = -sqrt(35) / 30;
    wigner3j_coeffs(12464) = -sqrt(21) / 42;
    wigner3j_coeffs(12468) = sqrt(42) / 42;
    wigner3j_coeffs(12472) = sqrt(14) / 21;
    wigner3j_coeffs(12490) = sqrt(105) / 70;
    wigner3j_coeffs(12494) = 2 * sqrt(105) / 105;
    wigner3j_coeffs(12498) = -sqrt(7) / 42;
    wigner3j_coeffs(12502) = -sqrt(21) / 21;
    wigner3j_coeffs(12524) = -sqrt(5) / 10;
    wigner3j_coeffs(12528) = -sqrt(5) / 30;
    wigner3j_coeffs(12532) = sqrt(2) / 6;
    wigner3j_coeffs(12558) = sqrt(15) / 15;
    wigner3j_coeffs(12562) = -sqrt(10) / 15;
    wigner3j_coeffs(12626) = sqrt(33) / 33;
    wigner3j_coeffs(12632) = -sqrt(55) / 33;
    wigner3j_coeffs(12638) = sqrt(33) / 33;
    wigner3j_coeffs(12668) = -sqrt(22) / 22;
    wigner3j_coeffs(12674) = sqrt(11) / 33;
    wigner3j_coeffs(12680) = sqrt(11) / 33;
    wigner3j_coeffs(12686) = -sqrt(22) / 22;
    wigner3j_coeffs(12710) = sqrt(231) / 77;
    wigner3j_coeffs(12716) = sqrt(462) / 462;
    wigner3j_coeffs(12722) = -2 * sqrt(385) / 231;
    wigner3j_coeffs(12728) = sqrt(462) / 462;
    wigner3j_coeffs(12734) = sqrt(231) / 77;
    wigner3j_coeffs(12752) = -sqrt(1155) / 231;
    wigner3j_coeffs(12758) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(12764) = sqrt(2310) / 462;
    wigner3j_coeffs(12770) = sqrt(2310) / 462;
    wigner3j_coeffs(12776) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(12782) = -sqrt(1155) / 231;
    wigner3j_coeffs(12794) = sqrt(154) / 154;
    wigner3j_coeffs(12800) = sqrt(154) / 66;
    wigner3j_coeffs(12806) = sqrt(154) / 462;
    wigner3j_coeffs(12812) = -sqrt(154) / 77;
    wigner3j_coeffs(12818) = sqrt(154) / 462;
    wigner3j_coeffs(12824) = sqrt(154) / 66;
    wigner3j_coeffs(12830) = sqrt(154) / 154;
    wigner3j_coeffs(12842) = -sqrt(1155) / 231;
    wigner3j_coeffs(12848) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(12854) = sqrt(2310) / 462;
    wigner3j_coeffs(12860) = sqrt(2310) / 462;
    wigner3j_coeffs(12866) = -4 * sqrt(77) / 231;
    wigner3j_coeffs(12872) = -sqrt(1155) / 231;
    wigner3j_coeffs(12890) = sqrt(231) / 77;
    wigner3j_coeffs(12896) = sqrt(462) / 462;
    wigner3j_coeffs(12902) = -2 * sqrt(385) / 231;
    wigner3j_coeffs(12908) = sqrt(462) / 462;
    wigner3j_coeffs(12914) = sqrt(231) / 77;
    wigner3j_coeffs(12938) = -sqrt(22) / 22;
    wigner3j_coeffs(12944) = sqrt(11) / 33;
    wigner3j_coeffs(12950) = sqrt(11) / 33;
    wigner3j_coeffs(12956) = -sqrt(22) / 22;
    wigner3j_coeffs(12986) = sqrt(33) / 33;
    wigner3j_coeffs(12992) = -sqrt(55) / 33;
    wigner3j_coeffs(12998) = sqrt(33) / 33;
    wigner3j_coeffs(13068) = sqrt(770) / 165;
    wigner3j_coeffs(13076) = -sqrt(1155) / 165;
    wigner3j_coeffs(13084) = sqrt(33) / 33;
    wigner3j_coeffs(13092) = -sqrt(11) / 33;
    wigner3j_coeffs(13122) = -sqrt(1155) / 165;
    wigner3j_coeffs(13130) = sqrt(770) / 330;
    wigner3j_coeffs(13138) = sqrt(165) / 165;
    wigner3j_coeffs(13146) = -sqrt(33) / 33;
    wigner3j_coeffs(13154) = sqrt(110) / 66;
    wigner3j_coeffs(13176) = sqrt(33) / 33;
    wigner3j_coeffs(13184) = sqrt(165) / 165;
    wigner3j_coeffs(13192) = -13 * sqrt(770) / 2310;
    wigner3j_coeffs(13200) = 2 * sqrt(1155) / 1155;
    wigner3j_coeffs(13208) = sqrt(2310) / 462;
    wigner3j_coeffs(13216) = -5 * sqrt(77) / 231;
    wigner3j_coeffs(13230) = -sqrt(11) / 33;
    wigner3j_coeffs(13238) = -sqrt(33) / 33;
    wigner3j_coeffs(13246) = 2 * sqrt(1155) / 1155;
    wigner3j_coeffs(13254) = 3 * sqrt(770) / 770;
    wigner3j_coeffs(13262) = -sqrt(462) / 154;
    wigner3j_coeffs(13278) = 5 * sqrt(77) / 231;
    wigner3j_coeffs(13292) = sqrt(110) / 66;
    wigner3j_coeffs(13300) = sqrt(2310) / 462;
    wigner3j_coeffs(13308) = -sqrt(462) / 154;
    wigner3j_coeffs(13324) = sqrt(462) / 154;
    wigner3j_coeffs(13332) = -sqrt(2310) / 462;
    wigner3j_coeffs(13340) = -sqrt(110) / 66;
    wigner3j_coeffs(13354) = -5 * sqrt(77) / 231;
    wigner3j_coeffs(13370) = sqrt(462) / 154;
    wigner3j_coeffs(13378) = -3 * sqrt(770) / 770;
    wigner3j_coeffs(13386) = -2 * sqrt(1155) / 1155;
    wigner3j_coeffs(13394) = sqrt(33) / 33;
    wigner3j_coeffs(13402) = sqrt(11) / 33;
    wigner3j_coeffs(13416) = 5 * sqrt(77) / 231;
    wigner3j_coeffs(13424) = -sqrt(2310) / 462;
    wigner3j_coeffs(13432) = -2 * sqrt(1155) / 1155;
    wigner3j_coeffs(13440) = 13 * sqrt(770) / 2310;
    wigner3j_coeffs(13448) = -sqrt(165) / 165;
    wigner3j_coeffs(13456) = -sqrt(33) / 33;
    wigner3j_coeffs(13478) = -sqrt(110) / 66;
    wigner3j_coeffs(13486) = sqrt(33) / 33;
    wigner3j_coeffs(13494) = -sqrt(165) / 165;
    wigner3j_coeffs(13502) = -sqrt(770) / 330;
    wigner3j_coeffs(13510) = sqrt(1155) / 165;
    wigner3j_coeffs(13540) = sqrt(11) / 33;
    wigner3j_coeffs(13548) = -sqrt(33) / 33;
    wigner3j_coeffs(13556) = sqrt(1155) / 165;
    wigner3j_coeffs(13564) = -sqrt(770) / 165;
    wigner3j_coeffs(13608) = 1 / 3;
    wigner3j_coeffs(13616) = -1 / 3;
    wigner3j_coeffs(13624) = 1 / 3;
    wigner3j_coeffs(13632) = -1 / 3;
    wigner3j_coeffs(13640) = 1 / 3;
    wigner3j_coeffs(13648) = -1 / 3;
    wigner3j_coeffs(13656) = 1 / 3;
    wigner3j_coeffs(13664) = -1 / 3;
    wigner3j_coeffs(13672) = 1 / 3;
    wigner3j_coeffs(13704) = sqrt(5) / 15;
    wigner3j_coeffs(13706) = -2 * sqrt(5) / 15;
    wigner3j_coeffs(13728) = -sqrt(35) / 30;
    wigner3j_coeffs(13730) = sqrt(5) / 10;
    wigner3j_coeffs(13732) = sqrt(5) / 15;
    wigner3j_coeffs(13752) = sqrt(5) / 10;
    wigner3j_coeffs(13754) = -sqrt(5) / 15;
    wigner3j_coeffs(13756) = -sqrt(35) / 30;
    wigner3j_coeffs(13776) = -sqrt(2) / 6;
    wigner3j_coeffs(13778) = sqrt(5) / 30;
    wigner3j_coeffs(13780) = sqrt(5) / 10;
    wigner3j_coeffs(13800) = sqrt(2) / 6;
    wigner3j_coeffs(13804) = -sqrt(2) / 6;
    wigner3j_coeffs(13824) = -sqrt(5) / 10;
    wigner3j_coeffs(13826) = -sqrt(5) / 30;
    wigner3j_coeffs(13828) = sqrt(2) / 6;
    wigner3j_coeffs(13848) = sqrt(35) / 30;
    wigner3j_coeffs(13850) = sqrt(5) / 15;
    wigner3j_coeffs(13852) = -sqrt(5) / 10;
    wigner3j_coeffs(13872) = -sqrt(5) / 15;
    wigner3j_coeffs(13874) = -sqrt(5) / 10;
    wigner3j_coeffs(13876) = sqrt(35) / 30;
    wigner3j_coeffs(13898) = 2 * sqrt(5) / 15;
    wigner3j_coeffs(13900) = -sqrt(5) / 15;
    wigner3j_coeffs(13958) = sqrt(330) / 165;
    wigner3j_coeffs(13962) = -sqrt(1155) / 165;
    wigner3j_coeffs(13966) = 2 * sqrt(385) / 165;
    wigner3j_coeffs(13998) = -sqrt(330) / 110;
    wigner3j_coeffs(14002) = sqrt(165) / 66;
    wigner3j_coeffs(14006) = -sqrt(385) / 330;
    wigner3j_coeffs(14010) = -sqrt(1155) / 165;
    wigner3j_coeffs(14038) = sqrt(231) / 77;
    wigner3j_coeffs(14042) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(14046) = -4 * sqrt(385) / 1155;
    wigner3j_coeffs(14050) = sqrt(165) / 66;
    wigner3j_coeffs(14054) = sqrt(330) / 165;
    wigner3j_coeffs(14078) = -sqrt(2310) / 231;
    wigner3j_coeffs(14082) = sqrt(462) / 462;
    wigner3j_coeffs(14086) = 17 * sqrt(385) / 2310;
    wigner3j_coeffs(14090) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(14094) = -sqrt(330) / 110;
    wigner3j_coeffs(14118) = sqrt(231) / 77;
    wigner3j_coeffs(14122) = sqrt(462) / 462;
    wigner3j_coeffs(14126) = -2 * sqrt(385) / 231;
    wigner3j_coeffs(14130) = sqrt(462) / 462;
    wigner3j_coeffs(14134) = sqrt(231) / 77;
    wigner3j_coeffs(14158) = -sqrt(330) / 110;
    wigner3j_coeffs(14162) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(14166) = 17 * sqrt(385) / 2310;
    wigner3j_coeffs(14170) = sqrt(462) / 462;
    wigner3j_coeffs(14174) = -sqrt(2310) / 231;
    wigner3j_coeffs(14198) = sqrt(330) / 165;
    wigner3j_coeffs(14202) = sqrt(165) / 66;
    wigner3j_coeffs(14206) = -4 * sqrt(385) / 1155;
    wigner3j_coeffs(14210) = -3 * sqrt(1155) / 770;
    wigner3j_coeffs(14214) = sqrt(231) / 77;
    wigner3j_coeffs(14242) = -sqrt(1155) / 165;
    wigner3j_coeffs(14246) = -sqrt(385) / 330;
    wigner3j_coeffs(14250) = sqrt(165) / 66;
    wigner3j_coeffs(14254) = -sqrt(330) / 110;
    wigner3j_coeffs(14286) = 2 * sqrt(385) / 165;
    wigner3j_coeffs(14290) = -sqrt(1155) / 165;
    wigner3j_coeffs(14294) = sqrt(330) / 165;
    wigner3j_coeffs(14370) = sqrt(11) / 33;
    wigner3j_coeffs(14376) = -sqrt(33) / 33;
    wigner3j_coeffs(14382) = sqrt(1155) / 165;
    wigner3j_coeffs(14388) = -sqrt(770) / 165;
    wigner3j_coeffs(14426) = -sqrt(110) / 66;
    wigner3j_coeffs(14432) = sqrt(33) / 33;
    wigner3j_coeffs(14438) = -sqrt(165) / 165;
    wigner3j_coeffs(14444) = -sqrt(770) / 330;
    wigner3j_coeffs(14450) = sqrt(1155) / 165;
    wigner3j_coeffs(14482) = 5 * sqrt(77) / 231;
    wigner3j_coeffs(14488) = -sqrt(2310) / 462;
    wigner3j_coeffs(14494) = -2 * sqrt(1155) / 1155;
    wigner3j_coeffs(14500) = 13 * sqrt(770) / 2310;
    wigner3j_coeffs(14506) = -sqrt(165) / 165;
    wigner3j_coeffs(14512) = -sqrt(33) / 33;
    wigner3j_coeffs(14538) = -5 * sqrt(77) / 231;
    wigner3j_coeffs(14550) = sqrt(462) / 154;
    wigner3j_coeffs(14556) = -3 * sqrt(770) / 770;
    wigner3j_coeffs(14562) = -2 * sqrt(1155) / 1155;
    wigner3j_coeffs(14568) = sqrt(33) / 33;
    wigner3j_coeffs(14574) = sqrt(11) / 33;
    wigner3j_coeffs(14594) = sqrt(110) / 66;
    wigner3j_coeffs(14600) = sqrt(2310) / 462;
    wigner3j_coeffs(14606) = -sqrt(462) / 154;
    wigner3j_coeffs(14618) = sqrt(462) / 154;
    wigner3j_coeffs(14624) = -sqrt(2310) / 462;
    wigner3j_coeffs(14630) = -sqrt(110) / 66;
    wigner3j_coeffs(14650) = -sqrt(11) / 33;
    wigner3j_coeffs(14656) = -sqrt(33) / 33;
    wigner3j_coeffs(14662) = 2 * sqrt(1155) / 1155;
    wigner3j_coeffs(14668) = 3 * sqrt(770) / 770;
    wigner3j_coeffs(14674) = -sqrt(462) / 154;
    wigner3j_coeffs(14686) = 5 * sqrt(77) / 231;
    wigner3j_coeffs(14712) = sqrt(33) / 33;
    wigner3j_coeffs(14718) = sqrt(165) / 165;
    wigner3j_coeffs(14724) = -13 * sqrt(770) / 2310;
    wigner3j_coeffs(14730) = 2 * sqrt(1155) / 1155;
    wigner3j_coeffs(14736) = sqrt(2310) / 462;
    wigner3j_coeffs(14742) = -5 * sqrt(77) / 231;
    wigner3j_coeffs(14774) = -sqrt(1155) / 165;
    wigner3j_coeffs(14780) = sqrt(770) / 330;
    wigner3j_coeffs(14786) = sqrt(165) / 165;
    wigner3j_coeffs(14792) = -sqrt(33) / 33;
    wigner3j_coeffs(14798) = sqrt(110) / 66;
    wigner3j_coeffs(14836) = sqrt(770) / 165;
    wigner3j_coeffs(14842) = -sqrt(1155) / 165;
    wigner3j_coeffs(14848) = sqrt(33) / 33;
    wigner3j_coeffs(14854) = -sqrt(11) / 33;
    wigner3j_coeffs(14940) = sqrt(2002) / 429;
    wigner3j_coeffs(14948) = -sqrt(5005) / 429;
    wigner3j_coeffs(14956) = sqrt(715) / 143;
    wigner3j_coeffs(14964) = -sqrt(5005) / 429;
    wigner3j_coeffs(14972) = sqrt(2002) / 429;
    wigner3j_coeffs(15012) = -sqrt(5005) / 429;
    wigner3j_coeffs(15020) = sqrt(2002) / 286;
    wigner3j_coeffs(15028) = -sqrt(715) / 429;
    wigner3j_coeffs(15036) = -sqrt(715) / 429;
    wigner3j_coeffs(15044) = sqrt(2002) / 286;
    wigner3j_coeffs(15052) = -sqrt(5005) / 429;
    wigner3j_coeffs(15084) = sqrt(715) / 143;
    wigner3j_coeffs(15092) = -sqrt(715) / 429;
    wigner3j_coeffs(15100) = -sqrt(2002) / 546;
    wigner3j_coeffs(15108) = 2 * sqrt(5005) / 1001;
    wigner3j_coeffs(15116) = -sqrt(2002) / 546;
    wigner3j_coeffs(15124) = -sqrt(715) / 429;
    wigner3j_coeffs(15132) = sqrt(715) / 143;
    wigner3j_coeffs(15156) = -sqrt(5005) / 429;
    wigner3j_coeffs(15164) = -sqrt(715) / 429;
    wigner3j_coeffs(15172) = 2 * sqrt(5005) / 1001;
    wigner3j_coeffs(15180) = -3 * sqrt(2002) / 2002;
    wigner3j_coeffs(15188) = -3 * sqrt(2002) / 2002;
    wigner3j_coeffs(15196) = 2 * sqrt(5005) / 1001;
    wigner3j_coeffs(15204) = -sqrt(715) / 429;
    wigner3j_coeffs(15212) = -sqrt(5005) / 429;
    wigner3j_coeffs(15228) = sqrt(2002) / 429;
    wigner3j_coeffs(15236) = sqrt(2002) / 286;
    wigner3j_coeffs(15244) = -sqrt(2002) / 546;
    wigner3j_coeffs(15252) = -3 * sqrt(2002) / 2002;
    wigner3j_coeffs(15260) = 3 * sqrt(2002) / 1001;
    wigner3j_coeffs(15268) = -3 * sqrt(2002) / 2002;
    wigner3j_coeffs(15276) = -sqrt(2002) / 546;
    wigner3j_coeffs(15284) = sqrt(2002) / 286;
    wigner3j_coeffs(15292) = sqrt(2002) / 429;
    wigner3j_coeffs(15308) = -sqrt(5005) / 429;
    wigner3j_coeffs(15316) = -sqrt(715) / 429;
    wigner3j_coeffs(15324) = 2 * sqrt(5005) / 1001;
    wigner3j_coeffs(15332) = -3 * sqrt(2002) / 2002;
    wigner3j_coeffs(15340) = -3 * sqrt(2002) / 2002;
    wigner3j_coeffs(15348) = 2 * sqrt(5005) / 1001;
    wigner3j_coeffs(15356) = -sqrt(715) / 429;
    wigner3j_coeffs(15364) = -sqrt(5005) / 429;
    wigner3j_coeffs(15388) = sqrt(715) / 143;
    wigner3j_coeffs(15396) = -sqrt(715) / 429;
    wigner3j_coeffs(15404) = -sqrt(2002) / 546;
    wigner3j_coeffs(15412) = 2 * sqrt(5005) / 1001;
    wigner3j_coeffs(15420) = -sqrt(2002) / 546;
    wigner3j_coeffs(15428) = -sqrt(715) / 429;
    wigner3j_coeffs(15436) = sqrt(715) / 143;
    wigner3j_coeffs(15468) = -sqrt(5005) / 429;
    wigner3j_coeffs(15476) = sqrt(2002) / 286;
    wigner3j_coeffs(15484) = -sqrt(715) / 429;
    wigner3j_coeffs(15492) = -sqrt(715) / 429;
    wigner3j_coeffs(15500) = sqrt(2002) / 286;
    wigner3j_coeffs(15508) = -sqrt(5005) / 429;
    wigner3j_coeffs(15548) = sqrt(2002) / 429;
    wigner3j_coeffs(15556) = -sqrt(5005) / 429;
    wigner3j_coeffs(15564) = sqrt(715) / 143;
    wigner3j_coeffs(15572) = -sqrt(5005) / 429;
    wigner3j_coeffs(15580) = sqrt(2002) / 429;
  } else {
    std::cout << "Not implemented." << std::endl;
  }

  return wigner3j_coeffs;
}
