# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['stock_info_easy']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.5.2,<2.0.0']

setup_kwargs = {
    'name': 'stock-info-easy',
    'version': '1.1.6',
    'description': 'This package provides user-friendly functions to easily navigate stock information of the companies of their interests. The output results include visualization of closing prices and daily returns, stock prediction for the next twenty days, as well as the company information with sectors and PE ratios.',
    'long_description': '# Stock_Info_Easy\n\nThis Python package is an implementation of the existing  __*yfinance wrapper*__, one of the  widely used yahoo finance API wrappers.\nOne drawback of the existing yahoo finance API wrapper is its inability to fetch stock data using the company name; it can only fetch the data with company symbol registered on the Yahoo Finance. <br><br>\nTo improve the functionality of the previous wrapper, this package enables a user to query a company with its full name.\nBy simply typing a company name, this pacakage will generate today\'s stock information for the company of interest. \n\nThe fetched data includes: <br>\n* _company name, open, high, low, close (closing price), adj close, volume, daily return, and PE ratios._ <br>\n<br>\nThe stock information will be provided in dynamic formats with the use of visualizations, a data table, a stock forecast and an audio file.\n\n## Installation\n\n```bash\n$ pip install stock_info_easy\n```\n\n\n## Usage\nTo execute the package, __simply type the names of companies__. <br> \nOn the terminal, type:  \n```python\n# Example: Only specify a company name(s) to query, using all other parameters as default.\n>>> Input:\n% get_hist_data([\'amazon\', \'apple\', \'microsoft\', \'google\'], start_date = 01/04/2022, end_date = \'01/10/2022\') # end_date is today\'s date by default.\n\n>>> Output: \n[                Open        High         Low       Close      Adj Close    Volume     company_name     company_fullname\n    2022-01-04  170.438004  171.399994  166.349503  167.522003  167.522003  70726000       amazon           AMAZON\n    2022-01-05  166.882996  167.126495  164.356995  164.356995  164.356995  64302000       amazon           AMAZON\n    2022-01-06  163.450500  164.800003  161.936996  163.253998  163.253998  51958000       amazon           AMAZON\n    2022-01-07  163.839005  165.243500  162.031006  162.554001  162.554001  46606000       amazon           AMAZON\n    2022-01-10  160.585495  161.661499  156.304504  161.485992  161.485992  87798000       amazon           AMAZON\n    [5 rows x 8 columns],\n    \n    Open        High         Low       Close   Adj Close     Volume company_name company_fullname\n    2022-01-04  182.630005  182.940002  179.119995  179.699997  178.663086   99310400        apple            APPLE\n    2022-01-05  179.610001  180.169998  174.639999  174.919998  173.910645   94537600        apple            APPLE\n    2022-01-06  172.699997  175.300003  171.639999  172.000000  171.007523   96904000        apple            APPLE\n    2022-01-07  172.889999  174.139999  171.029999  172.169998  171.176529   86709100        apple            APPLE\n    2022-01-10  169.080002  172.500000  168.169998  172.190002  171.196426  106765600        apple            APPLE\n    [5 rows x 8 columns], \n    \n    Open        High         Low       Close   Adj Close    Volume company_name company_fullname\n    2022-01-04  145.550507  146.610001  143.816147  144.416504  144.416504  22928000       google           GOOGLE\n    2022-01-05  144.181000  144.298004  137.523499  137.653503  137.653503  49642000       google           GOOGLE\n    2022-01-06  137.497498  139.686005  136.763504  137.550995  137.550995  29050000       google           GOOGLE\n    2022-01-07  137.904999  138.254745  135.789001  137.004501  137.004501  19408000       google           GOOGLE\n    2022-01-10  135.098999  138.639999  133.140503  138.574005  138.574005  34096000       google           GOOGLE\n    [5 rows x 8 columns],\n    \n    Open        High         Low       Close   Adj Close    Volume company_name company_fullname\n    2022-01-04  334.829987  335.200012  326.119995  329.010010  325.955750  32674300    microsoft        MICROSOFT\n    2022-01-05  325.859985  326.070007  315.980011  316.380005  313.442993  40054300    microsoft        MICROSOFT\n    2022-01-06  313.149994  318.700012  311.489990  313.880005  310.966187  39646100    microsoft        MICROSOFT\n    2022-01-07  314.149994  316.500000  310.089996  314.040009  311.124725  32720000    microsoft        MICROSOFT\n    2022-01-10  309.489990  314.720001  304.690002  314.269989  311.352570  44289500    microsoft        MICROSOFT\n    [5 rows x 8 columns]]\n```\n\n#### 2. Visualization of Closing Price\n```python\n>>> Input: get_closing_price_viz(company_list, comp_names) # company_list and comp_names are output from the previous function.\n```\n<p align="center">\n<img src="https://github.com/shaunahan/Stock_Info_Easy/blob/main/img/closing_price.png" width="900" height="400"/>\n</p>\n<br>\n\n#### 3. Visualization of Daily Return\n```python\n>>> Input: get_daily_return_viz(company_list, company_names)\n```\n<p align="center">\n<img src="https://github.com/shaunahan/Stock_Info_Easy/blob/main/img/daily_return.png" width="750" height="430" />\n</p>\n\n#### 4. Audio file on Stock Info\nThis package provides key stock information such as PE ratio and basic company information of all queries companies in an audio format. \n```python\n% generate_audio(comp_names_abbr, audio_filename=\'default1.mp3\') # insert a filename in audio_filename\n```\n<br>\n\n#### 5. Prediction on Closing Price\nThis package uses the time series LSTM vanila model to predict the closing price. \nLSTM model is built with two hidden LSTM layers followed by a standard feedforward output layer. \n\n```python\n# Write following functions \n% create_pricelist(close_prices, windown_size = 30)\n% predict_rolling_price(result_list, model, window_size = 30, predict_window_size = 10)\n% train_model(stock, comp_name, windown_size=30, predict_window_size=10)\n```\n<p align="center">\n<img src="https://github.com/shaunahan/Stock_Info_Easy/blob/main/img/closing_price_forecast.png", width="850" height="350" />\n</p>\n<br>\n\n\n## Contributing\n\nInterested in contributing? Check out the contributing guidelines. Please note that this project is released with a Code of Conduct. By contributing to this project, you agree to abide by its terms.\n\n## License\n\n`stock_info_easy` was created by Shauna Han. It is licensed under the terms of the MIT license.\n\n## Credits\n\n`stock_info_easy` was created with [`cookiecutter`](https://cookiecutter.readthedocs.io/en/latest/) and the `py-pkgs-cookiecutter` [template](https://github.com/py-pkgs/py-pkgs-cookiecutter).',
    'author': 'Shauna Han',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/shaunahan/Stock_Info_Easy',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
