---
title: "ReadMe"
author: "Amy Allen"
date: "8/18/2020"
output: html_document
---

```{r setup, include=FALSE}
knitr::opts_chunk$set(echo = TRUE)
```


## Add EV Charging Load
## Description
This measure adds an electric vehicle charging load, based on the load profiles developed by Wood et al. (2018), generated to reflect several different potential scenarios for EV charging behavior. The user can configure the magnitude of the load based on the proportion of vehicles at the site that are assumed to be EVs. 

## Modeler Description 
The raw data used to generate the load profiles is saved in the "Resources" folder. The load that is added is an ExteriorFuelEquipment object. The load profiles generated by Wood et al. (2018) are based on an assumption of a 50% EV penetration rate. 

## Measure Type
ModelMeasure

## Arguments
## EV Percent
Name: EV Percent, Type: Double, Units: Percent , Required: true, Model Dependent: false. This argument is used to scale the load profiles generated by Wood et al. (2018). If not supplied by the user, the value defaults to 1%. 

## Charging Behavior 
Name: Charging Behavior, Type: Choice (Business as Usual, Free Workplace Charging at Project Site, Free Workplace Charging Throughout Metropolitan Area), Units: None, Required: true, Model Dependent: false. Separate load profiles were generated by Wood et al. (2018) for each of these cases to reflect consumer behavior under differing availability of free EV charging. 

## Charge Station Type
Name: Charge Station Type, Type: Choice (Home, Typical Work, Typical Public), Units: None, Required: true, Model Dependent: false. This argument is used to select a subset of the profiles developed by Wood et al. (2018), which will be averaged to generate the profile for this particular building, based on its type.

## Charge Delay
Name: Charge Delay, Type: Choice (Min Delay, Max Delay, Min Power) Units: None, Required: true, Model dependent: false. This argument is used to select a subset of profiles based on those generated by Wood et al. (2018), to reflect different approaches for control of EV charging. "Min delay" refers to a scenario in which the vehicle charging begins as soon as it is plugged in, "Max delay" refers to a control strategy that seeks to have the vehicle charged by the time the driver departs, and no sooner, and "Min power" seeks to minimize the power draw associated with charging. 
