import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudIpblockConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#id DataIonoscloudIpblock#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#location DataIonoscloudIpblock#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#name DataIonoscloudIpblock#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#size DataIonoscloudIpblock#size}
    */
    readonly size?: number;
    /**
    * ip_consumers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#ip_consumers DataIonoscloudIpblock#ip_consumers}
    */
    readonly ipConsumers?: DataIonoscloudIpblockIpConsumers[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#timeouts DataIonoscloudIpblock#timeouts}
    */
    readonly timeouts?: DataIonoscloudIpblockTimeouts;
}
export interface DataIonoscloudIpblockIpConsumers {
}
export declare function dataIonoscloudIpblockIpConsumersToTerraform(struct?: DataIonoscloudIpblockIpConsumers | cdktf.IResolvable): any;
export interface DataIonoscloudIpblockTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#create DataIonoscloudIpblock#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#default DataIonoscloudIpblock#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#delete DataIonoscloudIpblock#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock#update DataIonoscloudIpblock#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudIpblockTimeoutsToTerraform(struct?: DataIonoscloudIpblockTimeoutsOutputReference | DataIonoscloudIpblockTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudIpblockTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudIpblockTimeouts | undefined;
    set internalValue(value: DataIonoscloudIpblockTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock ionoscloud_ipblock}
*/
export declare class DataIonoscloudIpblock extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_ipblock";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/ipblock ionoscloud_ipblock} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudIpblockConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudIpblockConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ips(): string[];
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _ipConsumers?;
    get ipConsumers(): DataIonoscloudIpblockIpConsumers[] | cdktf.IResolvable;
    set ipConsumers(value: DataIonoscloudIpblockIpConsumers[] | cdktf.IResolvable);
    resetIpConsumers(): void;
    get ipConsumersInput(): cdktf.IResolvable | DataIonoscloudIpblockIpConsumers[] | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudIpblockTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudIpblockTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudIpblockTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
