# 한글 프로그래밍 언어 "나무"
"나무"는 코딩 입문자가 쉽게 사용할 수 있는 한글 프로그래밍 언어입니다.
# 도움말
## 시작하기
### 인터프리터 실행하기
1. 당연하게도(?) 나무를 실행하기 위해 파이썬을 설치합니다.
2. 터미널이나 Shell 창에 `pip install namu`를 입력합니다.
3. 파이썬 파일에
   ```python
   import namu
   namu.interpreter()
   ```
   을 입력하고 실행시키면...!
4. 콘솔창에서 나무 인터프리터가 실행됩니다!!
## 문법
### 1. 코드 작성
나무는 파이썬처럼 하나의 줄에 한 문장을 입력합니다.

#### **줄 구분**

나무는 `CRLF`와 `LF`, `;`(세미콜론)으로 줄을 구분합니다.
한 줄에는 하나의 문장만이 들어가지만 (), {}, [] 등의 괄호쌍 내부에서는 줄구분을 하지 않습니다.
따라서 배열 등은 여러 줄에 걸쳐 사용할 수 있습니다.

#### **확장자**

나무는 `.namu`와 `.나무`를 사용하지만 현재는 아무 확장자로 해도 작동됩니다.
나중에 특정 확장자만 쓸 수 있게 할 계획이 있습니다.

#### **주석**

`#`(샵) 문자 뒤에 있는 코드는 주석으로 처리되어 실행되지 않습니다.
(단, 인터프리터에서 사용하시면 에러가 납니다.)

### 2. 값
현재 나무에서는 5가지의 값들을 지원합니다.

#### **수**
* 정수: `1`, `12`, `2021`
* 실수: `0.1`, `3.14`, `10.22`

#### **문자열**
* 따옴표나 쌍따옴표로 둘러싸여 있는 값은 문자열로 해석됩니다.
  * `'안녕, 세상!'`, `"한글 프로그래밍 언어 나무"`

#### **논리형**
* 아직 논리형은 구현이 안되있고 `1`과 `0`이 대신하고 있습니다.
* `참`과 `거짓` 내장 변수가 있는데, `참`은 `1`, `거짓`은 `0`을 반환합니다.
* 조건문 등에서 사용할 수 있습니다.

#### **없음**
* 내장 변수 `없음`은 JS에서 `undefined`와 `null`, 파이썬에서 `None`의 역할을 합니다.
* 내장 변수 `없음`은 0을 반환합니다.

#### **배열**
* 여러개의 값들을 하나로 묶은 값입니다. 대괄호쌍 안에 쉼표로 구별해 입력합니다.
  * `[1, "이", [3.1, "배열", 참]]`
* 배열 안의 값은 대괄호를 이용해 접근할 수 있습니다.
  * `[1, "2", "삼"][1]`은 배열의 2번째 원소인 `"2"`입니다.
  * 첫번째 원소의 인덱스는 `0`입니다.
  * 현재 배열의 원소의 내용을 바꾸는 기능(`배열[인덱스] = 값`)은 아직 구현되지 않았습니다.

#### **객체**
* 아직 구현되지 않았습니다.

### 3. 연산자
#### **산술 연산자**
* 숫자는 `+ - * / ^`로 사칙연산을 할 수 있습니다(^는 거듭제곱입니다.).
  * `28+42`, `10/2*10`, `2+2*2`
* 또 숫자는 `+ -`로 양수와 음수를 나타낼 수 있습니다.
  * `+29`, `-3`
* 문자열은 `+`로 문자열을 합치고, `*`로 문자열을 반복할 수 있습니다.
  * `"안녕, " + "세상!"`, `"그" * 4 + " 뭐더라"`
* 배열은 `+`로 항목을 추가하고, `-`로 항목을 뺄 수 있으며, `*`로 배열에 배열을 합칠 수 있습니다.
  * ```python
    배열 = [1, "이", "three"]
    배열 + "2+2" #[1, "이", "three", "2+2"]
    배열 - 2 #[1, "이", "2+2"]
    배열 * [5, "六"] #[1, "이", "2+2", 5, "六"]
    콘솔에_보여주기(배열) #[1, "이", "2+2", 5, "六"]
    ```
  
#### **비교 연산자**
* 값이 같은지는 `==`로, 값이 다른지는 `!=`로 확인합니다.
  * `10 * 10 == 100`, `"가나다" != "라마바"`
* 숫자는 `< > <= >=`로 비교할 수 있습니다.
  * `1 < 2`, `39 > 29`

#### **논리 연산자**
* AND 연산자 `&`는 왼쪽과 오른쪽 모두가 참(1)인 경우에만 1(참)로 처리합니다.
  * `참 & 참`, `10 == 10 & 38 < 73`
* OR 연산자 `|`은 왼쪽과 오른쪽 중 하나라도 참(1)이면 1(참)로 처리합니다.
  * `29>=29 | 87>3`, `"ㄷㄷ" == "ㄷㄷ" | 28 == 39`
* NOT 연산자 `!`는 1(참)이나 0(거짓)을 반대로 뒤집습니다.
  * `!거짓`, `!27 > 72`

#### **괄호**
* 괄호를 사용하면 계산 순서를 바꿀 수 있습니다.
  * `2 + 2 * 2`는 `6`, `(2 + 2) * 2`는 `8`
  * `-1 < 2 < 1`는 `0`(거짓), `-1 < (2 < 1)`는 `1`(참)
### 4. 변수
#### **변수 선언**
* 변수 선언은 `=`을 이용합니다.
  `변수명 = 값` 형식으로 선언하며, 값을 갱신할 때에도 같은 문법을 사용합니다.
* 변수 이름은 한글, 알파벳, 숫자, `_`(언더바), `$`(달러)를 사용할 수 있습니다.
  숫자는 변수의 첫 글자에 올 수 없으며, 변수명으로 내장 함수나 내장 변수의 이름을 사용할 수 없습니다.

#### **변수 불러오기**
* 변수는 `변수명`으로 불러옵니다.

#### **예시**
```python
올해 = 2021
콘솔에_보여주기(올해) #2021
```

#### **내장 변수**
* 내장 변수는 나무에서 기본으로 지원하는 변수로, 수정이 불가능합니다.
* 내장 변수 목록은 다음과 같습니다.

  |이름|값|
  |---|---|
  |`참`|`1`|
  |`거짓`|`0`|
  |`없음`|`0`|
  |`원주율`|`π(3.14159...)`
  
### 4. 제어문
#### **조건문**
* 나무에서 조건문을 쓸 때에는 `만약` 키워드를 사용합니다.
* 조건문 형식은 다음과 같습니다.
  ```python
  만약 조건1 라면/이라면
  	#조건1이 1(참)일 때 실행될 내용
  아니면서 조건2 라면/이라면
  	#조건1이 0(거짓)이면서 조건2가 1(참)일 때 실행될 내용
  아니면
  	#조건1과 조건2 모두 0(거짓)이면 실행될 내용
  끝
  ```
  `아니면서`와 `아니면`은 생략 가능하며, `라면`과 `이라면` 둘 다 사용 가능합니다.

#### **반복문**
* 나무에서 반복문을 쓸 때에는 `반복하기` 키워드를 사용합니다.
* 반복은 `반복 그만`으로 멈춥니다.
* 반복문 형식은 다음과 같습니다.
  ```python
  반복하기
  	#반복할 동안 실행될 내용
  	
  	만약 조건1 이라면
  		반복 그만
  	끝
  끝
  ```

### 5. 함수
#### **함수 선언하기**
* 나무에서는 `함수` 키워드로 함수를 선언합니다.
* 다음은 함수 선언 예시입니다.
  ```python
  함수 함수명(매개변수1, 매개변수2, ...)
  	#함수 내용
  	
  	리턴 리턴값
  끝
  ```
  매개변수는 생략 가능합니다.
  단, 괄호는 꼭 넣어야 합니다.

##### **리턴**
* 나무의 함수에서는 `리턴 리턴값`으로 리턴을 합니다.

#### **함수 불러오기**
* 함수는 `함수명(매개변수1, 매개변수2, ...)`로 불러오며, 매개변수는 생략 가능합니다.
  단, 괄호는 꼭 넣어야 하며 괄호를 넣지 않으면 `<함수 함수명>`이 반환됩니다.

#### **익명 함수**
* 나무에서 익명 함수를 선언할 때에도 일반 함수를 선언하는 것처럼 `함수` 키워드를 사용합니다.
* 다음은 익명 함수 선언 예시입니다.
  ```python
  함수명 = 함수(매개변수1, 매개변수2, ...)
  	#함수 내용

  	리턴 리턴값
  ```
  마찬가지로 매개 변수는 생략 가능하지만, 괄호는 꼭 넣어야 합니다.

#### **내장 함수**
* 내장 함수는 나무에서 기본으로 지원하는 함수로, 수정이 불가능합니다.
* 다음은 나무의 내장 함수 목록입니다.

  |이름|설명|
  |---|---|
  |`콘솔에_보여주기(내용)`|`내용`을 콘솔에 보여줍니다.|
  |`콘솔_지우기()`|콘솔의 모든 내용을 지웁니다.|
  |`숫자인가(값)`|`값`이 숫자면 `1`(참), 아니면 `0`(거짓)을 반환합니다.|
  |`문자열인가(값)`|`값`이 문자열이면 `1`(참), 아니면 `0`(거짓)을 반환합니다.|
  |`배열인가(값)`|`값`이 배열이면 `1`(참), 아니면 `0`(거짓)을 반환합니다.|
  |`함수인가(값)`|`값`이 함수면 `1`(참), 아니면 `0`(거짓)을 반환합니다.|
  |`기다리기(초)`|`초`의 값만큼 기다립니다.|
  |`문자열로(값)`|`값`을 문자열로 바꾼 것을 반환합니다.|
  |`실행하기(파일명)`|이름이 `파일명`인 파일을 컴파일하고 실행합니다.|