import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowCxEntityTypeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Represents kinds of entities.
     *
     * AUTO_EXPANSION_MODE_UNSPECIFIED: Auto expansion disabled for the entity.
     * AUTO_EXPANSION_MODE_DEFAULT: Allows an agent to recognize values that have not been explicitly listed in the entity. Possible values: ["AUTO_EXPANSION_MODE_DEFAULT", "AUTO_EXPANSION_MODE_UNSPECIFIED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#auto_expansion_mode DialogflowCxEntityType#auto_expansion_mode}
     *
     * @stability stable
     */
    readonly autoExpansionMode?: string;
    /**
     * The human-readable name of the entity type, unique within the agent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#display_name DialogflowCxEntityType#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Enables fuzzy entity extraction during classification.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#enable_fuzzy_extraction DialogflowCxEntityType#enable_fuzzy_extraction}
     *
     * @stability stable
     */
    readonly enableFuzzyExtraction?: boolean | cdktf.IResolvable;
    /**
     * Indicates whether the entity type can be automatically expanded.
     *
     * KIND_MAP: Map entity types allow mapping of a group of synonyms to a canonical value.
     * KIND_LIST: List entity types contain a set of entries that do not map to canonical values. However, list entity types can contain references to other entity types (with or without aliases).
     * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values. Possible values: ["KIND_MAP", "KIND_LIST", "KIND_REGEXP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#kind DialogflowCxEntityType#kind}
     *
     * @stability stable
     */
    readonly kind: string;
    /**
     * The language of the following fields in entityType: EntityType.entities.value EntityType.entities.synonyms EntityType.excluded_phrases.value If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#language_code DialogflowCxEntityType#language_code}
     *
     * @stability stable
     */
    readonly languageCode?: string;
    /**
     * The agent to create a entity type for.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#parent DialogflowCxEntityType#parent}
     *
     * @stability stable
     */
    readonly parent?: string;
    /**
     * Indicates whether parameters of the entity type should be redacted in log.
     *
     * If redaction is enabled, page parameters and intent parameters referring to the entity type will be replaced by parameter name when logging.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#redact DialogflowCxEntityType#redact}
     *
     * @stability stable
     */
    readonly redact?: boolean | cdktf.IResolvable;
    /**
     * entities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#entities DialogflowCxEntityType#entities}
     *
     * @stability stable
     */
    readonly entities: DialogflowCxEntityTypeEntities[];
    /**
     * excluded_phrases block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#excluded_phrases DialogflowCxEntityType#excluded_phrases}
     *
     * @stability stable
     */
    readonly excludedPhrases?: DialogflowCxEntityTypeExcludedPhrases[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#timeouts DialogflowCxEntityType#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowCxEntityTypeTimeouts;
}
/**
 * @stability stable
 */
export interface DialogflowCxEntityTypeEntities {
    /**
     * A collection of value synonyms.
     *
     * For example, if the entity type is vegetable, and value is scallions, a synonym could be green onions.
     * For KIND_LIST entity types: This collection must contain exactly one synonym equal to value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#synonyms DialogflowCxEntityType#synonyms}
     *
     * @stability stable
     */
    readonly synonyms?: string[];
    /**
     * The primary value associated with this entity entry.
     *
     * For example, if the entity type is vegetable, the value could be scallions.
     * For KIND_MAP entity types: A canonical value to be used in place of synonyms.
     * For KIND_LIST entity types: A string that can contain references to other entity types (with or without aliases).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#value DialogflowCxEntityType#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function dialogflowCxEntityTypeEntitiesToTerraform(struct?: DialogflowCxEntityTypeEntities): any;
/**
 * @stability stable
 */
export interface DialogflowCxEntityTypeExcludedPhrases {
    /**
     * The word or phrase to be excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#value DialogflowCxEntityType#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function dialogflowCxEntityTypeExcludedPhrasesToTerraform(struct?: DialogflowCxEntityTypeExcludedPhrases): any;
/**
 * @stability stable
 */
export interface DialogflowCxEntityTypeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#create DialogflowCxEntityType#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#delete DialogflowCxEntityType#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html#update DialogflowCxEntityType#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dialogflowCxEntityTypeTimeoutsToTerraform(struct?: DialogflowCxEntityTypeTimeoutsOutputReference | DialogflowCxEntityTypeTimeouts): any;
/**
 * @stability stable
 */
export declare class DialogflowCxEntityTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxEntityTypeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxEntityTypeTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html google_dialogflow_cx_entity_type}.
 *
 * @stability stable
 */
export declare class DialogflowCxEntityType extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_entity_type.html google_dialogflow_cx_entity_type} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowCxEntityTypeConfig);
    private _autoExpansionMode?;
    /**
     * @stability stable
     */
    get autoExpansionMode(): string;
    /**
     * @stability stable
     */
    set autoExpansionMode(value: string);
    /**
     * @stability stable
     */
    resetAutoExpansionMode(): void;
    /**
     * @stability stable
     */
    get autoExpansionModeInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enableFuzzyExtraction?;
    /**
     * @stability stable
     */
    get enableFuzzyExtraction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableFuzzyExtraction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableFuzzyExtraction(): void;
    /**
     * @stability stable
     */
    get enableFuzzyExtractionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kind?;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    get kindInput(): string | undefined;
    private _languageCode?;
    /**
     * @stability stable
     */
    get languageCode(): string;
    /**
     * @stability stable
     */
    set languageCode(value: string);
    /**
     * @stability stable
     */
    resetLanguageCode(): void;
    /**
     * @stability stable
     */
    get languageCodeInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    resetParent(): void;
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _redact?;
    /**
     * @stability stable
     */
    get redact(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set redact(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRedact(): void;
    /**
     * @stability stable
     */
    get redactInput(): boolean | cdktf.IResolvable | undefined;
    private _entities?;
    /**
     * @stability stable
     */
    get entities(): DialogflowCxEntityTypeEntities[];
    /**
     * @stability stable
     */
    set entities(value: DialogflowCxEntityTypeEntities[]);
    /**
     * @stability stable
     */
    get entitiesInput(): DialogflowCxEntityTypeEntities[] | undefined;
    private _excludedPhrases?;
    /**
     * @stability stable
     */
    get excludedPhrases(): DialogflowCxEntityTypeExcludedPhrases[];
    /**
     * @stability stable
     */
    set excludedPhrases(value: DialogflowCxEntityTypeExcludedPhrases[]);
    /**
     * @stability stable
     */
    resetExcludedPhrases(): void;
    /**
     * @stability stable
     */
    get excludedPhrasesInput(): DialogflowCxEntityTypeExcludedPhrases[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowCxEntityTypeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DialogflowCxEntityTypeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowCxEntityTypeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
