# Kallisti Core

![Build Status](https://github.com/jpmorganchase/kallisti-core/actions/workflows/build.yml/badge.svg)

This is a library for the chaos engineering framework
[Kallisti](https://github.com/jpmorganchase/kallisti), providing its core
functionality of the managed chaos experiments as Kallisti API.

Please refer to the documentation of
[Kallisti](https://github.com/jpmorganchase/kallisti) for the project details as
well as its concepts and the road map.

### Install

```shell
pip install kallisti-core
```

### Contribution Guide

##### Reporting bugs, feature requests, etc.
 
To report bugs, request new features or similar, please open an issue on the
Github repository.

A good bug report includes:

* Expected behavior
* Actual behavior
* Steps to reproduce
* Any output from console 

##### Submitting changes

* Open a new GitHub pull request with the changes.
* Ensure the PR description clearly describes the problem and solution. Include
  the relevant issue number if applicable.
* [Pull Contributor License Agreement (CLA)](https://github.com/jpmorganchase/cla)
  will be required upon PR before we are able to merge.

If you have any questions about the contribution process, please feel free to
send an email to open_source@jpmorgan.com.
 
