# Copyright (c) 2021 Emanuele Bellocchia
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

#
# Imports
#
import pyrogram
from telegram_periodic_msg_bot.config import ConfigTypes, Config


#
# Classes
#

# Invalid message error
class PeriodicMsgParserInvalidError(Exception):
    pass


# Too long message error
class PeriodicMsgParserTooLongError(Exception):
    pass


# Periodic message parser class
class PeriodicMsgParser:

    config: Config

    # Constructor
    def __init__(self,
                 config: Config) -> None:
        self.config = config

    # Parse message
    def Parse(self,
              message: pyrogram.types.Message) -> str:
        try:
            # The message shall start on a new line
            msg = message.text[message.text.index("\n"):].strip()

            # Check message
            if msg == "":
                raise PeriodicMsgParserInvalidError()
            if len(msg) > self.config.GetValue(ConfigTypes.MESSAGE_MAX_LEN):
                raise PeriodicMsgParserTooLongError()

            return msg

        except ValueError as ex:
            raise PeriodicMsgParserInvalidError() from ex
