# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.awt
from enum import Enum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class FontWeight(metaclass=UnoConstMeta, type_name="com.sun.star.awt.FontWeight", name_space="com.sun.star.awt"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.awt.FontWeight``"""
        pass

    class FontWeightEnum(Enum, metaclass=ConstEnumMeta, type_name="com.sun.star.awt.FontWeight", name_space="com.sun.star.awt"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.awt.FontWeight`` as Enum values"""
        pass

else:
    from ...lo.awt.font_weight import FontWeight as FontWeight

    class FontWeightEnum(Enum):
        """
        Enum of Const Class FontWeight

        These values are used to specify whether a font is thin or bold.
        
        They may be expanded in future versions.
        """
        DONTKNOW = FontWeight.DONTKNOW
        """
        The font weight is not specified/known.
        """
        THIN = FontWeight.THIN
        """
        specifies a 50% font weight.
        """
        ULTRALIGHT = FontWeight.ULTRALIGHT
        """
        specifies a 60% font weight.
        """
        LIGHT = FontWeight.LIGHT
        """
        specifies a 75% font weight.
        """
        SEMILIGHT = FontWeight.SEMILIGHT
        """
        specifies a 90% font weight.
        """
        NORMAL = FontWeight.NORMAL
        """
        specifies a normal font weight.
        """
        SEMIBOLD = FontWeight.SEMIBOLD
        """
        specifies a 110% font weight.
        """
        BOLD = FontWeight.BOLD
        """
        specifies a 150% font weight.
        """
        ULTRABOLD = FontWeight.ULTRABOLD
        """
        specifies a 175% font weight.
        """
        BLACK = FontWeight.BLACK
        """
        specifies a 200% font weight.
        """

__all__ = ['FontWeight', 'FontWeightEnum']
