# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.embed
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class EntryInitModes(metaclass=UnoConstMeta, type_name="com.sun.star.embed.EntryInitModes", name_space="com.sun.star.embed"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.embed.EntryInitModes``"""
        pass

    class EntryInitModesEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.embed.EntryInitModes", name_space="com.sun.star.embed"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.embed.EntryInitModes`` as Enum values"""
        pass

else:
    from ...lo.embed.entry_init_modes import EntryInitModes as EntryInitModes

    class EntryInitModesEnum(IntEnum):
        """
        Enum of Const Class EntryInitModes

        This constant set contains possible modes to initialize object persistence.
        """
        DEFAULT_INIT = EntryInitModes.DEFAULT_INIT
        """
        In case object persistence is created based on existing entry, the object should be initialized from this entry.
        
        Otherwise the object should be initialized as a new one.
        """
        TRUNCATE_INIT = EntryInitModes.TRUNCATE_INIT
        """
        The object should be initialized as a new empty one.
        """
        NO_INIT = EntryInitModes.NO_INIT
        """
        The object should be initialized as a new one only in case it still was not initialized.
        
        If the object initialized already do not reinitialize it.
        """
        MEDIA_DESCRIPTOR_INIT = EntryInitModes.MEDIA_DESCRIPTOR_INIT
        """
        The object should be initialized using additional arguments from provided com.sun.star.document.MediaDescriptor.
        """
        URL_LINK_INIT = EntryInitModes.URL_LINK_INIT
        """
        The object should be initialized as a link using URL provided in additional arguments.
        """

__all__ = ['EntryInitModes', 'EntryInitModesEnum']
