# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.frame
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class InfobarType(metaclass=UnoConstMeta, type_name="com.sun.star.frame.InfobarType", name_space="com.sun.star.frame"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.frame.InfobarType``"""
        pass

    class InfobarTypeEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.frame.InfobarType", name_space="com.sun.star.frame"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.frame.InfobarType`` as Enum values"""
        pass

else:
    from ...lo.frame.infobar_type import InfobarType as InfobarType

    class InfobarTypeEnum(IntEnum):
        """
        Enum of Const Class InfobarType

        Infobar types.
        
        **since**
        
            LibreOffice 6.4
        """
        INFO = InfobarType.INFO
        """
        For information messages (color: light blue).
        """
        SUCCESS = InfobarType.SUCCESS
        """
        For success notifications (color: light green).
        """
        WARNING = InfobarType.WARNING
        """
        For warning messages (color: orange).
        """
        DANGER = InfobarType.DANGER
        """
        For critical errors (color: red).
        """

__all__ = ['InfobarType', 'InfobarTypeEnum']
