# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.i18n
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class CTLScriptType(metaclass=UnoConstMeta, type_name="com.sun.star.i18n.CTLScriptType", name_space="com.sun.star.i18n"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.i18n.CTLScriptType``"""
        pass

    class CTLScriptTypeEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.i18n.CTLScriptType", name_space="com.sun.star.i18n"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.i18n.CTLScriptType`` as Enum values"""
        pass

else:
    from ...lo.i18n.ctl_script_type import CTLScriptType as CTLScriptType

    class CTLScriptTypeEnum(IntEnum):
        """
        Enum of Const Class CTLScriptType

        CTL script type constants for layout engine, returned by XScriptTypeDetector.getCTLScriptType()
        
        **since**
        
            OOo 1.1.2
        """
        CTL_UNKNOWN = CTLScriptType.CTL_UNKNOWN
        """
        For CTL scripts OOo currently does not support or could not handle.
        """
        CTL_HEBREW = CTLScriptType.CTL_HEBREW
        """
        For Hebrew script.
        """
        CTL_ARABIC = CTLScriptType.CTL_ARABIC
        """
        For Arabic script.
        """
        CTL_THAI = CTLScriptType.CTL_THAI
        """
        For Thai script.
        """
        CTL_INDIC = CTLScriptType.CTL_INDIC
        """
        For Indic script (including Devanagari, Tamil, Telugu and Gujarati script)
        """

__all__ = ['CTLScriptType', 'CTLScriptTypeEnum']
