# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.i18n
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class TextConversionOption(metaclass=UnoConstMeta, type_name="com.sun.star.i18n.TextConversionOption", name_space="com.sun.star.i18n"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.i18n.TextConversionOption``"""
        pass

    class TextConversionOptionEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.i18n.TextConversionOption", name_space="com.sun.star.i18n"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.i18n.TextConversionOption`` as Enum values"""
        pass

else:
    from ...lo.i18n.text_conversion_option import TextConversionOption as TextConversionOption

    class TextConversionOptionEnum(IntEnum):
        """
        Enum of Const Class TextConversionOption

        Text conversion options to be used with XTextConversion.
        
        These text conversion options are usually selected by end users. The options can be combined and may be related to TextConversionType.
        
        **since**
        
            OOo 1.1.2
        """
        NONE = TextConversionOption.NONE
        """
        No option.
        """
        CHARACTER_BY_CHARACTER = TextConversionOption.CHARACTER_BY_CHARACTER
        """
        Character by character conversion.
        """
        IGNORE_POST_POSITIONAL_WORD = TextConversionOption.IGNORE_POST_POSITIONAL_WORD
        """
        Ignore post-positional word for Hangul to Hanja conversion.
        """
        USE_CHARACTER_VARIANTS = TextConversionOption.USE_CHARACTER_VARIANTS
        """
        Use Taiwan, HongKong SAR, and Macao SAR character variants for Simplified to Traditional Chinese conversion.
        
        **since**
        
            OOo 2.0
        """

__all__ = ['TextConversionOption', 'TextConversionOptionEnum']
