# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.i18n
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class TransliterationModulesExtra(metaclass=UnoConstMeta, type_name="com.sun.star.i18n.TransliterationModulesExtra", name_space="com.sun.star.i18n"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.i18n.TransliterationModulesExtra``"""
        pass

    class TransliterationModulesExtraEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.i18n.TransliterationModulesExtra", name_space="com.sun.star.i18n"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.i18n.TransliterationModulesExtra`` as Enum values"""
        pass

else:
    from ...lo.i18n.transliteration_modules_extra import TransliterationModulesExtra as TransliterationModulesExtra

    class TransliterationModulesExtraEnum(IntEnum):
        """
        Enum of Const Class TransliterationModulesExtra

        Extra transliteration module enumeration to use with XTransliteration.loadModule()
        
        The values used in this group need to be different from the ones in TransliterationModules and TransliterationModulesNew!
        """
        SENTENCE_CASE = TransliterationModulesExtra.SENTENCE_CASE
        """
        The first character of the sentence is put in upper case.
        """
        TITLE_CASE = TransliterationModulesExtra.TITLE_CASE
        """
        The first character of the word is put in upper case.
        
        This one is part
        """
        TOGGLE_CASE = TransliterationModulesExtra.TOGGLE_CASE
        """
        All characters of the word are to change their case from small letters to capital letters and vice versa.
        """
        IGNORE_DIACRITICS_CTL = TransliterationModulesExtra.IGNORE_DIACRITICS_CTL
        """
        Ignore diacritics.
        
        Despite the _CTL name suffix this is not only about CTL/Arabic diacritic characters, though these are handled as well, but the transliteration decomposes and removes any diacritic from characters.
        
        Because we cannot extend the TransliterationModules enum we use TransliterationModulesExtra and it will act the same way.
        """
        IGNORE_KASHIDA_CTL = TransliterationModulesExtra.IGNORE_KASHIDA_CTL
        """
        Ignore Kashida mark.
        """
        END_OF_MODULE = TransliterationModulesExtra.END_OF_MODULE

__all__ = ['TransliterationModulesExtra', 'TransliterationModulesExtraEnum']
