# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.linguistic2
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class SpellFailure(metaclass=UnoConstMeta, type_name="com.sun.star.linguistic2.SpellFailure", name_space="com.sun.star.linguistic2"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.linguistic2.SpellFailure``"""
        pass

    class SpellFailureEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.linguistic2.SpellFailure", name_space="com.sun.star.linguistic2"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.linguistic2.SpellFailure`` as Enum values"""
        pass

else:
    from ...lo.linguistic2.spell_failure import SpellFailure as SpellFailure

    class SpellFailureEnum(IntEnum):
        """
        Enum of Const Class SpellFailure

        these define the various return types for spell checking to fail verification.
        
        A value of this type is part of the com.sun.star.linguistic2.XSpellAlternatives interface which is the return type for an unsuccessful spelling attempt.
        """
        IS_NEGATIVE_WORD = SpellFailure.IS_NEGATIVE_WORD
        """
        The word is a negative one, that is, it should not be used.
        """
        CAPTION_ERROR = SpellFailure.CAPTION_ERROR
        """
        The capitalization of the word is wrong.
        """
        SPELLING_ERROR = SpellFailure.SPELLING_ERROR
        """
        The spelling of the word is wrong (or at least not known to be correct).
        """

__all__ = ['SpellFailure', 'SpellFailureEnum']
