# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.rdf
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class URIs(metaclass=UnoConstMeta, type_name="com.sun.star.rdf.URIs", name_space="com.sun.star.rdf"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.rdf.URIs``"""
        pass

    class URIsEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.rdf.URIs", name_space="com.sun.star.rdf"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.rdf.URIs`` as Enum values"""
        pass

else:
    from ...lo.rdf.ur_is import URIs as URIs

    class URIsEnum(IntEnum):
        """
        Enum of Const Class URIs

        Constants to specify some well-known URIs.
        
        These constants are for use with URI.createKnown().
        
        **since**
        
            OOo 3.2
        """
        XSD_NCNAME = URIs.XSD_NCNAME
        """
        http://www.w3.org/2001/XMLSchema-datatypes#NCName
        """
        XSD_STRING = URIs.XSD_STRING
        """
        http://www.w3.org/2001/XMLSchema-datatypes#string
        """
        XSD_NORMALIZEDSTRING = URIs.XSD_NORMALIZEDSTRING
        """
        http://www.w3.org/2001/XMLSchema-datatypes#normalizedString
        """
        XSD_BOOLEAN = URIs.XSD_BOOLEAN
        """
        http://www.w3.org/2001/XMLSchema-datatypes#boolean
        """
        XSD_DECIMAL = URIs.XSD_DECIMAL
        """
        http://www.w3.org/2001/XMLSchema-datatypes#decimal
        """
        XSD_FLOAT = URIs.XSD_FLOAT
        """
        http://www.w3.org/2001/XMLSchema-datatypes#float
        """
        XSD_DOUBLE = URIs.XSD_DOUBLE
        """
        http://www.w3.org/2001/XMLSchema-datatypes#double
        """
        XSD_INTEGER = URIs.XSD_INTEGER
        """
        http://www.w3.org/2001/XMLSchema-datatypes#integer
        """
        XSD_NONNEGATIVEINTEGER = URIs.XSD_NONNEGATIVEINTEGER
        """
        http://www.w3.org/2001/XMLSchema-datatypes#nonNegativeInteger
        """
        XSD_POSITIVEINTEGER = URIs.XSD_POSITIVEINTEGER
        """
        http://www.w3.org/2001/XMLSchema-datatypes#positiveInteger
        """
        XSD_NONPOSITIVEINTEGER = URIs.XSD_NONPOSITIVEINTEGER
        """
        http://www.w3.org/2001/XMLSchema-datatypes#nonPositiveInteger
        """
        XSD_NEGATIVEINTEGER = URIs.XSD_NEGATIVEINTEGER
        """
        http://www.w3.org/2001/XMLSchema-datatypes#negativeInteger
        """
        XSD_LONG = URIs.XSD_LONG
        """
        http://www.w3.org/2001/XMLSchema-datatypes#long
        """
        XSD_INT = URIs.XSD_INT
        """
        http://www.w3.org/2001/XMLSchema-datatypes#int
        """
        XSD_SHORT = URIs.XSD_SHORT
        """
        http://www.w3.org/2001/XMLSchema-datatypes#short
        """
        XSD_BYTE = URIs.XSD_BYTE
        """
        http://www.w3.org/2001/XMLSchema-datatypes#byte
        """
        XSD_UNSIGNEDLONG = URIs.XSD_UNSIGNEDLONG
        """
        http://www.w3.org/2001/XMLSchema-datatypes#unsignedLong
        """
        XSD_UNSIGNEDINT = URIs.XSD_UNSIGNEDINT
        """
        http://www.w3.org/2001/XMLSchema-datatypes#unsignedInt
        """
        XSD_UNSIGNEDSHORT = URIs.XSD_UNSIGNEDSHORT
        """
        http://www.w3.org/2001/XMLSchema-datatypes#unsignedShort
        """
        XSD_UNSIGNEDBYTE = URIs.XSD_UNSIGNEDBYTE
        """
        http://www.w3.org/2001/XMLSchema-datatypes#unsignedByte
        """
        XSD_HEXBINARY = URIs.XSD_HEXBINARY
        """
        http://www.w3.org/2001/XMLSchema-datatypes#hexBinary
        """
        XSD_BASE64BINARY = URIs.XSD_BASE64BINARY
        """
        http://www.w3.org/2001/XMLSchema-datatypes#base64Binary
        """
        XSD_DATETIME = URIs.XSD_DATETIME
        """
        http://www.w3.org/2001/XMLSchema-datatypes#dateTime
        """
        XSD_TIME = URIs.XSD_TIME
        """
        http://www.w3.org/2001/XMLSchema-datatypes#time
        """
        XSD_DATE = URIs.XSD_DATE
        """
        http://www.w3.org/2001/XMLSchema-datatypes#date
        """
        XSD_GYEARMONTH = URIs.XSD_GYEARMONTH
        """
        http://www.w3.org/2001/XMLSchema-datatypes#gYearMonth
        """
        XSD_GYEAR = URIs.XSD_GYEAR
        """
        http://www.w3.org/2001/XMLSchema-datatypes#gYear
        """
        XSD_GMONTHDAY = URIs.XSD_GMONTHDAY
        """
        http://www.w3.org/2001/XMLSchema-datatypes#gMonthDay
        """
        XSD_GDAY = URIs.XSD_GDAY
        """
        http://www.w3.org/2001/XMLSchema-datatypes#gDay
        """
        XSD_GMONTH = URIs.XSD_GMONTH
        """
        http://www.w3.org/2001/XMLSchema-datatypes#gMonth
        """
        XSD_ANYURI = URIs.XSD_ANYURI
        """
        http://www.w3.org/2001/XMLSchema-datatypes#anyURI
        """
        XSD_TOKEN = URIs.XSD_TOKEN
        """
        http://www.w3.org/2001/XMLSchema-datatypes#token
        """
        XSD_LANGUAGE = URIs.XSD_LANGUAGE
        """
        http://www.w3.org/2001/XMLSchema-datatypes#language
        """
        XSD_NMTOKEN = URIs.XSD_NMTOKEN
        """
        http://www.w3.org/2001/XMLSchema-datatypes#NMTOKEN
        """
        XSD_NAME = URIs.XSD_NAME
        """
        http://www.w3.org/2001/XMLSchema-datatypes#Name
        """
        XSD_DURATION = URIs.XSD_DURATION
        """
        http://www.w3.org/2001/XMLSchema-datatypes#duration
        """
        XSD_QNAME = URIs.XSD_QNAME
        """
        http://www.w3.org/2001/XMLSchema-datatypes#QName
        """
        XSD_NOTATION = URIs.XSD_NOTATION
        """
        http://www.w3.org/2001/XMLSchema-datatypes#NOTATION
        """
        XSD_NMTOKENS = URIs.XSD_NMTOKENS
        """
        http://www.w3.org/2001/XMLSchema-datatypes#NMTOKENS
        """
        XSD_ID = URIs.XSD_ID
        """
        http://www.w3.org/2001/XMLSchema-datatypes#ID
        """
        XSD_IDREF = URIs.XSD_IDREF
        """
        http://www.w3.org/2001/XMLSchema-datatypes#IDREF
        """
        XSD_IDREFS = URIs.XSD_IDREFS
        """
        http://www.w3.org/2001/XMLSchema-datatypes#IDREFS
        """
        XSD_ENTITY = URIs.XSD_ENTITY
        """
        http://www.w3.org/2001/XMLSchema-datatypes#ENTITY
        """
        XSD_ENTITIES = URIs.XSD_ENTITIES
        """
        http://www.w3.org/2001/XMLSchema-datatypes#ENTITIES
        """
        RDF_TYPE = URIs.RDF_TYPE
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#type
        """
        RDF_SUBJECT = URIs.RDF_SUBJECT
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#subject
        """
        RDF_PREDICATE = URIs.RDF_PREDICATE
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate
        """
        RDF_OBJECT = URIs.RDF_OBJECT
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#object
        """
        RDF_PROPERTY = URIs.RDF_PROPERTY
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#Property
        """
        RDF_STATEMENT = URIs.RDF_STATEMENT
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement
        """
        RDF_VALUE = URIs.RDF_VALUE
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#value
        """
        RDF_FIRST = URIs.RDF_FIRST
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#first
        """
        RDF_REST = URIs.RDF_REST
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#rest
        """
        RDF_NIL = URIs.RDF_NIL
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#nil
        """
        RDF_XMLLITERAL = URIs.RDF_XMLLITERAL
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral
        """
        RDF_ALT = URIs.RDF_ALT
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt
        """
        RDF_BAG = URIs.RDF_BAG
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag
        """
        RDF_LIST = URIs.RDF_LIST
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#List
        """
        RDF_SEQ = URIs.RDF_SEQ
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq
        """
        RDF_1 = URIs.RDF_1
        """
        http://www.w3.org/1999/02/22-rdf-syntax-ns#_1
        """
        RDFS_COMMENT = URIs.RDFS_COMMENT
        """
        http://www.w3.org/2000/01/rdf-schema#comment
        """
        RDFS_LABEL = URIs.RDFS_LABEL
        """
        http://www.w3.org/2000/01/rdf-schema#label
        """
        RDFS_DOMAIN = URIs.RDFS_DOMAIN
        """
        http://www.w3.org/2000/01/rdf-schema#domain
        """
        RDFS_RANGE = URIs.RDFS_RANGE
        """
        http://www.w3.org/2000/01/rdf-schema#range
        """
        RDFS_SUBCLASSOF = URIs.RDFS_SUBCLASSOF
        """
        http://www.w3.org/2000/01/rdf-schema#subClassOf
        """
        RDFS_LITERAL = URIs.RDFS_LITERAL
        """
        http://www.w3.org/2000/01/rdf-schema#Literal
        """
        RDFS_MEMBER = URIs.RDFS_MEMBER
        """
        http://www.w3.org/2000/01/rdf-schema#member
        """
        RDFS_SUBPROPERTYOF = URIs.RDFS_SUBPROPERTYOF
        """
        http://www.w3.org/2000/01/rdf-schema#subPropertyOf
        """
        RDFS_ISDEFINEDBY = URIs.RDFS_ISDEFINEDBY
        """
        http://www.w3.org/2000/01/rdf-schema#isDefinedBy
        """
        RDFS_SEEALSO = URIs.RDFS_SEEALSO
        """
        http://www.w3.org/2000/01/rdf-schema#seeAlso
        """
        RDFS_RESOURCE = URIs.RDFS_RESOURCE
        """
        http://www.w3.org/2000/01/rdf-schema#Resource
        """
        RDFS_CLASS = URIs.RDFS_CLASS
        """
        http://www.w3.org/2000/01/rdf-schema#Class
        """
        RDFS_DATATYPE = URIs.RDFS_DATATYPE
        """
        http://www.w3.org/2000/01/rdf-schema#Datatype
        """
        RDFS_CONTAINER = URIs.RDFS_CONTAINER
        """
        http://www.w3.org/2000/01/rdf-schema#Container
        """
        RDFS_CONTAINERMEMBERSHIPPROPERTY = URIs.RDFS_CONTAINERMEMBERSHIPPROPERTY
        """
        http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty
        """
        OWL_CLASS = URIs.OWL_CLASS
        """
        http://www.w3.org/2002/07/owl#Class
        """
        OWL_OBJECTPROPERTY = URIs.OWL_OBJECTPROPERTY
        """
        http://www.w3.org/2002/07/owl#ObjectProperty
        """
        OWL_DATATYPEPROPERTY = URIs.OWL_DATATYPEPROPERTY
        """
        http://www.w3.org/2002/07/owl#DatatypeProperty
        """
        OWL_FUNCTIONALPROPERTY = URIs.OWL_FUNCTIONALPROPERTY
        """
        http://www.w3.org/2002/07/owl#FunctionalProperty
        """
        OWL_THING = URIs.OWL_THING
        """
        http://www.w3.org/2002/07/owl#Thing
        """
        OWL_NOTHING = URIs.OWL_NOTHING
        """
        http://www.w3.org/2002/07/owl#Nothing
        """
        OWL_INDIVIDUAL = URIs.OWL_INDIVIDUAL
        """
        http://www.w3.org/2002/07/owl#Individual
        """
        OWL_EQUIVALENTCLASS = URIs.OWL_EQUIVALENTCLASS
        """
        http://www.w3.org/2002/07/owl#equivalentClass
        """
        OWL_EQUIVALENTPROPERTY = URIs.OWL_EQUIVALENTPROPERTY
        """
        http://www.w3.org/2002/07/owl#equivalentProperty
        """
        OWL_SAMEAS = URIs.OWL_SAMEAS
        """
        http://www.w3.org/2002/07/owl#sameAs
        """
        OWL_DIFFERENTFROM = URIs.OWL_DIFFERENTFROM
        """
        http://www.w3.org/2002/07/owl#differentFrom
        """
        OWL_ALLDIFFERENT = URIs.OWL_ALLDIFFERENT
        """
        http://www.w3.org/2002/07/owl#AllDifferent
        """
        OWL_DISTINCTMEMBERS = URIs.OWL_DISTINCTMEMBERS
        """
        http://www.w3.org/2002/07/owl#distinctMembers
        """
        OWL_INVERSEOF = URIs.OWL_INVERSEOF
        """
        http://www.w3.org/2002/07/owl#inverseOf
        """
        OWL_TRANSITIVEPROPERTY = URIs.OWL_TRANSITIVEPROPERTY
        """
        http://www.w3.org/2002/07/owl#TransitiveProperty
        """
        OWL_SYMMETRICPROPERTY = URIs.OWL_SYMMETRICPROPERTY
        """
        http://www.w3.org/2002/07/owl#SymmetricProperty
        """
        OWL_INVERSEFUNCTIONALPROPERTY = URIs.OWL_INVERSEFUNCTIONALPROPERTY
        """
        http://www.w3.org/2002/07/owl#InverseFunctionalProperty
        """
        OWL_RESTRICTION = URIs.OWL_RESTRICTION
        """
        http://www.w3.org/2002/07/owl#Restriction
        """
        OWL_ONPROPERTY = URIs.OWL_ONPROPERTY
        """
        http://www.w3.org/2002/07/owl#onProperty
        """
        OWL_ALLVALUESFROM = URIs.OWL_ALLVALUESFROM
        """
        http://www.w3.org/2002/07/owl#allValuesFrom
        """
        OWL_SOMEVALUESFROM = URIs.OWL_SOMEVALUESFROM
        """
        http://www.w3.org/2002/07/owl#someValuesFrom
        """
        OWL_MINCARDINALITY = URIs.OWL_MINCARDINALITY
        """
        http://www.w3.org/2002/07/owl#minCardinality
        """
        OWL_MAXCARDINALITY = URIs.OWL_MAXCARDINALITY
        """
        http://www.w3.org/2002/07/owl#maxCardinality
        """
        OWL_CARDINALITY = URIs.OWL_CARDINALITY
        """
        http://www.w3.org/2002/07/owl#cardinality
        """
        OWL_ONTOLOGY = URIs.OWL_ONTOLOGY
        """
        http://www.w3.org/2002/07/owl#Ontology
        """
        OWL_IMPORTS = URIs.OWL_IMPORTS
        """
        http://www.w3.org/2002/07/owl#imports
        """
        OWL_VERSIONINFO = URIs.OWL_VERSIONINFO
        """
        http://www.w3.org/2002/07/owl#versionInfo
        """
        OWL_PRIORVERSION = URIs.OWL_PRIORVERSION
        """
        http://www.w3.org/2002/07/owl#priorVersion
        """
        OWL_BACKWARDCOMPATIBLEWITH = URIs.OWL_BACKWARDCOMPATIBLEWITH
        """
        http://www.w3.org/2002/07/owl#backwardCompatibleWith
        """
        OWL_INCOMPATIBLEWITH = URIs.OWL_INCOMPATIBLEWITH
        """
        http://www.w3.org/2002/07/owl#incompatibleWith
        """
        OWL_DEPRECATEDCLASS = URIs.OWL_DEPRECATEDCLASS
        """
        http://www.w3.org/2002/07/owl#DeprecatedClass
        """
        OWL_DEPRECATEDPROPERTY = URIs.OWL_DEPRECATEDPROPERTY
        """
        http://www.w3.org/2002/07/owl#DeprecatedProperty
        """
        OWL_ANNOTATIONPROPERTY = URIs.OWL_ANNOTATIONPROPERTY
        """
        http://www.w3.org/2002/07/owl#AnnotationProperty
        """
        OWL_ONTOLOGYPROPERTY = URIs.OWL_ONTOLOGYPROPERTY
        """
        http://www.w3.org/2002/07/owl#OntologyProperty
        """
        OWL_ONEOF = URIs.OWL_ONEOF
        """
        http://www.w3.org/2002/07/owl#oneOf
        """
        OWL_DATARANGE = URIs.OWL_DATARANGE
        """
        http://www.w3.org/2002/07/owl#dataRange
        """
        OWL_DISJOINTWITH = URIs.OWL_DISJOINTWITH
        """
        http://www.w3.org/2002/07/owl#disjointWith
        """
        OWL_UNIONOF = URIs.OWL_UNIONOF
        """
        http://www.w3.org/2002/07/owl#unionOf
        """
        OWL_COMPLEMENTOF = URIs.OWL_COMPLEMENTOF
        """
        http://www.w3.org/2002/07/owl#complementOf
        """
        OWL_INTERSECTIONOF = URIs.OWL_INTERSECTIONOF
        """
        http://www.w3.org/2002/07/owl#intersectionOf
        """
        OWL_HASVALUE = URIs.OWL_HASVALUE
        """
        http://www.w3.org/2002/07/owl#hasValue
        """
        PKG_HASPART = URIs.PKG_HASPART
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/pkg#hasPart
        """
        PKG_MIMETYPE = URIs.PKG_MIMETYPE
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/pkg#mimeType
        """
        PKG_PACKAGE = URIs.PKG_PACKAGE
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/pkg#Package
        """
        PKG_ELEMENT = URIs.PKG_ELEMENT
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/pkg#Element
        """
        PKG_FILE = URIs.PKG_FILE
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/pkg#File
        """
        PKG_METADATAFILE = URIs.PKG_METADATAFILE
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/pkg#MetadataFile
        """
        PKG_DOCUMENT = URIs.PKG_DOCUMENT
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/pkg#Document
        """
        ODF_PREFIX = URIs.ODF_PREFIX
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/odf#prefix
        """
        ODF_SUFFIX = URIs.ODF_SUFFIX
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/odf#suffix
        """
        ODF_ELEMENT = URIs.ODF_ELEMENT
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/odf#Element
        """
        ODF_CONTENTFILE = URIs.ODF_CONTENTFILE
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/odf#ContentFile
        """
        ODF_STYLESFILE = URIs.ODF_STYLESFILE
        """
        http://docs.oasis-open.org/ns/office/1.2/meta/odf#StylesFile
        """
        LO_EXT_SHADING = URIs.LO_EXT_SHADING
        """
        custom shading color of an annotated text range or metadata field (replacement of the default field shading color)
        
        urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0odf#shading
        
        **since**
        
            LibreOffice 7.2
        """

__all__ = ['URIs', 'URIsEnum']
