# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.rendering
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class PathJoinType(metaclass=UnoConstMeta, type_name="com.sun.star.rendering.PathJoinType", name_space="com.sun.star.rendering"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.rendering.PathJoinType``"""
        pass

    class PathJoinTypeEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.rendering.PathJoinType", name_space="com.sun.star.rendering"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.rendering.PathJoinType`` as Enum values"""
        pass

else:
    from ...lo.rendering.path_join_type import PathJoinType as PathJoinType

    class PathJoinTypeEnum(IntEnum):
        """
        Enum of Const Class PathJoinType

        Determines which shape to use when joining path segments.
        
        The joins between different paths segments can be formed out of several different shapes (which are of course only visible for strokes wider than one device pixel).
        
        **since**
        
            OOo 2.0
        """
        NONE = PathJoinType.NONE
        """
        Do not join the path segments at all.
        
        This join type might lead, depending on the angle between the segments, to visible cracks at the meeting points.
        """
        MITER = PathJoinType.MITER
        """
        Join the path segment by extending the outer border until they intersect.
        """
        ROUND = PathJoinType.ROUND
        """
        Join the path segment with a pie-like patch, such that the outer line of the meeting point is round.
        """
        BEVEL = PathJoinType.BEVEL
        """
        Join the path segment by connecting the outer ends of the abutting segments with a straight line.
        """

__all__ = ['PathJoinType', 'PathJoinTypeEnum']
