# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.sdb.application
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class DatabaseObjectContainer(metaclass=UnoConstMeta, type_name="com.sun.star.sdb.application.DatabaseObjectContainer", name_space="com.sun.star.sdb.application"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.sdb.application.DatabaseObjectContainer``"""
        pass

    class DatabaseObjectContainerEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.sdb.application.DatabaseObjectContainer", name_space="com.sun.star.sdb.application"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.sdb.application.DatabaseObjectContainer`` as Enum values"""
        pass

else:
    from ....lo.sdb.application.database_object_container import DatabaseObjectContainer as DatabaseObjectContainer

    class DatabaseObjectContainerEnum(IntEnum):
        """
        Enum of Const Class DatabaseObjectContainer

        denotes different types of (maybe virtual) containers of database objects
        
        In the database application of OpenOffice.org, database objects (such as tables, queries, forms, reports) can be organized in folders. This hierarchy can be imposed externally, or internally.
        
        For example, when you connect to a database which supports catalogs and/or schemas, then those impose a natural order on the tables, in that a catalog or a schema is a folder of tables.
        
        On the other hand, for forms and reports, OpenOffice.org Base itself allows the user to create folders to organize the documents - in this case, the hierarchy is defined in the database document itself.
        
        **since**
        
            OOo 3.0
        """
        TABLES = DatabaseObjectContainer.TABLES
        """
        denotes the virtual folder containing all tables of a database, in a context where such a folder is displayed to the user.
        """
        QUERIES = DatabaseObjectContainer.QUERIES
        """
        denotes the virtual folder containing all queries of a database, in a context where such a folder is displayed to the user.
        """
        FORMS = DatabaseObjectContainer.FORMS
        """
        denotes the virtual folder containing all forms of a database document, in a context where such a folder is displayed to the user.
        """
        REPORTS = DatabaseObjectContainer.REPORTS
        """
        denotes the virtual folder containing all reports of a database, in a context where such a folder is displayed to the user.
        """
        DATA_SOURCE = DatabaseObjectContainer.DATA_SOURCE
        """
        denotes the data source itself, which effectively is the root container for all other kind of database objects, including other container types.
        """
        CATALOG = DatabaseObjectContainer.CATALOG
        """
        denotes a catalog in a database which supports catalogs
        """
        SCHEMA = DatabaseObjectContainer.SCHEMA
        """
        denotes a schema in a database which supports schemas
        """
        FORMS_FOLDER = DatabaseObjectContainer.FORMS_FOLDER
        """
        denotes a folder which is used to organize forms in a database document
        """
        REPORTS_FOLDER = DatabaseObjectContainer.REPORTS_FOLDER
        """
        denotes a folder which is used to organize reports in a database document
        """

__all__ = ['DatabaseObjectContainer', 'DatabaseObjectContainerEnum']
