# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.text
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class MailMergeType(metaclass=UnoConstMeta, type_name="com.sun.star.text.MailMergeType", name_space="com.sun.star.text"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.text.MailMergeType``"""
        pass

    class MailMergeTypeEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.text.MailMergeType", name_space="com.sun.star.text"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.text.MailMergeType`` as Enum values"""
        pass

else:
    from ...lo.text.mail_merge_type import MailMergeType as MailMergeType

    class MailMergeTypeEnum(IntEnum):
        """
        Enum of Const Class MailMergeType

        Defines the possible output types/devices for mail merge.
        
        **since**
        
            OOo 1.1.2
        """
        PRINTER = MailMergeType.PRINTER
        """
        The output device is a printer.
        """
        FILE = MailMergeType.FILE
        """
        The output device is a file.
        """
        MAIL = MailMergeType.MAIL
        """
        The output is sent as e-Mail.
        """
        SHELL = MailMergeType.SHELL
        """
        The output is a document shell.
        
        The successful mail merge returns a XTextDocument based component.
        
        **since**
        
            LibreOffice 4.4
        """

__all__ = ['MailMergeType', 'MailMergeTypeEnum']
