# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.text
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class ReferenceFieldPart(metaclass=UnoConstMeta, type_name="com.sun.star.text.ReferenceFieldPart", name_space="com.sun.star.text"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.text.ReferenceFieldPart``"""
        pass

    class ReferenceFieldPartEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.text.ReferenceFieldPart", name_space="com.sun.star.text"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.text.ReferenceFieldPart`` as Enum values"""
        pass

else:
    from ...lo.text.reference_field_part import ReferenceFieldPart as ReferenceFieldPart

    class ReferenceFieldPartEnum(IntEnum):
        """
        Enum of Const Class ReferenceFieldPart

        These constants define how the reference position is displayed in reference text fields.
        
        **since**
        
            OOo 3.0
        """
        PAGE = ReferenceFieldPart.PAGE
        """
        The page number is displayed using Arabic numbers.
        """
        CHAPTER = ReferenceFieldPart.CHAPTER
        """
        The number of the chapter is displayed.
        """
        TEXT = ReferenceFieldPart.TEXT
        """
        The reference text is displayed.
        
        If the source of the reference is a sequence field, then the complete text of the paragraph is displayed. This is useful to reference to captions.
        """
        UP_DOWN = ReferenceFieldPart.UP_DOWN
        """
        The reference is displayed as one of the (localized) words, \"above\" or \"below\".
        """
        PAGE_DESC = ReferenceFieldPart.PAGE_DESC
        """
        The page number is displayed using the numbering type defined in the page style of the reference position.
        """
        CATEGORY_AND_NUMBER = ReferenceFieldPart.CATEGORY_AND_NUMBER
        """
        The category and the number of a caption is displayed.
        
        This option is only valid if the source of the reference is a sequence field.
        """
        ONLY_CAPTION = ReferenceFieldPart.ONLY_CAPTION
        """
        The caption text of a caption is displayed.
        
        This option is only valid if the source of the reference is a sequence field.
        """
        ONLY_SEQUENCE_NUMBER = ReferenceFieldPart.ONLY_SEQUENCE_NUMBER
        """
        The number of a sequence field is displayed.
        
        This option is only valid if the source of the reference is a sequence field.
        """
        NUMBER = ReferenceFieldPart.NUMBER
        """
        The numbering label and depending of the reference field context numbering labels of superior list levels of the reference are displayed.
        
        This option is only valid, if the source of the reference is a bookmark or a set reference.
        
        The contents of the list label of the paragraph, at which the bookmark respectively the set reference starts - named \"referenced item\" in the following - is displayed. To unambiguous identify the referenced item at the document position of the reference text field, the content of all needed superior levels are added in front. The needed superior levels of the referenced item are the ones, which differ from the superior levels of the document position of the reference text field. Additional condition, which suppresses the addition of a superior level's list label content: The list label of the referenced item can already contain numbers of a superior levels. Assume X be the level of the most superior level, then no list label content of superior levels greater or equal than X are added. If the referenced item isn't numbered, nothing is displayed.
        
        **since**
        
            OOo 3.0
        """
        NUMBER_NO_CONTEXT = ReferenceFieldPart.NUMBER_NO_CONTEXT
        """
        The numbering label of the reference is displayed.
        
        This option is only valid, if the source of the reference is a bookmark or a set reference.
        
        The contents of the list label of the paragraph, at which the bookmark respectively the set reference starts, is displayed. If this paragraph isn't numbered, nothing is displayed.
        
        **since**
        
            OOo 3.0
        """
        NUMBER_FULL_CONTEXT = ReferenceFieldPart.NUMBER_FULL_CONTEXT
        """
        The numbering label and numbering labels of superior list levels of the reference are displayed.
        
        This option is only valid, if the source of the reference is a bookmark or a set reference.
        
        The contents of the list label of the paragraph, at which the bookmark respectively the set reference starts - named \"referenced item\" in the following - is displayed and the contents of all list labels of superior levels are added in front of it. Additional condition, which suppresses the addition of a superior level's list label content: The list label of the referenced item can already contain numbers of a superior levels. Assume X be the level of the most superior level, then no list label content of superior levels greater or equal than X are added. If the referenced item is numbered nothing is displayed.
        
        **since**
        
            OOo 3.0
        """

__all__ = ['ReferenceFieldPart', 'ReferenceFieldPartEnum']
