# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.text
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class TemplateDisplayFormat(metaclass=UnoConstMeta, type_name="com.sun.star.text.TemplateDisplayFormat", name_space="com.sun.star.text"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.text.TemplateDisplayFormat``"""
        pass

    class TemplateDisplayFormatEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.text.TemplateDisplayFormat", name_space="com.sun.star.text"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.text.TemplateDisplayFormat`` as Enum values"""
        pass

else:
    from ...lo.text.template_display_format import TemplateDisplayFormat as TemplateDisplayFormat

    class TemplateDisplayFormatEnum(IntEnum):
        """
        Enum of Const Class TemplateDisplayFormat

        These constants are used to specify which information about a template is displayed in a field.
        """
        FULL = TemplateDisplayFormat.FULL
        PATH = TemplateDisplayFormat.PATH
        NAME = TemplateDisplayFormat.NAME
        """
        Only the file name, without file extension, of the template file will be displayed.
        """
        NAME_AND_EXT = TemplateDisplayFormat.NAME_AND_EXT
        """
        The file name and the file extension of the template file will be displayed.
        """
        AREA = TemplateDisplayFormat.AREA
        """
        The name of the template area is displayed.
        """
        TITLE = TemplateDisplayFormat.TITLE
        """
        The title of the template file is displayed.
        """

__all__ = ['TemplateDisplayFormat', 'TemplateDisplayFormatEnum']
