# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.ucb
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class ListActionType(metaclass=UnoConstMeta, type_name="com.sun.star.ucb.ListActionType", name_space="com.sun.star.ucb"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.ucb.ListActionType``"""
        pass

    class ListActionTypeEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.ucb.ListActionType", name_space="com.sun.star.ucb"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.ucb.ListActionType`` as Enum values"""
        pass

else:
    from ...lo.ucb.list_action_type import ListActionType as ListActionType

    class ListActionTypeEnum(IntEnum):
        """
        Enum of Const Class ListActionType

        These values are used to specify the type of change happened to a list.
        
        A change happened is sent from an XDynamicResultSet as ListAction to a XDynamicResultSetListener.
        
        The values are contained in ListAction.ListActionType.
        """
        WELCOME = ListActionType.WELCOME
        """
        First notification to a single listener for purpose of initialization.
        
        This type of notification is required to be sent first and only once to a new listener.
        
        The member ListAction.ActionInfo is required to contain a struct WelcomeDynamicResultSetStruct. This struct contains two com.sun.star.sdbc.XResultSets (old and new). During and after the notification only the new set is valid for access. But the listener is required to remind both com.sun.star.sdbc.XResultSets as he will not get another chance to get them again.
        
        The members ListAction.Count and ListAction.Position are not used.
        """
        INSERTED = ListActionType.INSERTED
        """
        One or more rows were inserted into the list.
        
        This action is related to ContentAction.INSERTED.
        
        The members ListAction.Count and ListAction.Position contain the position and count of newly inserted rows. If the count is greater than one, the inserted rows have to be one after the other.
        
        ListAction.ActionInfo could contain something but this is not required. For example, it could contain the properties of the new rows (i.e. for remote optimizing), but this is not required nor unrestrictedly recommended.
        """
        REMOVED = ListActionType.REMOVED
        """
        One or more rows were removed from the list.
        
        This action is related to ContentAction.REMOVED.
        
        The members ListAction.Count and ListAction.Position contain the position and count of the removed rows. If the count is greater than one, the removed rows have to be one after the other.
        
        The member ListAction.ListActionType is not used.
        """
        CLEARED = ListActionType.CLEARED
        """
        The whole list was destroyed and independently rebuild.
        
        If \"CLEARED\" is sent you don't need to refer to the old ResultSet.
        
        The members ListAction.ListActionType, ListAction.Count and ListAction.Position are ignored.
        """
        MOVED = ListActionType.MOVED
        """
        One or more rows were moved to another position.
        
        The members ListAction.Count and ListAction.Position contain the position and count of the moved rows. If the count is greater than one, the moved rows have to be one after the other.
        
        ListAction.ListActionType is required to contain a \"long\", which gives the shift of position. (i.e. When two rows at position 3 and 4 are moved for a shift \"+1\", they will appear at the positions 4 and 5. In this action is included, that the row on old position 5 now appears on position 3. No other notification is needed, to explain or complete this action).
        """
        PROPERTIES_CHANGED = ListActionType.PROPERTIES_CHANGED
        """
        The properties of one or more rows have changed.
        
        This action is related to a com.sun.star.beans.PropertyChangeEvent.
        
        The members ListAction.Count and ListAction.Position contain the position and count of the rows, whose properties have changed. If the count is greater than one, the rows with modified properties have to be one after the other.
        
        ListAction.ActionInfo could contain something but this is not required. For example, it could contain the new properties (i.e. for remote optimizing), but this is not required nor unrestrictedly recommended.
        """
        COMPLETED = ListActionType.COMPLETED

__all__ = ['ListActionType', 'ListActionTypeEnum']
