# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.view
from enum import IntEnum
from typing import TYPE_CHECKING
from ooo.oenv.env_const import UNO_ENVIRONMENT, UNO_RUNTIME

_DYNAMIC = False
if (not TYPE_CHECKING) and UNO_RUNTIME and UNO_ENVIRONMENT:
    _DYNAMIC = True

if not TYPE_CHECKING and _DYNAMIC:
    from ooo.helper.enum_helper import UnoConstMeta, ConstEnumMeta

    class DuplexMode(metaclass=UnoConstMeta, type_name="com.sun.star.view.DuplexMode", name_space="com.sun.star.view"):
        """Dynamic Class. Contains all the constant values of ``com.sun.star.view.DuplexMode``"""
        pass

    class DuplexModeEnum(IntEnum, metaclass=ConstEnumMeta, type_name="com.sun.star.view.DuplexMode", name_space="com.sun.star.view"):
        """Dynamic Enum. Contains all the constant values of ``com.sun.star.view.DuplexMode`` as Enum values"""
        pass

else:
    from ...lo.view.duplex_mode import DuplexMode as DuplexMode

    class DuplexModeEnum(IntEnum):
        """
        Enum of Const Class DuplexMode

        These constants specify available duplex modes.
        """
        UNKNOWN = DuplexMode.UNKNOWN
        """
        specifies an unknown duplex mode.
        """
        OFF = DuplexMode.OFF
        """
        specifies that there is no duplex mode enabled
        """
        LONGEDGE = DuplexMode.LONGEDGE
        """
        specifies a long edge duplex mode
        """
        SHORTEDGE = DuplexMode.SHORTEDGE
        """
        specifies a short edge duplex mode
        """

__all__ = ['DuplexMode', 'DuplexModeEnum']
