# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.accessibility


class AccessibleTableModelChangeType(object):
    """
    Const Class

    Type of a change made to a table model.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API AccessibleTableModelChangeType <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1accessibility_1_1AccessibleTableModelChangeType.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.accessibility'
    __ooo_full_ns__: str = 'com.sun.star.accessibility.AccessibleTableModelChangeType'
    __ooo_type_name__: str = 'const'

    UPDATE = 3
    """
    Some of the table data has changed.
    
    The number of rows and columns remains unchanged. Only (some of) the content of the cells in the range that is specified by the fields of the AccessibleTableModelChange structure have been changed.
    """
    ROWS_INSERTED = 4
    """
    One or more rows have been inserted.
    
    Use the fields of the AccessibleTableModelChange structure to determine the indices of the rows that have been inserted. Column indices should be set to -1.
    
    **since**
    
        LibreOffice 7.4
    """
    COLUMNS_INSERTED = 5
    """
    One or more columns have been inserted.
    
    Use the fields of the AccessibleTableModelChange structure to determine the indices of the columns that have been inserted. Row indices should be set to -1.
    
    **since**
    
        LibreOffice 7.4
    """
    ROWS_REMOVED = 6
    """
    One or more rows have been removed.
    
    Use the fields of the AccessibleTableModelChange structure to determine the indices of the rows that have been removed. Column indices should be set to -1.
    
    **since**
    
        LibreOffice 7.4
    """
    COLUMNS_REMOVED = 7
    """
    One or more columns have been removed.
    
    Use the fields of the AccessibleTableModelChange structure to determine the indices of the columns that have been removed. Row indices should be set to -1.
    
    **since**
    
        LibreOffice 7.4
    """

__all__ = ['AccessibleTableModelChangeType']
