# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class Selection(object):
    """
    Struct Class

    specifies a numerical range.

    See Also:
        `API Selection <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1Selection.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.Selection'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.Selection'
    """Literal Constant ``com.sun.star.awt.Selection``"""

    def __init__(self, Min: typing.Optional[int] = 0, Max: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Min (int, optional): Min value.
            Max (int, optional): Max value.
        """
        super().__init__()

        if isinstance(Min, Selection):
            oth: Selection = Min
            self.Min = oth.Min
            self.Max = oth.Max
            return

        kargs = {
            "Min": Min,
            "Max": Max,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._min = kwargs["Min"]
        self._max = kwargs["Max"]


    @property
    def Min(self) -> int:
        """
        specifies the lower limit of the range.
        """
        return self._min
    
    @Min.setter
    def Min(self, value: int) -> None:
        self._min = value

    @property
    def Max(self) -> int:
        """
        specifies the upper limit of the range.
        """
        return self._max
    
    @Max.setter
    def Max(self, value: int) -> None:
        self._max = value


__all__ = ['Selection']
