# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.awt


class SystemPointer(object):
    """
    Const Class

    specifies the shape of a mouse pointer.

    See Also:
        `API SystemPointer <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1awt_1_1SystemPointer.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.SystemPointer'
    __ooo_type_name__: str = 'const'

    ARROW = 0
    """
    specifies the normal arrow-like mouse pointer.
    """
    INVISIBLE = 1
    """
    specifies an invisible mouse pointer.
    """
    WAIT = 2
    """
    specifies a waiting symbol as a mouse pointer (for example hourglass).
    """
    TEXT = 3
    """
    specifies a mouse pointer for text (cursor-like).
    """
    HELP = 4
    """
    specifies a mouse pointer for on-line help.
    """
    CROSS = 5
    """
    specifies a cross as a mouse pointer.
    """
    MOVE = 6
    """
    specifies a mouse pointer which symbolizes movement.
    """
    NSIZE = 7
    """
    specifies a mouse pointer which symbolizes resizing for a top border.
    """
    SSIZE = 8
    """
    specifies a mouse pointer which symbolizes resizing for a bottom border.
    """
    WSIZE = 9
    """
    specifies a mouse pointer which symbolizes resizing for a left border.
    """
    ESIZE = 10
    """
    specifies a mouse pointer which symbolizes resizing for a right border.
    """
    NWSIZE = 11
    """
    specifies a mouse pointer which symbolizes resizing for the top-left corner.
    """
    NESIZE = 12
    """
    specifies a mouse pointer which symbolizes resizing for the top-right corner.
    """
    SWSIZE = 13
    """
    specifies a mouse pointer which symbolizes resizing for the bottom-left corner.
    """
    SESIZE = 14
    """
    specifies a mouse pointer which symbolizes resizing for the bottom-right corner.
    """
    WINDOW_NSIZE = 15
    """
    specifies a mouse pointer which symbolizes window resizing for a top border.
    """
    WINDOW_SSIZE = 16
    """
    specifies a mouse pointer which symbolizes window resizing for a bottom border.
    """
    WINDOW_WSIZE = 17
    """
    specifies a mouse pointer which symbolizes window resizing for a left border.
    """
    WINDOW_ESIZE = 18
    """
    specifies a mouse pointer which symbolizes window resizing for a right border.
    """
    WINDOW_NWSIZE = 19
    """
    specifies a mouse pointer which symbolizes window resizing for the top-left corner.
    """
    WINDOW_NESIZE = 20
    """
    specifies a mouse pointer which symbolizes window resizing for the top-right corner.
    """
    WINDOW_SWSIZE = 21
    """
    specifies a mouse pointer which symbolizes window resizing for the bottom-left corner.
    """
    WINDOW_SESIZE = 22
    """
    specifies a mouse pointer which symbolizes window resizing for the bottom-right corner.
    """
    HSPLIT = 23
    """
    specifies a mouse pointer which symbolizes horizontal splitting.
    """
    VSPLIT = 24
    """
    specifies a mouse pointer which symbolizes vertical splitting.
    """
    HSIZEBAR = 25
    """
    specifies a mouse pointer which symbolizes horizontal resizing.
    """
    VSIZEBAR = 26
    """
    specifies a mouse pointer which symbolizes vertical resizing.
    """
    HAND = 27
    """
    specifies a hand symbol as mouse pointer.
    """
    REFHAND = 28
    """
    specifies a pointing hand symbol as mouse pointer.
    """
    PEN = 29
    """
    specifies a pen symbol as mouse pointer.
    """
    MAGNIFY = 30
    """
    specifies a magnify symbol as mouse pointer.
    """
    FILL = 31
    """
    specifies a fill symbol as mouse pointer.
    """
    ROTATE = 32
    """
    specifies a rotate symbol as mouse pointer.
    """
    HSHEAR = 33
    """
    specifies a horizontal shear symbol as mouse pointer.
    """
    VSHEAR = 34
    """
    specifies a vertical shear symbol as mouse pointer.
    """
    MIRROR = 35
    """
    specifies a mirror symbol as mouse pointer.
    """
    CROOK = 36
    """
    specifies a crook symbol as mouse pointer.
    """
    CROP = 37
    """
    specifies a crop symbol as mouse pointer.
    """
    MOVEPOINT = 38
    """
    specifies a mouse pointer which symbolizes moving a point.
    """
    MOVEBEZIERWEIGHT = 39
    """
    specifies a mouse pointer which symbolizes moving a Bezier weight.
    """
    MOVEDATA = 40
    """
    specifies a mouse pointer which symbolizes moving data.
    """
    COPYDATA = 41
    """
    specifies a mouse pointer which symbolizes copying data.
    """
    LINKDATA = 42
    """
    specifies a mouse pointer which symbolizes linking data.
    """
    MOVEDATALINK = 43
    """
    specifies a mouse pointer which symbolizes moving a data link.
    """
    COPYDATALINK = 44
    """
    specifies a mouse pointer which symbolizes copying a data link.
    """
    MOVEFILE = 45
    """
    specifies a mouse pointer which symbolizes moving a file.
    """
    COPYFILE = 46
    """
    specifies a mouse pointer which symbolizes copying a file.
    """
    LINKFILE = 47
    """
    specifies a mouse pointer which symbolizes linking a file.
    """
    MOVEFILELINK = 48
    """
    specifies a mouse pointer which symbolizes moving a file link.
    """
    COPYFILELINK = 49
    """
    specifies a mouse pointer which symbolizes copying a file link.
    """
    MOVEFILES = 50
    """
    specifies a mouse pointer which symbolizes moving multiple files.
    """
    COPYFILES = 51
    """
    specifies a mouse pointer which symbolizes copying multiple files.
    """
    NOTALLOWED = 52
    """
    specifies a mouse pointer which symbolizes \"not allowed\".
    """
    DRAW_LINE = 53
    """
    specifies a mouse pointer which symbolizes drawing a line.
    """
    DRAW_RECT = 54
    """
    specifies a mouse pointer which symbolizes drawing a rectangle.
    """
    DRAW_POLYGON = 55
    """
    specifies a mouse pointer which symbolizes drawing a polygon.
    """
    DRAW_BEZIER = 56
    """
    specifies a mouse pointer which symbolizes drawing a Bezier.
    """
    DRAW_ARC = 57
    """
    specifies a mouse pointer which symbolizes drawing an arc.
    """
    DRAW_PIE = 58
    """
    specifies a mouse pointer which symbolizes drawing a pie.
    """
    DRAW_CIRCLECUT = 59
    """
    specifies a mouse pointer which symbolizes drawing a circle cut.
    """
    DRAW_ELLIPSE = 60
    """
    specifies a mouse pointer which symbolizes drawing an ellipse.
    """
    DRAW_FREEHAND = 61
    """
    specifies a mouse pointer which symbolizes drawing free handed.
    """
    DRAW_CONNECT = 62
    """
    specifies a mouse pointer which symbolizes drawing a connector.
    """
    DRAW_TEXT = 63
    """
    specifies a mouse pointer which symbolizes drawing text.
    """
    DRAW_CAPTION = 64
    """
    specifies a mouse pointer which symbolizes drawing a text caption.
    """
    CHART = 65
    """
    specifies a mouse pointer which symbolizes a chart.
    """
    DETECTIVE = 66
    """
    specifies a mouse pointer which symbolizes a detective.
    """
    PIVOT_COL = 67
    """
    specifies a mouse pointer which symbolizes a pivot column.
    """
    PIVOT_ROW = 68
    """
    specifies a mouse pointer which symbolizes a pivot row.
    """
    PIVOT_FIELD = 69
    """
    specifies a mouse pointer which symbolizes a pivot field.
    """
    CHAIN = 70
    """
    specifies a mouse pointer which symbolizes a chain.
    """
    CHAIN_NOTALLOWED = 71
    """
    specifies a mouse pointer which symbolizes \"chaining not allowed\".
    """

__all__ = ['SystemPointer']
