# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.awt
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class XFontMappingUseItem(object):
    """
    Struct Class

    Information about a font mapping that took place.
    
    **since**
    
        LibreOffice 7.3

    See Also:
        `API XFontMappingUseItem <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1awt_1_1XFontMappingUseItem.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.XFontMappingUseItem'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.awt.XFontMappingUseItem'
    """Literal Constant ``com.sun.star.awt.XFontMappingUseItem``"""

    def __init__(self, usedFonts: typing.Optional[typing.Tuple[str, ...]] = (), originalFont: typing.Optional[str] = '', count: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            usedFonts (typing.Tuple[str, ...], optional): usedFonts value.
            originalFont (str, optional): originalFont value.
            count (int, optional): count value.
        """
        super().__init__()

        if isinstance(usedFonts, XFontMappingUseItem):
            oth: XFontMappingUseItem = usedFonts
            self.usedFonts = oth.usedFonts
            self.originalFont = oth.originalFont
            self.count = oth.count
            return

        kargs = {
            "usedFonts": usedFonts,
            "originalFont": originalFont,
            "count": count,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._used_fonts = kwargs["usedFonts"]
        self._original_font = kwargs["originalFont"]
        self._count = kwargs["count"]


    @property
    def usedFonts(self) -> typing.Tuple[str, ...]:
        """
        A list of fonts that were actually used, in their order.
        
        Each font is identified as family name or 'familyName/styleName' (if style name is not empty).
        """
        return self._used_fonts
    
    @usedFonts.setter
    def usedFonts(self, value: typing.Tuple[str, ...]) -> None:
        self._used_fonts = value

    @property
    def originalFont(self) -> str:
        """
        The family name or 'familyName/styleName' (if style name is not empty) of the requested font.
        """
        return self._original_font
    
    @originalFont.setter
    def originalFont(self, value: str) -> None:
        self._original_font = value

    @property
    def count(self) -> int:
        """
        The number of times this mapping took place.
        """
        return self._count
    
    @count.setter
    def count(self, value: int) -> None:
        self._count = value


__all__ = ['XFontMappingUseItem']
