# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.awt
import typing
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .x_spin_listener import XSpinListener as XSpinListener_afee0b8c

class XSpinField(XInterface_8f010a43):
    """
    gives access to the value of a spin field and makes it possible to register for spin events.

    See Also:
        `API XSpinField <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1awt_1_1XSpinField.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.awt'
    __ooo_full_ns__: str = 'com.sun.star.awt.XSpinField'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.awt.XSpinField'

    @abstractmethod
    def addSpinListener(self, l: 'XSpinListener_afee0b8c') -> None:
        """
        registers a listener for spin events.
        """
        ...
    @abstractmethod
    def down(self) -> None:
        """
        decreases the value by one step.
        """
        ...
    @abstractmethod
    def enableRepeat(self, bRepeat: bool) -> None:
        """
        enables/disables automatic repeat mode.
        """
        ...
    @abstractmethod
    def first(self) -> None:
        """
        sets the value to the previously set lower value.
        """
        ...
    @abstractmethod
    def last(self) -> None:
        """
        sets the value to the previously set upper value.
        """
        ...
    @abstractmethod
    def removeSpinListener(self, l: 'XSpinListener_afee0b8c') -> None:
        """
        unregisters a listener for spin events.
        """
        ...
    @abstractmethod
    def up(self) -> None:
        """
        increases the value by one step.
        """
        ...

__all__ = ['XSpinField']

