# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.beans
# Libre Office Version: 7.4
from ooo.oenv.env_const import UNO_NONE
import typing


class SetPropertyTolerantFailed(object):
    """
    Struct Class

    specifies information about a single property failed to be set.

    See Also:
        `API SetPropertyTolerantFailed <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1beans_1_1SetPropertyTolerantFailed.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.beans'
    __ooo_full_ns__: str = 'com.sun.star.beans.SetPropertyTolerantFailed'
    __ooo_type_name__: str = 'struct'
    typeName: str = 'com.sun.star.beans.SetPropertyTolerantFailed'
    """Literal Constant ``com.sun.star.beans.SetPropertyTolerantFailed``"""

    def __init__(self, Name: typing.Optional[str] = '', Result: typing.Optional[int] = 0) -> None:
        """
        Constructor

        Arguments:
            Name (str, optional): Name value.
            Result (int, optional): Result value.
        """
        super().__init__()

        if isinstance(Name, SetPropertyTolerantFailed):
            oth: SetPropertyTolerantFailed = Name
            self.Name = oth.Name
            self.Result = oth.Result
            return

        kargs = {
            "Name": Name,
            "Result": Result,
        }
        self._init(**kargs)

    def _init(self, **kwargs) -> None:
        self._name = kwargs["Name"]
        self._result = kwargs["Result"]


    @property
    def Name(self) -> str:
        """
        specifies the name of the property.
        """
        return self._name
    
    @Name.setter
    def Name(self, value: str) -> None:
        self._name = value

    @property
    def Result(self) -> int:
        """
        specifies the success or error code for setting the properties value.
        
        Since the property was not successful set the result will never be com.sun.star.beans.TolerantPropertySetResultType.SUCCESS.
        """
        return self._result
    
    @Result.setter
    def Result(self, value: int) -> None:
        self._result = value


__all__ = ['SetPropertyTolerantFailed']
