# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.chart2.data
from abc import abstractmethod
from ...uno.x_interface import XInterface as XInterface_8f010a43

class XRangeXMLConversion(XInterface_8f010a43):
    """
    An application that provides data for a chart must implement this interface.

    See Also:
        `API XRangeXMLConversion <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1chart2_1_1data_1_1XRangeXMLConversion.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.chart2.data'
    __ooo_full_ns__: str = 'com.sun.star.chart2.data.XRangeXMLConversion'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.chart2.data.XRangeXMLConversion'

    @abstractmethod
    def convertRangeFromXML(self, aXMLRange: str) -> str:
        """
        converts an XML-style range into the internal DataProvider's format.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    @abstractmethod
    def convertRangeToXML(self, aRangeRepresentation: str) -> str:
        """
        converts the range to a valid XML syntax.
        
        For example spreadsheet ranges consisting of more than one consecutive region are usually separated by a semicolon whereas in XML you separate multiple regions by a space.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...

__all__ = ['XRangeXMLConversion']

