# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.container
from abc import abstractmethod
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XChild(XInterface_8f010a43):
    """
    provides access to the parent of the object.
    
    This interface normally is only supported if the objects all have exactly one dedicated parent container.

    See Also:
        `API XChild <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1container_1_1XChild.html>`_
    """
    __ooo_ns__: str = 'com.sun.star.container'
    __ooo_full_ns__: str = 'com.sun.star.container.XChild'
    __ooo_type_name__: str = 'interface'
    __pyunointerface__: str = 'com.sun.star.container.XChild'

    @abstractmethod
    def getParent(self) -> 'XInterface_8f010a43':
        """
        grants access to the object containing this content.
        """
        ...
    @abstractmethod
    def setParent(self, Parent: 'XInterface_8f010a43') -> None:
        """
        sets the parent to this object.

        Raises:
            com.sun.star.lang.NoSupportException: ``NoSupportException``
        """
        ...

__all__ = ['XChild']

